#include "hp-timing.h"
#include "perf.h"

/* SI tests access a variable in Static TLS.  tvalie is expected to
   alias tval in the main executable, but here it uses the Initial
   Exec access model.  */
extern __thread long tvalie __attribute((tls_model("initial-exec")));
NTLS_TESTS_AL (SE, tvalie);

/* SR tests access also the same variable, but getting the compiler to
   generate code for the General Dynamic model, and then have the
   linker relax it to the Initial Exec model, because the variable is
   actually accessed using the tvalie symbol, which is known at link
   time to be accessible with initial-exec code sequences.  A smarter
   compiler might follow the symbol alias and emit more efficient code
   in the first place, and then we'd need further linking tricks to
   trick the compiler into generating GD.  We don't need that now
   though.  */
extern __thread long tvalrl asm("tvalie");
NTLS_TESTS_AL (SR, tvalrl);

/* SG tests access a variable in Static TLS using the General Dynamic
   access model.  tval is supposed to be defined in the main
   executable, so a shared library containing this code will not know
   it could be accessed with initial-exec.  */
extern __thread long tval;
NTLS_TESTS_AL (SG, tval);

/* DG tests access a local variable using the General Dynamic model.
   It probably won't use the Local Dynamic model since it doesn't make
   sense to use it for a single variable.  This will generally be
   slower than the gd test because this code goes in a dlopened
   library, and its TLS won't fit in in the area reserved for dlopened
   modules' TLS.  */
static __thread long __attribute__((used)) ltarr[8192];
__thread long ltval;
NTLS_TESTS_AL (DG, ltval);

/* DC tests accesses multiple variables, in an attempt to simulate a
   more complex scenario and balance the various access models.  */
NTLS_TESTS_IX (ADC, &tvalrl - &tval + &ltval);
NTLS_TESTS_IX (LDC,  tvalrl -  tval +  ltval);
