#! /bin/awk -f
BEGIN {
  line2[0] = "OIE"; line2n[0] = "SE";
  line2[1] = "RIE"; line2n[1] = "SR";
  line2[2] = "SGD"; line2n[2] = "SG";
  line2[3] = "DGD"; line2n[3] = "DG";
  line2[4] = "Cmb"; line2n[4] = "DC";
  line1[0] = "load"; 
  line1[1] = "addr";
}
/^name: min, avg over [0-9]+ runs \(estimated timing overhead is [0-9]+\)$/ {
  runs=$5; ovh=$11 + 0; avgs = 1; next; }
/^name: min in [0-9]+ runs \(estimated timing overhead is [0-9]+\)$/ {
  runs=$4; ovh=$10 + 0; avgs = 0; next; }
/^name: min in [0-9]+ runs \(estimated timing overhead is [0-9]+\) min, avg over [0-9]+ runs \(estimated timing overhead is [0-9]+\)$/ {
  runs=$4 " and " $14; ovh=$10 + 0; avgs = 1; next; }
/^name: min, avg over [0-9]+ runs \(estimated timing overhead is [0-9]+\) min in [0-9]+ runs \(estimated timing overhead is [0-9]+\)$/ {
  runs=$14 " and " $5; ovh=$20 + 0; avgs = 1; next; }
{ idx = 0; }
/^n/ { idx += 1; }
/^...\.V/ { idx += 2; }
/^...\..X/ { idx += 4; }
/^...\...A/ { idx += 8; }
/^...\....SR/ { idx += 16; }
/^...\....SG/ { idx += 32; }
/^...\....DG/ { idx += 48; }
/^...\....DC/ { idx += 64; }
# for -t results alone
/^[no](32|64)\.[NV][IX][AL](SE|SR|SG|DG|DC): [0-9]+$/ {
  min[idx] = $2+0; }
# for -r results alone
/^[no](32|64)\.[NV][IX][AL](SE|SR|SG|DG|DC): [0-9]+, [0-9][0-9.]*/ {
  min[idx] = $2+0; avg[idx] = $3; }
# for joined -t and -r results
/^[no](32|64)\.[NV][IX][AL](SE|SR|SG|DG|DC): [0-9]+ [0-9]+, [0-9][0-9.]*/ {
  min[idx] = $2; avg[idx] = $4; }
# for joined -r and -t results
/^[no](32|64)\.[NV][IX][AL](SE|SR|SG|DG|DC): [0-9]+, [0-9][0-9.]* [0-9]+/ {
  min[idx] = $4; avg[idx] = $3; }
END {
  if (!avgs) {
    print "\\begin{tabular}{|l|l|r|r|r|r|r|r|r|r|}";
    print "\\hline";
    print "& & \\multicolumn{4}{|c|}{Internal Timing} & \\multicolumn{4}{|c|}{External Timing} \\\\"
    print "Acc & & \\multicolumn{2}{|c|}{Min St} & \\multicolumn{2}{|c|}{Max St} & \\multicolumn{2}{|c|}{Min St} & \\multicolumn{2}{|c|}{Max St} \\\\"
    print "Mod & Op & Ol & Nu & Ol & Nu & Ol & Nu & Ol & Nu \\\\"
  } else {
    print "\\begin{tabular}{|l|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}";
    print "\\hline";
    print "& & \\multicolumn{8}{|c|}{Internal Timing} & \\multicolumn{8}{|c|}{External Timing} \\\\"
    print "Access & & \\multicolumn{4}{|c|}{Min State} & \\multicolumn{4}{|c|}{Max State} & \\multicolumn{4}{|c|}{Min State} & \\multicolumn{4}{|c|}{Max State} \\\\"
    print "Model & Op & \\multicolumn{2}{|c|}{Old} & \\multicolumn{2}{|c|}{New} & \\multicolumn{2}{|c|}{Old} & \\multicolumn{2}{|c|}{New} & \\multicolumn{2}{|c|}{Old} & \\multicolumn{2}{|c|}{New} & \\multicolumn{2}{|c|}{Old} & \\multicolumn{2}{|c|}{New} \\\\"
    print "& & Min & Avg & Min & Avg & Min & Avg & Min & Avg & Min & Avg & Min & Avg & Min & Avg & Min & Avg \\\\"
  }
  print "\\hline";
  for (am = 0; am <= 4; am++) {
    l = line2[am];
    for (op = 0; op <= 1; op++) {
      l = l " & " line1[op];
      for (tm = 0; tm <= 1; tm++) {
	for (st = 0; st <= 1; st++) {
	  for (on = 0; on <= 1; on++) {
	    idx = am * 16 + op * 8 + tm * 4 + st * 2 + on;
	    l = l " & " min[idx]; # - ovh;
	    if (avgs)
	      l = l " & " sprintf ("%.0f", avg[idx]); #  - ovh);
	  }
	}
      }
      print l " \\\\";
      l = "";
    }
    print "\\hline";
  }
  print "\\end{tabular}";
  print "\\def\\runs{" runs "\\xspace}\\def\\overhead{" ovh "\\xspace}";
}

