#ifndef _main_h
#define _main_h

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "timing.h"

#include <iostream>

/** This file is supposed to be used as the main program in
    shortest-path solving programs.  It times the time used for
    reading the graph and for computing the shortest paths, then
    outputs the solution to standard error and the measured times to
    standard output.

    It assumes algorithm_t is the class of a shortest-path solving
    algorithm.  */
int main() {
  vtime_t reading; getvtime(reading); // get the starting time
  algorithm_t::graph_t graph(cin); // read the graph in
  algorithm_t algorithm(graph); // initialize the algorithm
  vtime_t run; getvtime(run); // get the end of the reading time
  std::cout << "Reading time: " // output the time; we hope it takes
	    << diffvtime(run,reading) << endl; // a negligible time
  algorithm.run(); // run the algorithm
  vtime_t end; getvtime(end); // get the ending time
  std::cerr << graph << endl; // output the solution to stderr
  std::cout << "Solving time: " // output the solving time
	    << diffvtime(end,run) << endl;
  algorithm.summarize(std::cout); // output an execution summary
}

#endif
