#ifndef _adjlist_h
#define _adjlist_h

// $Id: adjlist.h,v 1.3 1998/11/27 13:07:07 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <vector>

/** A default adjacency list type.  Despite the name, it is actually a
    vector of arcs, but the indexes in the vector are unrelated with
    the tail or the head of the arc.

    An adjacency list must be a STL container, such as list or deque.
    An adjlist implementation must provide at least forward iterators,
    begin(), end() and a nested type arc_t.  */
template <class arc_T>
class adjlist : public std::vector<arc_T> {
 public:
  /** The type of the contained arcs */
  typedef arc_T arc_t;
};

#endif
