/* CalculosRendIsentos - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.calculos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendIsentos extends Observador
{
  private RendIsentos rendIsentos;
  
  public CalculosRendIsentos (RendIsentos aRendIsentos)
  {
    rendIsentos = aRendIsentos;
  }
  
  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    calculaTotalRendIsentos ();
  }
  
  private void calculaTotalRendIsentos ()
  {
    Valor total = new Valor ();
    calculaAlienacaoGC ();
    total.append ('+', rendIsentos.getBolsaEstudos ());
    total.append ('+', rendIsentos.getResidenciaPronatec ());
    total.append ('+', rendIsentos.getCapitalApolices ());
    total.append ('+', rendIsentos.getIndenizacoes ());
    total.append ('+', rendIsentos.getLucroAlienacao ());
    total.append ('+', rendIsentos.getLucroRecebido ());
    total.append ('+', rendIsentos.getParcIsentaAposentadoria ());
    total.append ('+', rendIsentos.getPensao ());
    total.append ('+', rendIsentos.getPoupanca ());
    total.append ('+', rendIsentos.getRendSocio ());
    total.append ('+', rendIsentos.getTransferencias ());
    total.append ('+', rendIsentos.getIRPFAntCompJud ());
    total.append ('+', rendIsentos.getRendAssalMoedaEstrang ());
    total.append ('+', rendIsentos.getIncorpReservasCapital ());
    total.append ('+', rendIsentos.getMeacaoDissolucao ());
    total.append ('+', rendIsentos.getGanhosLiqAcoes ());
    total.append ('+', rendIsentos.getGanhosCapOuro ());
    total.append ('+', rendIsentos.getRecuperacaoPrejuizosBolsaValores ());
    total.append ('+', rendIsentos.getTransporteCargas ());
    total.append ('+', rendIsentos.getTransportePassageiros ());
    total.append ('+', rendIsentos.getRestitIRPFAnt ());
    total.append ('+', rendIsentos.getOutros ());
    total.append ('+', rendIsentos.getPensaoAlimenticia ());
    rendIsentos.getTotal ().setConteudo (total);
    total = new Valor ();
    total.append ('+', rendIsentos.getBolsaEstudosQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getResidenciaPronatecQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getIndenizacoesQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getLucroRecebidoQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getPensaoQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getPoupancaQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getRendSocioQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getTransferenciasQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getIRPFAntCompJudQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getRendAssalMoedaEstrangQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getIncorpReservasCapitalQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getMeacaoDissolucaoQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getGanhosLiqAcoesQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getGanhosCapOuroQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getOutrosQuadroAuxiliar ().getTotaisDependentes ());
    total.append ('+', rendIsentos.getPensaoAlimenticiaQuadroAuxiliar ().getTotaisDependentes ());
    rendIsentos.getTotalDependentes ().setConteudo (total);
    total = new Valor ();
    total.append ('+', rendIsentos.getTotal ());
    total.append ('-', rendIsentos.getTotalDependentes ());
    rendIsentos.getTotalTitular ().setConteudo (total);
  }
  
  private void calculaAlienacaoGC ()
  {
    Valor totalInf = new Valor ();
    Valor totalTransp = new Valor ();
    totalInf.append ('+', rendIsentos.getBensPequenoValorInformado ());
    totalInf.append ('+', rendIsentos.getUnicoImovelInformado ());
    totalInf.append ('+', rendIsentos.getOutrosBensImoveisInformado ());
    totalInf.append ('+', rendIsentos.getMoedaEstrangeiraEspecieInformado ());
    totalTransp.append ('+', rendIsentos.getBensPequenoValorTransportado ());
    totalTransp.append ('+', rendIsentos.getUnicoImovelTransportado ());
    totalTransp.append ('+', rendIsentos.getOutrosBensImoveisTransportado ());
    totalTransp.append ('+', rendIsentos.getMoedaEstrangeiraEspecieTransportado ());
    rendIsentos.getTotalInformado ().setConteudo (totalInf);
    rendIsentos.getTotalTransportado ().setConteudo (totalTransp);
    Valor total = new Valor ();
    total.append ('+', totalInf);
    total.append ('+', totalTransp);
    rendIsentos.getLucroAlienacao ().setConteudo (total);
  }
}
