/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Logger;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.ItemMovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.BemARExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ReceitaDespesa;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.eleicoes.Doacao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendpf.CPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;

public class ConversorRegistros2ObjetosIRPF {
    private static final Logger logger;

    static {
        Class<ConversorRegistros2ObjetosIRPF> clazz = ConversorRegistros2ObjetosIRPF.class;
        logger = Logger.getLogger(clazz.getName());
    }

    public String getNumReciboComDV(String string) {
        if (string.trim().length() == 10) {
            String string2 = "" + Validador.calcularModulo11(string, null, 2);
            String string3 = "" + Validador.calcularModulo11(String.valueOf(string) + string2, null, 2);
            return String.valueOf(string) + string2 + string3;
        }
        return string;
    }

    public IdentificadorDeclaracao montarIdDeclaracao(Vector vector, Vector vector2) throws GeracaoTxtException {
        IdentificadorDeclaracao identificadorDeclaracao;
        RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
        String string = registroTxt.fieldByName("NR_CPF").asString();
        boolean bl = IRPFFacade.existeDeclaracao(string);
        if (bl) {
            identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
        } else {
            identificadorDeclaracao = new IdentificadorDeclaracao();
            identificadorDeclaracao.getCpf().setConteudo(string);
            IRPFFacade.criarDeclaracao(identificadorDeclaracao);
        }
        identificadorDeclaracao.getNome().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
        String string2 = registroTxt.fieldByName("IN_RETIFICADORA").asString();
        string2 = string2.equals("S") || string2.equals("1") ? Logico.SIM : Logico.NAO;
        identificadorDeclaracao.getDeclaracaoRetificadora().setConteudo(string2);
        identificadorDeclaracao.getTipoDeclaracao().setConteudo(registroTxt.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
        identificadorDeclaracao.getExercicio().setConteudo(registroTxt.fieldByName("EXERCICIO").asString());
        identificadorDeclaracao.getEnderecoMAC().setConteudo(registroTxt.fieldByName("ENDERECO_MAC").asString());
        try {
            registroTxt = (RegistroTxt)vector2.elementAt(0);
        }
        catch (Exception exception) {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o n\u00e3o encontrado no arquivo.");
        }
        if (!registroTxt.fieldByName("IN_TIPODECLARACAO").asString().equals("A")) {
            throw new GeracaoTxtException("IRPF-Livre ainda n\u00e3o tem suporte para declara\u00e7\u00f5es de sa\u00edda nem de esp\u00f3lio.");
        }
        identificadorDeclaracao.getEnderecoDiferente().setConteudo(registroTxt.fieldByName("IN_ENDERECO").asString());
        if (string2 == Logico.SIM) {
            String string3 = registroTxt.fieldByName("NR_CONTROLE_ORIGINAL").asString();
            identificadorDeclaracao.getNumReciboDecRetif().setConteudo(string3);
        }
        return identificadorDeclaracao;
    }

    public IdentificadorDeclaracao montarIdDeclaracaoAnoAnterior(Vector vector, Vector vector2) {
        try {
            IdentificadorDeclaracao identificadorDeclaracao;
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            String string = registroTxt.fieldByName("NR_CPF").asString();
            if (IRPFFacade.existeDeclaracao(string)) {
                identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
            } else {
                identificadorDeclaracao = new IdentificadorDeclaracao();
                identificadorDeclaracao.getCpf().setConteudo(string);
            }
            identificadorDeclaracao.getNome().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
            identificadorDeclaracao.getDeclaracaoRetificadora().setConteudo("0");
            identificadorDeclaracao.getTipoDeclaracao().setConteudo(registroTxt.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
            identificadorDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            identificadorDeclaracao.getNumeroReciboDecAnterior().setConteudo(registroTxt.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").asString());
            registroTxt = (RegistroTxt)vector2.elementAt(0);
            if (!registroTxt.fieldByName("IN_TIPODECLARACAO").asString().equals("A")) {
                throw new GeracaoTxtException("IRPF-Livre ainda n\u00e3o tem suporte para declara\u00e7\u00f5es de esp\u00f3lio nem de sa\u00edda definitiva.");
            }
            return identificadorDeclaracao;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public IdentificadorDeclaracao montarIdDeclaracaoNaoPersistido(Vector vector) {
        try {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            String string = registroTxt.fieldByName("NR_CPF").asString();
            IdentificadorDeclaracao identificadorDeclaracao = new IdentificadorDeclaracao();
            identificadorDeclaracao.getCpf().setConteudo(string);
            identificadorDeclaracao.getNome().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
            try {
                String string2 = registroTxt.fieldByName("EXERCICIO").asString();
                String string3 = null;
                if (string2.equals(ConstantesGlobais.EXERCICIO)) {
                    string3 = registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").asString();
                } else if (string2.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                    string3 = registroTxt.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").asString();
                }
                string3 = this.getNumReciboComDV(string3);
                identificadorDeclaracao.getNumReciboDecRetif().setConteudo(string3);
            }
            catch (Exception exception) {}
            identificadorDeclaracao.getDeclaracaoRetificadora().setConteudo(registroTxt.fieldByName("IN_RETIFICADORA").asString());
            identificadorDeclaracao.getTipoDeclaracao().setConteudo(registroTxt.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
            identificadorDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            return identificadorDeclaracao;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void montarContribuinteIRPF(Vector vector, Contribuinte contribuinte) throws GeracaoTxtException {
        RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
        contribuinte.getTituloEleitor().setConteudo(registroTxt.fieldByName("NR_TITELEITOR").asString());
        contribuinte.getDataNascimento().setConteudo(registroTxt.fieldByName("DT_NASCIM").asString());
        contribuinte.getNaturezaOcupacao().setConteudo(registroTxt.fieldByName("CD_NATUR").asString());
        contribuinte.getOcupacaoPrincipal().setConteudo(registroTxt.fieldByName("CD_OCUP").asString());
        if (registroTxt.fieldByName("SG_UF").asString().toUpperCase().equals("EX")) {
            contribuinte.getExterior().setConteudo(Logico.SIM);
            contribuinte.getCodigoExterior().setConteudo(registroTxt.fieldByName("CD_EX").asString());
            contribuinte.getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
            contribuinte.getCidade().setConteudo(registroTxt.fieldByName("NM_MUNICIP").asString());
            contribuinte.getLogradouroExt().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
            contribuinte.getNumeroExt().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
            contribuinte.getBairroExt().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
            contribuinte.getComplementoExt().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
        } else {
            contribuinte.getExterior().setConteudo(Logico.NAO);
            contribuinte.getPais().setConteudo("105");
            contribuinte.getLogradouro().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
            contribuinte.getNumero().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
            contribuinte.getBairro().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
            contribuinte.getComplemento().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
        }
        contribuinte.getNitPisPasep().setConteudo(registroTxt.fieldByName("NR_NITPISPASEP").asString());
        contribuinte.getCpfConjuge().setConteudo(registroTxt.fieldByName("NR_CPF_CONJUGE").asString());
        contribuinte.getRegistroProfissional().setConteudo(registroTxt.fieldByName("NR_REGISTRO_PROFISSIONAL").asString());
        contribuinte.getUf().setConteudo(registroTxt.fieldByName("SG_UF").asString());
        contribuinte.getMunicipio().setConteudo(registroTxt.fieldByName("CD_MUNICIP").asString());
        contribuinte.getCep().setConteudo(registroTxt.fieldByName("NR_CEP").asString());
        contribuinte.getTipoLogradouro().setConteudo(registroTxt.fieldByName("TIP_LOGRA").asString());
        contribuinte.getEmail().setConteudo(registroTxt.fieldByName("NM_EMAIL").asString());
        contribuinte.getDddCelular().setConteudo(registroTxt.fieldByName("NR_DDD_CELULAR").asString());
        contribuinte.getCelular().setConteudo(registroTxt.fieldByName("NR_CELULAR").asString());
        contribuinte.getDdd().setConteudo(registroTxt.fieldByName("NR_DDD_TELEFONE").asString());
        contribuinte.getTelefone().setConteudo(registroTxt.fieldByName("NR_TELEFONE").asString());
        contribuinte.getDoencaDeficiencia().setConteudo(registroTxt.fieldByName("IN_DOENCA_DEFICIENCIA").asString().equals("S") ? Logico.SIM : Logico.NAO);
        String string = registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").asString();
        if (string != null && !string.trim().equals("")) {
            string = this.getNumReciboComDV(string);
            contribuinte.getNumeroReciboDecAnterior().setConteudo(string);
        }
    }

    public void montarInformacoesObrigatorias(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
        String string = registroTxt.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1";
        declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo(string);
        declaracaoIRPF.getContribuinte().getEnderecoDiferente().setConteudo(registroTxt.fieldByName("IN_ENDERECO").asBoolean() ? Logico.SIM : Logico.NAO);
        String string2 = registroTxt.fieldByName("IN_RETIFICADORA").asString();
        string2 = string2.equals("S") || string2.equals("1") ? Logico.SIM : Logico.NAO;
        declaracaoIRPF.getIdentificadorDeclaracao().getDeclaracaoRetificadora().setConteudo(string2);
        declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().setConteudo(registroTxt.fieldByName("NR_QUOTAS").asInteger());
        if (declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora()) {
            declaracaoIRPF.getIdentificadorDeclaracao().getNumReciboDecRetif().setConteudoAntigo(registroTxt.fieldByName("NR_CONTROLE_ORIGINAL").asString());
        }
    }

    public void montarInformacoesBancarias(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
        declaracaoIRPF.getResumo().getCalculoImposto().getBanco().setConteudo(registroTxt.fieldByName("NR_BANCO").asString());
        declaracaoIRPF.getResumo().getCalculoImposto().getAgencia().setConteudo(registroTxt.fieldByName("NR_AGENCIA").asString());
        if (registroTxt.fieldByName("IN_TIPO_CONTA") != null) {
            declaracaoIRPF.getResumo().getCalculoImposto().getContaTipo().setConteudo(registroTxt.fieldByName("IN_TIPO_CONTA").asString());
        } else {
            declaracaoIRPF.getResumo().getCalculoImposto().getContaTipo().setConteudo("1");
        }
        declaracaoIRPF.getResumo().getCalculoImposto().getContaCredito().setConteudo(registroTxt.fieldByName("NR_CONTA").asString());
        declaracaoIRPF.getResumo().getCalculoImposto().getDvContaCredito().setConteudo(registroTxt.fieldByName("NR_DV_CONTA").asString());
        String string = registroTxt.fieldByName("IN_DEBITO_AUTOM").asString();
        string = string.equals("S") ? "autorizado" : "N";
        declaracaoIRPF.getResumo().getCalculoImposto().getDebitoAutomatico().setConteudo(string);
    }

    public void montarBem(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getBens().recuperarLista().clear();
        vector = (Vector)vector.clone();
        vector.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2;
                block4: {
                    RegistroTxt registroTxt = (RegistroTxt)object;
                    RegistroTxt registroTxt2 = (RegistroTxt)object2;
                    n2 = registroTxt.fieldByName("NR_CHAVE_BEM").asInteger();
                    n = registroTxt2.fieldByName("NR_CHAVE_BEM").asInteger();
                    if (n2 >= n) break block4;
                    return -1;
                }
                try {
                    if (n2 > n) {
                        return 1;
                    }
                }
                catch (GeracaoTxtException geracaoTxtException) {
                    System.exit(-1);
                }
                return 0;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        int n = 0;
        while (n < vector.size()) {
            Bem bem = new Bem(declaracaoIRPF);
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            if (registroTxt.fieldByName("NR_CHAVE_BEM").asInteger() != n + 1) {
                System.err.println("ATEN\u00c7\u00c3O: o bem gravado com chave " + registroTxt.fieldByName("NR_CHAVE_BEM").asInteger() + " foi restaurado com chave " + (n + 1) + "; quadros auxiliares podem precisar de ajustes.");
            }
            bem.getChave().setConteudo(n + 1);
            bem.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_BEM").asString());
            bem.getCodGrupo().setConteudo(registroTxt.fieldByName("CD_GRUPO_BEM").asString());
            bem.getCodigo().setConteudo(registroTxt.fieldByName("CD_BEM").asString());
            bem.getValorExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_ANTER").asValor());
            bem.getValorExercicioAtual().setConteudo(registroTxt.fieldByName("VR_ATUAL").asValor());
            int n2 = registroTxt.fieldByName("IN_EXTERIOR").asInteger();
            if (n2 == 1) {
                bem.getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
            } else {
                bem.getPais().setConteudo("105");
            }
            bem.getLogradouro().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
            bem.getNumero().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
            bem.getComplemento().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
            bem.getBairro().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
            bem.getCep().setConteudo(registroTxt.fieldByName("NR_CEP").asString());
            bem.getUf().setConteudo(registroTxt.fieldByName("SG_UF").asString());
            bem.getMunicipio().setConteudo(registroTxt.fieldByName("CD_MUNICIP").asString());
            bem.getNomeMunicipio().setConteudo(registroTxt.fieldByName("NM_MUNICIP").asString());
            bem.getRegistrado().setConteudo(registroTxt.fieldByName("NM_IND_REG_IMOV").asString());
            bem.getMatricula().setConteudo(registroTxt.fieldByName("MATRIC_IMOV").asString());
            bem.getAreaTotal().setConteudo(registroTxt.fieldByName("AREA").asValor());
            bem.getUnidade().setConteudo(registroTxt.fieldByName("NM_UNID").asString());
            bem.getNomeCartorio().setConteudo(registroTxt.fieldByName("NM_CARTORIO").asString());
            bem.getDataAquisicao().setConteudo(registroTxt.fieldByName("DT_AQUISICAO").asString());
            bem.getIPTU().setConteudo(registroTxt.fieldByName("NR_IPTU").asString());
            bem.getRenavan().setConteudo(registroTxt.fieldByName("NR_RENAVAN").asString());
            bem.getRegAviaCivil().setConteudo(registroTxt.fieldByName("NR_DEP_AVIACAO_CIVIL").asString());
            bem.getRegCapPortos().setConteudo(registroTxt.fieldByName("NR_CAPITANIA_PORTOS").asString());
            bem.getBanco().setConteudo(registroTxt.fieldByName("NR_BANCO").asString());
            bem.getAgencia().setConteudo(registroTxt.fieldByName("NR_AGENCIA").asString());
            bem.getConta().setConteudo(registroTxt.fieldByName("NR_CONTA").asString());
            bem.getContaDV().setConteudo(registroTxt.fieldByName("NR_DV_CONTA").asString());
            bem.getCPFCNPJ().setConteudo(registroTxt.fieldByName("NM_CPFCNPJ").asString());
            if (!registroTxt.fieldByName("IN_TIPO_BENEFIC").asString().equals(" ")) {
                bem.getCPFTitDep().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
            }
            bem.getCIB().setConteudo(registroTxt.fieldByName("NR_CIB").asString());
            bem.getCEI_CNO().setConteudo(registroTxt.fieldByName("NR_CEI_CNO").asString());
            declaracaoIRPF.getBens().recuperarLista().add(bem);
            ++n;
        }
    }

    public void montarDividas(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getDividas().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            Divida divida = new Divida();
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            divida.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_DIV").asString());
            divida.getCodigo().setConteudo(registroTxt.fieldByName("CD_DIV").asString());
            divida.getValorExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_ANTER").asValor());
            divida.getValorExercicioAtual().setConteudo(registroTxt.fieldByName("VR_ATUAL").asValor());
            divida.getPagamentoAnual().setConteudo(registroTxt.fieldByName("VR_PGTO_ANUAL").asValor());
            declaracaoIRPF.getDividas().recuperarLista().add(divida);
            ++n;
        }
    }

    public void montarRendPJDependentesCompleta(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getColecaoRendPJDependente().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RendPJDependente rendPJDependente = new RendPJDependente(declaracaoIRPF.getIdentificadorDeclaracao());
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            rendPJDependente.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
            rendPJDependente.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
            rendPJDependente.getRendRecebidoPJ().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
            rendPJDependente.getContribuicaoPrevOficial().setConteudo(registroTxt.fieldByName("VR_CONTRIB").asValor());
            rendPJDependente.getImpostoRetidoFonte().setConteudo(registroTxt.fieldByName("VR_IMPOSTO").asValor());
            rendPJDependente.getDecimoTerceiro().setConteudo(registroTxt.fieldByName("VR_DECTERC").asValor());
            rendPJDependente.getIRRFDecimoTerceiro().setConteudo(registroTxt.fieldByName("VR_IRRF13SALARIO").asValor());
            rendPJDependente.getCpfDependente().setConteudo(registroTxt.fieldByName("CPF_BENEF").asString());
            declaracaoIRPF.getColecaoRendPJDependente().recuperarLista().add(rendPJDependente);
            ++n;
        }
    }

    public void montarRendPJDependentesComExigibilidade(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente = new RendPJComExigibilidadeDependente(declaracaoIRPF.getIdentificadorDeclaracao());
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            rendPJComExigibilidadeDependente.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
            rendPJComExigibilidadeDependente.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
            rendPJComExigibilidadeDependente.getRendExigSuspensa().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
            rendPJComExigibilidadeDependente.getDepositoJudicial().setConteudo(registroTxt.fieldByName("VR_DEP_JUDICIAL").asValor());
            rendPJComExigibilidadeDependente.getCpfDependente().setConteudo(registroTxt.fieldByName("CPF_BENEF").asString());
            declaracaoIRPF.getColecaoRendPJDependente().recuperarLista().add(rendPJComExigibilidadeDependente);
            ++n;
        }
    }

    public void montarDeclaracaoCompleta(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            declaracaoIRPF.getImpostoPago().getImpostoPagoExterior().setConteudo(registroTxt.fieldByName("VR_IMPEXT").asValor());
            declaracaoIRPF.getImpostoPago().getImpostoComplementar().setConteudo(registroTxt.fieldByName("VR_IMPCOMP").asValor());
            declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte().setConteudo(registroTxt.fieldByName("VR_IRFONTELEI11033").asValor());
        }
    }

    public void montarRendPJTitularCompleta(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                RendPJTitular rendPJTitular = new RendPJTitular(declaracaoIRPF.getIdentificadorDeclaracao());
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                rendPJTitular.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
                rendPJTitular.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
                rendPJTitular.getRendRecebidoPJ().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
                rendPJTitular.getContribuicaoPrevOficial().setConteudo(registroTxt.fieldByName("VR_CONTRIB").asValor());
                rendPJTitular.getImpostoRetidoFonte().setConteudo(registroTxt.fieldByName("VR_IMPOSTO").asValor());
                rendPJTitular.getDecimoTerceiro().setConteudo(registroTxt.fieldByName("VR_DECTERC").asValor());
                rendPJTitular.getIRRFDecimoTerceiro().setConteudo(registroTxt.fieldByName("VR_IRRF13SALARIO").asValor());
                declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().add(rendPJTitular);
                ++n;
            }
        }
    }

    public void montarRendPJTitularComExigibilidade(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular = new RendPJComExigibilidadeTitular(declaracaoIRPF.getIdentificadorDeclaracao());
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                rendPJComExigibilidadeTitular.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
                rendPJComExigibilidadeTitular.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
                rendPJComExigibilidadeTitular.getRendExigSuspensa().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
                rendPJComExigibilidadeTitular.getDepositoJudicial().setConteudo(registroTxt.fieldByName("VR_DEP_JUDICIAL").asValor());
                declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().recuperarLista().add(rendPJComExigibilidadeTitular);
                ++n;
            }
        }
    }

    public void recuperarRendIsentosNaoTributaveis(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        int n = 0;
        while (n < vector.size()) {
            block10: {
                Valor valor;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("CD_ISENTO");
                switch (campoTXT.asInteger()) {
                    case 3: {
                        valor = rendIsentos.getCapitalApolices();
                        break;
                    }
                    case 8: {
                        valor = rendIsentos.getMoedaEstrangeiraEspecieInformado();
                        break;
                    }
                    case 15: {
                        valor = rendIsentos.getParcIsentaAtivRural();
                        break;
                    }
                    case 22: {
                        valor = rendIsentos.getRecuperacaoPrejuizosBolsaValores();
                        break;
                    }
                    case 23: {
                        valor = rendIsentos.getTransporteCargas();
                        break;
                    }
                    case 24: {
                        valor = rendIsentos.getTransportePassageiros();
                        break;
                    }
                    case 25: {
                        valor = rendIsentos.getRestitIRPFAnt();
                        break;
                    }
                    default: {
                        break block10;
                    }
                }
                valor.setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
            }
            ++n;
        }
    }

    public void recuperarRendIsentosDetalhe2(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        rendIsentos.getMeacaoDissolucaoQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getGanhosLiqAcoesQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getGanhosCapOuroQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block6: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 19: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getMeacaoDissolucaoQuadroAuxiliar();
                        break;
                    }
                    case 20: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getGanhosLiqAcoesQuadroAuxiliar();
                        break;
                    }
                    case 21: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getGanhosCapOuroQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void recuperarRendIsentosDetalhe3(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        rendIsentos.getBolsaEstudosQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getResidenciaPronatecQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getIndenizacoesQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getLucroRecebidoQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getParcIsentaAposentadoriaQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getPoupancaQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getRendSocioQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getTransferenciasQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getIRPFAntCompJudQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getRendAssalMoedaEstrangQuadroAuxiliar().recuperarLista().clear();
        rendIsentos.getIncorpReservasCapitalQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block14: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 1: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getBolsaEstudosQuadroAuxiliar();
                        break;
                    }
                    case 2: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getResidenciaPronatecQuadroAuxiliar();
                        break;
                    }
                    case 4: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getIndenizacoesQuadroAuxiliar();
                        break;
                    }
                    case 9: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getLucroRecebidoQuadroAuxiliar();
                        break;
                    }
                    case 10: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getParcIsentaAposentadoriaQuadroAuxiliar();
                        break;
                    }
                    case 12: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getPoupancaQuadroAuxiliar();
                        break;
                    }
                    case 13: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getRendSocioQuadroAuxiliar();
                        break;
                    }
                    case 14: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getTransferenciasQuadroAuxiliar();
                        break;
                    }
                    case 16: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getIRPFAntCompJudQuadroAuxiliar();
                        break;
                    }
                    case 17: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getRendAssalMoedaEstrangQuadroAuxiliar();
                        break;
                    }
                    case 18: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getIncorpReservasCapitalQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block14;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getCnpjEmpresa().setConteudo(registroTxt.fieldByName("NR_PAGADORA").asString());
                itemQuadroOutrosRendimentos.getNomeFonte().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                itemQuadroOutrosRendimentos.getIndiceDoBem().setConteudo(registroTxt.fieldByName("NR_CHAVE_BEM").asString());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void recuperarRendIsentosDetalhe4(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        rendIsentos.getPensaoQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block4: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 11: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getPensaoQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getCnpjEmpresa().setConteudo(registroTxt.fieldByName("NR_PAGADORA").asString());
                itemQuadroOutrosRendimentos.getNomeFonte().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_RECEB").asValor());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void recuperarRendIsentosDetalhe5(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        rendIsentos.getOutrosQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block4: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 26: {
                        colecaoItemQuadroOutrosRendimentos = rendIsentos.getOutrosQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getCnpjEmpresa().setConteudo(registroTxt.fieldByName("NR_PAGADORA").asString());
                itemQuadroOutrosRendimentos.getNomeFonte().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                itemQuadroOutrosRendimentos.getEspecificacao().setConteudo(registroTxt.fieldByName("NM_DESCRICAO").asString());
                itemQuadroOutrosRendimentos.getIndiceDoBem().setConteudo(registroTxt.fieldByName("NR_CHAVE_BEM").asInteger());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void recuperarRendIsentosDetalhe6(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        int n = 0;
        while (n < vector.size()) {
            block6: {
                Valor valor;
                Valor valor2;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 5: {
                        valor2 = rendIsentos.getBensPequenoValorInformado();
                        valor = rendIsentos.getBensPequenoValorTransportado();
                        break;
                    }
                    case 6: {
                        valor2 = rendIsentos.getUnicoImovelInformado();
                        valor = rendIsentos.getUnicoImovelTransportado();
                        break;
                    }
                    case 7: {
                        valor2 = rendIsentos.getOutrosBensImoveisInformado();
                        valor = rendIsentos.getOutrosBensImoveisTransportado();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                valor2.setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                valor.setConteudo(registroTxt.fieldByName("VR_VALORGCAP").asValor());
            }
            ++n;
        }
    }

    public void recuperarRendTributacaoExclusiva(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendTributacaoExclusiva rendTributacaoExclusiva = declaracaoIRPF.getRendTributacaoExclusiva();
        int n = 0;
        while (n < vector.size()) {
            block11: {
                Valor valor;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("CD_EXCLUSIVO");
                switch (campoTXT.asInteger()) {
                    case 1: {
                        valor = rendTributacaoExclusiva.getDecimoTerceiro();
                        break;
                    }
                    case 2: {
                        valor = rendTributacaoExclusiva.getGanhosCapital();
                        break;
                    }
                    case 3: {
                        valor = rendTributacaoExclusiva.getGanhosCapitalEstrangeira();
                        break;
                    }
                    case 4: {
                        valor = rendTributacaoExclusiva.getGanhosCapitalEmEspecie();
                        break;
                    }
                    case 5: {
                        valor = rendTributacaoExclusiva.getGanhosRendaVariavel();
                        break;
                    }
                    case 7: {
                        valor = rendTributacaoExclusiva.getRRA();
                        break;
                    }
                    case 8: {
                        valor = rendTributacaoExclusiva.getDecimoTerceiroDependentes();
                        break;
                    }
                    case 9: {
                        valor = rendTributacaoExclusiva.getRRADep();
                        break;
                    }
                    default: {
                        break block11;
                    }
                }
                valor.setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
            }
            ++n;
        }
    }

    public void recuperarRendExclusivosDetalhe2(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendTributacaoExclusiva rendTributacaoExclusiva = declaracaoIRPF.getRendTributacaoExclusiva();
        rendTributacaoExclusiva.getRendAplicacoesQuadroAuxiliar().recuperarLista().clear();
        rendTributacaoExclusiva.getJurosCapitalProprioQuadroAuxiliar().recuperarLista().clear();
        rendTributacaoExclusiva.getRendPLRQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block6: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 6: {
                        colecaoItemQuadroOutrosRendimentos = rendTributacaoExclusiva.getRendAplicacoesQuadroAuxiliar();
                        break;
                    }
                    case 10: {
                        colecaoItemQuadroOutrosRendimentos = rendTributacaoExclusiva.getJurosCapitalProprioQuadroAuxiliar();
                        break;
                    }
                    case 11: {
                        colecaoItemQuadroOutrosRendimentos = rendTributacaoExclusiva.getRendPLRQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getCnpjEmpresa().setConteudo(registroTxt.fieldByName("NR_PAGADORA").asString());
                itemQuadroOutrosRendimentos.getNomeFonte().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                itemQuadroOutrosRendimentos.getIndiceDoBem().setConteudo(registroTxt.fieldByName("NR_CHAVE_BEM").asInteger());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void recuperarRendExclusivosDetalhe3(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        RendTributacaoExclusiva rendTributacaoExclusiva = declaracaoIRPF.getRendTributacaoExclusiva();
        rendTributacaoExclusiva.getOutrosQuadroAuxiliar().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            block4: {
                ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos;
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                CampoTXT campoTXT = registroTxt.fieldByName("NR_COD");
                switch (campoTXT.asInteger()) {
                    case 12: {
                        colecaoItemQuadroOutrosRendimentos = rendTributacaoExclusiva.getOutrosQuadroAuxiliar();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos = (ItemQuadroOutrosRendimentos)colecaoItemQuadroOutrosRendimentos.instanciaNovoObjeto();
                itemQuadroOutrosRendimentos.getCpfBenefic().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                itemQuadroOutrosRendimentos.getCnpjEmpresa().setConteudo(registroTxt.fieldByName("NR_PAGADORA").asString());
                itemQuadroOutrosRendimentos.getNomeFonte().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                itemQuadroOutrosRendimentos.getValor().setConteudo(registroTxt.fieldByName("VR_VALOR").asValor());
                itemQuadroOutrosRendimentos.getEspecificacao().setConteudo(registroTxt.fieldByName("NM_DESCRICAO").asString());
                colecaoItemQuadroOutrosRendimentos.recuperarLista().add(itemQuadroOutrosRendimentos);
            }
            ++n;
        }
    }

    public void montarAlimentandos(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getAlimentandos().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                Alimentando alimentando = new Alimentando();
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                alimentando.getExterior().setConteudo(registroTxt.fieldByName("INDICADOR_RESIDENC").asString());
                alimentando.setChave(registroTxt.fieldByName("NR_CHAVE").asString());
                alimentando.getNome().setConteudo(registroTxt.fieldByName("NM_NOME").asString());
                alimentando.getDataNascimento().setConteudo(registroTxt.fieldByName("DT_NASCIM").asString());
                alimentando.getCpf().setConteudo(registroTxt.fieldByName("NI_ALIMENTANDO").asString());
                alimentando.getCpfVinculado().setConteudo(registroTxt.fieldByName("NR_CPF_VINCULADO").asString());
                declaracaoIRPF.getAlimentandos().recuperarLista().add(alimentando);
                ++n;
            }
        }
    }

    public void montarPagamentos(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getPagamentos().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                Pagamento pagamento = new Pagamento(declaracaoIRPF);
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                pagamento.getNiBeneficiario().setConteudo(registroTxt.fieldByName("NR_BENEF").asString());
                pagamento.getNomeBeneficiario().setConteudo(registroTxt.fieldByName("NM_BENEF").asString());
                pagamento.getCodigo().setConteudo(registroTxt.fieldByName("CD_PAGTO").asString());
                pagamento.getTipo().setConteudo(registroTxt.fieldByName("IN_TIPO_PGTO").asString());
                pagamento.getDependenteOuAlimentando().setConteudo(declaracaoIRPF.getNomeDependenteOuAlimentandoPorChave(pagamento, registroTxt.fieldByName("NR_CHAVE_DEPEND").asString()));
                pagamento.getValorPago().setConteudo(registroTxt.fieldByName("VR_PAGTO").asValor());
                pagamento.getParcelaNaoDedutivel().setConteudo(registroTxt.fieldByName("VR_REDUC").asValor());
                pagamento.getDescricao().setConteudo(registroTxt.fieldByName("NM_DESCRICAO").asString());
                declaracaoIRPF.getPagamentos().recuperarLista().add(pagamento);
                ++n;
            }
        }
    }

    public void montarDoacoesCampanha(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getDoacoes().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                Doacao doacao = new Doacao();
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                doacao.getCNPJ().setConteudo(registroTxt.fieldByName("NR_PARTIDO").asString());
                doacao.getNome().setConteudo(registroTxt.fieldByName("NM_PARTIDO").asString());
                doacao.getValor().setConteudo(registroTxt.fieldByName("VR_DOACAO").asValor());
                declaracaoIRPF.getDoacoes().recuperarLista().add(doacao);
                ++n;
            }
        }
    }

    public void montarPagamentosAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getPagamentos().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                Pagamento pagamento = new Pagamento(declaracaoIRPF);
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                pagamento.getNiBeneficiario().setConteudo(registroTxt.fieldByName("NR_BENEF").asString());
                pagamento.getNomeBeneficiario().setConteudo(registroTxt.fieldByName("NM_BENEF").asString());
                pagamento.getCodigo().setConteudo(registroTxt.fieldByName("CD_PAGTO").asString());
                pagamento.getTipo().setConteudo(registroTxt.fieldByName("IN_TIPO_PGTO").asString());
                pagamento.getDependenteOuAlimentando().setConteudo(declaracaoIRPF.getNomeDependenteOuAlimentandoPorChave(pagamento, registroTxt.fieldByName("NR_CHAVE_DEPEND").asString()));
                declaracaoIRPF.getPagamentos().recuperarLista().add(pagamento);
                ++n;
            }
        }
    }

    public void montarCPFDependentesComRendPF(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getRendPFDependente().getColecaoCPFDependentes().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                CPFDependente cPFDependente = new CPFDependente();
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                cPFDependente.getCpf().setConteudo(registroTxt.fieldByName("RENDPF_DEP_CPF").asString());
                declaracaoIRPF.getRendPFDependente().getColecaoCPFDependentes().recuperarLista().add(cPFDependente);
                ++n;
            }
        }
    }

    public void montarRendimentosPF(Vector vector, DeclaracaoIRPF declaracaoIRPF, boolean bl) throws GeracaoTxtException {
        RendPF rendPF;
        if (!bl) {
            declaracaoIRPF.getRendPFTitular().clear();
            rendPF = declaracaoIRPF.getRendPFTitular();
        } else {
            declaracaoIRPF.getRendPFDependente().clear();
            rendPF = declaracaoIRPF.getRendPFDependente();
        }
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            if (registroTxt.fieldByName("E_DEPENDENTE").asBoolean() == bl) {
                int n2 = registroTxt.fieldByName("NR_MES").asInteger();
                MesRendPF mesRendPF = rendPF.getMesRendPFPorIndice(n2 - 1);
                mesRendPF.getMes().setConteudo(n2 - 1);
                mesRendPF.getPessoaFisica().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
                mesRendPF.getAlugueis().setConteudo(registroTxt.fieldByName("VR_ALUGUEIS").asValor());
                mesRendPF.getOutros().setConteudo(registroTxt.fieldByName("VR_ALUGUEIS").asValor());
                mesRendPF.getExterior().setConteudo(registroTxt.fieldByName("VR_EXTER").asValor());
                mesRendPF.getPrevidencia().setConteudo(registroTxt.fieldByName("VR_PREVID").asValor());
                mesRendPF.getDependentes().setConteudo(registroTxt.fieldByName("VR_DEDUC").asValor());
                mesRendPF.getPensao().setConteudo(registroTxt.fieldByName("VR_ALIMENT").asValor());
                mesRendPF.getLivroCaixa().setConteudo(registroTxt.fieldByName("VR_LIVCAIX").asValor());
                mesRendPF.getDarfPago().setConteudo(registroTxt.fieldByName("VR_IMPOSTO").asValor());
            }
            ++n;
        }
    }

    public void montarDependentes(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getDependentes().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            Dependente dependente = new Dependente();
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            dependente.setChave(registroTxt.fieldByName("NR_CHAVE").asString());
            dependente.getCodigo().setConteudo(registroTxt.fieldByName("CD_DEPEND").asString());
            dependente.getNome().setConteudo(registroTxt.fieldByName("NM_DEPEND").asString());
            dependente.getDataNascimento().setConteudo(registroTxt.fieldByName("DT_NASCIM").asString());
            dependente.getCpfDependente().setConteudo(registroTxt.fieldByName("NI_DEPEND").asString());
            dependente.getNitPisPasep().setConteudo(registroTxt.fieldByName("NR_NITPISPASEP").asString());
            dependente.getMoraComTitular().setConteudo(registroTxt.fieldByName("IN_ENDERECO_TITULAR").asString().equals("1") ? "S" : "N");
            dependente.getEmail().setConteudo(registroTxt.fieldByName("NM_EMAIL").asString());
            dependente.getDddCelular().setConteudo(registroTxt.fieldByName("NR_DDD_CELULAR").asString());
            dependente.getCelular().setConteudo(registroTxt.fieldByName("NR_CELULAR").asString());
            declaracaoIRPF.getDependentes().recuperarLista().add(dependente);
            ++n;
        }
    }

    public void montarInventariante(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            declaracaoIRPF.getEspolio().getNomeInventariante().setConteudo(registroTxt.fieldByName("NM_INVENT").asString());
            declaracaoIRPF.getEspolio().getCpfInventariante().setConteudo(registroTxt.fieldByName("NR_INVENT").asString());
        }
    }

    public void montarInventarianteAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            declaracaoIRPF.getEspolio().getNomeInventariante().setConteudo(registroTxt.fieldByName("NM_INVENT").asString());
            declaracaoIRPF.getEspolio().getCpfInventariante().setConteudo(registroTxt.fieldByName("NR_INVENT").asString());
        }
    }

    public void montarRendPJTitularSimplificada(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().clear();
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                RendPJTitular rendPJTitular = new RendPJTitular(declaracaoIRPF.getIdentificadorDeclaracao());
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                rendPJTitular.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
                rendPJTitular.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
                rendPJTitular.getRendRecebidoPJ().setConteudo(registroTxt.fieldByName("VR_RENDTO").asValor());
                rendPJTitular.getImpostoRetidoFonte().setConteudo(registroTxt.fieldByName("VR_IMPOSTO").asValor());
                declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().add(rendPJTitular);
                ++n;
            }
        }
    }

    public void montarRendaVariavel(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getRendaVariavel().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            int n2 = registroTxt.fieldByName("NR_MES").asInteger();
            GanhosLiquidosOuPerdas ganhosLiquidosOuPerdas = declaracaoIRPF.getRendaVariavel().getGanhosPorIndice(n2 - 1);
            Operacoes operacoes = ganhosLiquidosOuPerdas.getOperacoesComuns();
            operacoes.getMercadoVistaAcoes().setConteudo(registroTxt.fieldByName("VR_COMUM_MVISTA_ACOES").asValor());
            operacoes.getMercadoVistaOuro().setConteudo(registroTxt.fieldByName("VR_COMUM_MVISTA_OURO").asValor());
            operacoes.getMercadoVistaForaBolsa().setConteudo(registroTxt.fieldByName("VR_COMUM_MVISTA_OUROFORA").asValor());
            operacoes.getMercadoOpcoesAcoes().setConteudo(registroTxt.fieldByName("VR_COMUM_MOPC_ACOES").asValor());
            operacoes.getMercadoOpcoesOuro().setConteudo(registroTxt.fieldByName("VR_COMUM_MOPC_OURO").asValor());
            operacoes.getMercadoOpcoesForaDeBolsa().setConteudo(registroTxt.fieldByName("VR_COMUM_MOPC_OUROFORA").asValor());
            operacoes.getMercadoOpcoesOutros().setConteudo(registroTxt.fieldByName("VR_COMUM_MOPC_OUTROS").asValor());
            operacoes.getMercadoFuturoDolar().setConteudo(registroTxt.fieldByName("VR_COMUM_MFUT_DOLAR").asValor());
            operacoes.getMercadoFuturoIndices().setConteudo(registroTxt.fieldByName("VR_COMUM_MFUT_INDICES").asValor());
            operacoes.getMercadoFuturoJuros().setConteudo(registroTxt.fieldByName("VR_COMUM_MFUT_JUROS").asValor());
            operacoes.getMercadoFuturoOutros().setConteudo(registroTxt.fieldByName("VR_COMUM_MFUT_OUTROS").asValor());
            operacoes.getMercadoTermoAcoes().setConteudo(registroTxt.fieldByName("VR_COMUM_MTERMO_ACOESOURO").asValor());
            operacoes.getMercadoTermoOutros().setConteudo(registroTxt.fieldByName("VR_COMUM_MTERMO_OUTROS").asValor());
            Operacoes operacoes2 = ganhosLiquidosOuPerdas.getOperacoesDayTrade();
            operacoes2.getMercadoVistaAcoes().setConteudo(registroTxt.fieldByName("VR_DAYTR_MVISTA_ACOES").asValor());
            operacoes2.getMercadoVistaOuro().setConteudo(registroTxt.fieldByName("VR_DAYTR_MVISTA_OURO").asValor());
            operacoes2.getMercadoVistaForaBolsa().setConteudo(registroTxt.fieldByName("VR_DAYTR_MVISTA_OUROFORA").asValor());
            operacoes2.getMercadoOpcoesAcoes().setConteudo(registroTxt.fieldByName("VR_DAYTR_MOPC_ACOES").asValor());
            operacoes2.getMercadoOpcoesOuro().setConteudo(registroTxt.fieldByName("VR_DAYTR_MOPC_OURO").asValor());
            operacoes2.getMercadoOpcoesForaDeBolsa().setConteudo(registroTxt.fieldByName("VR_DAYTR_MOPC_OUROFORA").asValor());
            operacoes2.getMercadoOpcoesOutros().setConteudo(registroTxt.fieldByName("VR_DAYTR_MOPC_OUTROS").asValor());
            operacoes2.getMercadoFuturoDolar().setConteudo(registroTxt.fieldByName("VR_DAYTR_MFUT_DOLAR").asValor());
            operacoes2.getMercadoFuturoIndices().setConteudo(registroTxt.fieldByName("VR_DAYTR_MFUT_INDICES").asValor());
            operacoes2.getMercadoFuturoJuros().setConteudo(registroTxt.fieldByName("VR_DAYTR_MFUT_JUROS").asValor());
            operacoes2.getMercadoFuturoOutros().setConteudo(registroTxt.fieldByName("VR_DAYTR_MFUT_OUTROS").asValor());
            operacoes2.getMercadoTermoAcoes().setConteudo(registroTxt.fieldByName("VR_DAYTR_MTERMO_ACOESOURO").asValor());
            operacoes2.getMercadoTermoOutros().setConteudo(registroTxt.fieldByName("VR_DAYTR_MTERMO_OUTROS").asValor());
            operacoes.getResultadoNegativoMesAnterior().setConteudo(registroTxt.fieldByName("VR_RESULTNEG_MESANT_COMUM").asValor());
            operacoes2.getResultadoNegativoMesAnterior().setConteudo(registroTxt.fieldByName("VR_RESULTNEG_MESANT_DAYTR").asValor());
            ganhosLiquidosOuPerdas.getIrFonteDayTradeMesAtual().setConteudo(registroTxt.fieldByName("VR_FONTE_DAYTRADE").asValor());
            ganhosLiquidosOuPerdas.getImpostoRetidoFonteLei11033().setConteudo(registroTxt.fieldByName("VR_IMPRENDAFONTE").asValor());
            ganhosLiquidosOuPerdas.getImpostoPago().setConteudo(registroTxt.fieldByName("VR_IMPOSTO_PAGO").asValor());
            ++n;
        }
    }

    public void montarRendaVariavelFII(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            int n2 = registroTxt.fieldByName("NR_MES").asInteger();
            if (n2 < 1 || n2 > 12) {
                throw new GeracaoTxtException("Registro Fundo de Investimentos, M\u00eas Inv\u00e1lido.");
            }
            MesFundosInvestimentos mesFundosInvestimentos = declaracaoIRPF.getRendaVariavel().getFundInvest().getMeses()[n2 - 1];
            mesFundosInvestimentos.clear();
            mesFundosInvestimentos.getResultLiquidoMes().setConteudo(registroTxt.fieldByName("VR_RESLIQUIDO_MES").asValor());
            mesFundosInvestimentos.getResultNegativoAnterior().setConteudo(registroTxt.fieldByName("VR_RESULT_NEG_MESANT").asValor());
            mesFundosInvestimentos.getBaseCalcImposto().setConteudo(registroTxt.fieldByName("VR_BASECALCULO_MES").asValor());
            mesFundosInvestimentos.getPrejuizoCompensar().setConteudo(registroTxt.fieldByName("VR_PREJACOMPENSAR_MES_OPCOMUNS").asValor());
            mesFundosInvestimentos.getAliquotaImposto().setConteudo(registroTxt.fieldByName("VR_ALIQUOTA_IMPOSTO_OPCOMUNS").asValor());
            mesFundosInvestimentos.getImpostoDevido().setConteudo(registroTxt.fieldByName("VR_IMPOSTODEVIDO_MES_OPCOMUNS").asValor());
            mesFundosInvestimentos.getImpostoPago().setConteudo(registroTxt.fieldByName("VR_IMPOSTOPAGO").asValor());
            ++n;
        }
    }

    public void montarAtividadeRuralImoveis(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getIdentificacaoImovel().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getIdentificacaoImovel().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            ImovelAR imovelAR = string.equals("0") ? new ImovelARBrasil() : new ImovelAR();
            imovelAR.getCodigo().setConteudo(registroTxt.fieldByName("CD_ATIV").asString());
            imovelAR.getCondicaoExploracao().setConteudo(registroTxt.fieldByName("CD_EXPLOR").asString());
            imovelAR.getArea().setConteudo(registroTxt.fieldByName("QT_AREA").asValor());
            imovelAR.getLocalizacao().setConteudo(registroTxt.fieldByName("NM_LOCAL").asString());
            imovelAR.getNome().setConteudo(registroTxt.fieldByName("NM_IMOVEL").asString());
            imovelAR.getParticipacao().setConteudo(registroTxt.fieldByName("PC_PARTIC").asValor());
            if (imovelAR instanceof ImovelARBrasil) {
                declaracaoIRPF.getAtividadeRural().getBrasil().getIdentificacaoImovel().recuperarLista().add(imovelAR);
                ((ImovelARBrasil)imovelAR).getNirf().setConteudo(registroTxt.fieldByName("NR_INCRA").asString());
            } else {
                declaracaoIRPF.getAtividadeRural().getExterior().getIdentificacaoImovel().recuperarLista().add(imovelAR);
            }
            ++n;
        }
    }

    public void montarAtividadeRuralImoveisAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getIdentificacaoImovel().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getIdentificacaoImovel().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            ImovelAR imovelAR = string.equals("0") ? new ImovelARBrasil() : new ImovelAR();
            imovelAR.getCodigo().setConteudo(registroTxt.fieldByName("CD_ATIV").asString());
            imovelAR.getCondicaoExploracao().setConteudo(registroTxt.fieldByName("CD_EXPLOR").asString());
            imovelAR.getArea().setConteudo(registroTxt.fieldByName("QT_AREA").asValor());
            imovelAR.getLocalizacao().setConteudo(registroTxt.fieldByName("NM_LOCAL").asString());
            imovelAR.getNome().setConteudo(registroTxt.fieldByName("NM_IMOVEL").asString());
            imovelAR.getParticipacao().setConteudo(registroTxt.fieldByName("PC_PARTIC").asValor());
            if (imovelAR instanceof ImovelARBrasil) {
                declaracaoIRPF.getAtividadeRural().getBrasil().getIdentificacaoImovel().recuperarLista().add(imovelAR);
                ((ImovelARBrasil)imovelAR).getNirf().setConteudo(registroTxt.fieldByName("NR_INCRA").asString());
            } else {
                declaracaoIRPF.getAtividadeRural().getExterior().getIdentificacaoImovel().recuperarLista().add(imovelAR);
            }
            ++n;
        }
    }

    public void montarAtividadeRuralBens(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getBens().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getBens().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            BemAR bemAR = string.equals("0") ? new BemAR() : new BemARExterior();
            bemAR.getCodigo().setConteudo(registroTxt.fieldByName("CD_BEMAR").asString());
            bemAR.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_BEM").asString());
            bemAR.getValor().setConteudo(registroTxt.fieldByName("VR_BEM").asValor());
            if (bemAR instanceof BemARExterior) {
                ((BemARExterior)bemAR).getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
                declaracaoIRPF.getAtividadeRural().getExterior().getBens().recuperarLista().add(bemAR);
            } else {
                declaracaoIRPF.getAtividadeRural().getBrasil().getBens().recuperarLista().add(bemAR);
            }
            ++n;
        }
    }

    public void montarAtividadeRuralBensAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getBens().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getBens().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            BemAR bemAR = string.equals("0") ? new BemAR() : new BemARExterior();
            bemAR.getCodigo().setConteudo(registroTxt.fieldByName("CD_BEMAR").asString());
            bemAR.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_BEM").asString());
            if (bemAR instanceof BemARExterior) {
                ((BemARExterior)bemAR).getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
                declaracaoIRPF.getAtividadeRural().getExterior().getBens().recuperarLista().add(bemAR);
            } else {
                declaracaoIRPF.getAtividadeRural().getBrasil().getBens().recuperarLista().add(bemAR);
            }
            ++n;
        }
    }

    public void montarAtividadeRuralDividas(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getDividas().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getDividas().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            DividaAR dividaAR = new DividaAR();
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            dividaAR.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_DIVIDA").asString());
            dividaAR.getContraidasAteExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_DIVATE").asValor());
            dividaAR.getContraidasAteExercicioAtual().setConteudo(registroTxt.fieldByName("VR_DIVATU").asValor());
            dividaAR.getEfetivamentePagas().setConteudo(registroTxt.fieldByName("VR_DIVPAG").asValor());
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            if (string.equals("0")) {
                declaracaoIRPF.getAtividadeRural().getBrasil().getDividas().recuperarLista().add(dividaAR);
            } else {
                declaracaoIRPF.getAtividadeRural().getExterior().getDividas().recuperarLista().add(dividaAR);
            }
            ++n;
        }
    }

    public void montarAtividadeRuralDividasAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getDividas().recuperarLista().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getDividas().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            DividaAR dividaAR = new DividaAR();
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            Valor valor = new Valor();
            Valor valor2 = new Valor();
            valor = registroTxt.fieldByName("VR_DIVATU").asValor();
            valor2 = registroTxt.fieldByName("VR_DIVPAG").asValor();
            if (!valor.isVazio() && valor2.comparacao("<", valor)) {
                dividaAR.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_DIVIDA").asString());
                String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
                if (string.equals("0")) {
                    declaracaoIRPF.getAtividadeRural().getBrasil().getDividas().recuperarLista().add(dividaAR);
                } else {
                    declaracaoIRPF.getAtividadeRural().getExterior().getDividas().recuperarLista().add(dividaAR);
                }
            }
            ++n;
        }
    }

    public void montarAtividadeRuralMovimentacaoRebanho(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getMovimentacaoRebanho().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getMovimentacaoRebanho().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            MovimentacaoRebanho movimentacaoRebanho = string.equals("0") ? declaracaoIRPF.getAtividadeRural().getBrasil().getMovimentacaoRebanho() : declaracaoIRPF.getAtividadeRural().getExterior().getMovimentacaoRebanho();
            int n2 = registroTxt.fieldByName("CD_ESPEC").asInteger();
            switch (n2) {
                case 1: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getBovinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 2: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getSuinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 3: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getCaprinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 4: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getAsininos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 5: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getOutros(), vector, declaracaoIRPF, registroTxt);
                }
            }
            ++n;
        }
    }

    private void setarValoresTipoDadoMovimentacaoRebanho(ItemMovimentacaoRebanho itemMovimentacaoRebanho, Vector vector, DeclaracaoIRPF declaracaoIRPF, RegistroTxt registroTxt) throws GeracaoTxtException {
        itemMovimentacaoRebanho.getEstoqueInicial().setConteudo(registroTxt.fieldByName("QT_INIC").asValor());
        itemMovimentacaoRebanho.getAquisicoesAno().setConteudo(registroTxt.fieldByName("QT_COMPRA").asValor());
        itemMovimentacaoRebanho.getNascidosAno().setConteudo(registroTxt.fieldByName("QT_NASCIM").asValor());
        itemMovimentacaoRebanho.getEstoqueFinal().setConteudo(registroTxt.fieldByName("QT_ESTFINAL").asValor());
        itemMovimentacaoRebanho.getConsumo().setConteudo(registroTxt.fieldByName("QT_PERDA").asValor());
        itemMovimentacaoRebanho.getVendas().setConteudo(registroTxt.fieldByName("QT_VENDA").asValor());
    }

    public void montarAtividadeRuralMovimentacaoRebanhoAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getMovimentacaoRebanho().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getMovimentacaoRebanho().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            MovimentacaoRebanho movimentacaoRebanho = string.equals("0") ? declaracaoIRPF.getAtividadeRural().getBrasil().getMovimentacaoRebanho() : declaracaoIRPF.getAtividadeRural().getExterior().getMovimentacaoRebanho();
            int n2 = registroTxt.fieldByName("CD_ESPEC").asInteger();
            switch (n2) {
                case 1: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movimentacaoRebanho.getBovinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 2: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movimentacaoRebanho.getSuinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 3: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movimentacaoRebanho.getCaprinos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 4: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movimentacaoRebanho.getAsininos(), vector, declaracaoIRPF, registroTxt);
                    break;
                }
                case 5: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movimentacaoRebanho.getOutros(), vector, declaracaoIRPF, registroTxt);
                }
            }
            ++n;
        }
    }

    private void setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(ItemMovimentacaoRebanho itemMovimentacaoRebanho, Vector vector, DeclaracaoIRPF declaracaoIRPF, RegistroTxt registroTxt) throws GeracaoTxtException {
        itemMovimentacaoRebanho.getEstoqueInicial().setConteudo(registroTxt.fieldByName("QT_ESTFINAL").asValor());
    }

    public void montarAtividadeRuralApuracaoResultado(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().clear();
        declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().clear();
        ApuracaoResultadoBrasil apuracaoResultadoBrasil = declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado();
        ApuracaoResultadoExterior apuracaoResultadoExterior = declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            String string = registroTxt.fieldByName("IN_EXTERIOR").asString();
            if (string.equals("0")) {
                apuracaoResultadoBrasil.getValorAdiantamento().setConteudo(registroTxt.fieldByName("VR_ADIANT").asValor());
                apuracaoResultadoBrasil.getDespesaCusteio().setConteudo(registroTxt.fieldByName("VR_DESPTOTAL").asValor());
                apuracaoResultadoBrasil.getOpcaoArbitramento().setConteudo(registroTxt.fieldByName("VR_OPCAO").asValor());
                apuracaoResultadoBrasil.getPrejuizoExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_PREJEXERCANT").asValor());
                apuracaoResultadoBrasil.getPrejuizoCompensar().setConteudo(registroTxt.fieldByName("VR_PREJUIZO").asValor());
                apuracaoResultadoBrasil.getReceitaBrutaTotal().setConteudo(registroTxt.fieldByName("VR_RECTOTAL").asValor());
                apuracaoResultadoBrasil.getReceitaRecebidaContaVenda().setConteudo(registroTxt.fieldByName("VR_RECVENDAFUTURA").asValor());
                apuracaoResultadoBrasil.getResultadoI().setConteudo(registroTxt.fieldByName("VR_RES1REAL").asValor());
                apuracaoResultadoBrasil.getResultadoAposCompensacaoPrejuizo().setConteudo(registroTxt.fieldByName("VR_RESAPOS").asValor());
                apuracaoResultadoBrasil.getResultadoNaoTributavel().setConteudo(registroTxt.fieldByName("VR_RESNAOTRIBAR").asValor());
                apuracaoResultadoBrasil.getResultadoTributavel().setConteudo(registroTxt.fieldByName("VR_RESTRIB").asValor());
            } else {
                apuracaoResultadoExterior.getValorAdiantamento().setConteudo(registroTxt.fieldByName("VR_ADIANT").asValor());
                apuracaoResultadoExterior.getOpcaoArbitramento().setConteudo(registroTxt.fieldByName("VR_OPCAO").asValor());
                apuracaoResultadoExterior.getPrejuizoExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_PREJEXERCANT").asValor());
                apuracaoResultadoExterior.getPrejuizoCompensar().setConteudo(registroTxt.fieldByName("VR_PREJUIZO").asValor());
                apuracaoResultadoExterior.getReceitaRecebidaContaVenda().setConteudo(registroTxt.fieldByName("VR_RECVENDAFUTURA").asValor());
                apuracaoResultadoExterior.getResultadoI_EmReais().setConteudo(registroTxt.fieldByName("VR_RES1REAL").asValor());
                apuracaoResultadoExterior.getResultadoI_EmDolar().setConteudo(registroTxt.fieldByName("VR_RES1DOLAR").asValor());
                apuracaoResultadoExterior.getResultadoTributavel().setConteudo(registroTxt.fieldByName("VR_RES1DOLAR").asValor());
                apuracaoResultadoExterior.getResultadoAposCompensacaoPrejuizo().setConteudo(registroTxt.fieldByName("VR_RESAPOS").asValor());
                apuracaoResultadoExterior.getResultadoNaoTributavel().setConteudo(registroTxt.fieldByName("VR_RESNAOTRIBAR").asValor());
                apuracaoResultadoExterior.getResultadoTributavel().setConteudo(registroTxt.fieldByName("VR_RESTRIB").asValor());
            }
            ++n;
        }
    }

    public void montarAtividadeRuralReceitasDespesasBrasil(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getBrasil().getReceitasDespesas().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            int n2 = registroTxt.fieldByName("NR_MES").asInteger();
            MesReceitaDespesa mesReceitaDespesa = declaracaoIRPF.getAtividadeRural().getBrasil().getReceitasDespesas().getMesReceitaPorIndice(--n2);
            mesReceitaDespesa.getDespesaCusteioInvestimento().setConteudo(registroTxt.fieldByName("VR_DESP").asValor());
            mesReceitaDespesa.getReceitaBrutaMensal().setConteudo(registroTxt.fieldByName("VR_REC").asValor());
            ++n;
        }
    }

    public void montarAtividadeRuralReceitasDespesasExterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getAtividadeRural().getExterior().getReceitasDespesas().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            ReceitaDespesa receitaDespesa = new ReceitaDespesa();
            receitaDespesa.getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
            receitaDespesa.getDespesaCusteio().setConteudo(registroTxt.fieldByName("DESPCUSTEIO").asValor());
            receitaDespesa.getReceitaBruta().setConteudo(registroTxt.fieldByName("RECBRUTA").asValor());
            receitaDespesa.getResultadoI_EmDolar().setConteudo(registroTxt.fieldByName("RESDOLAR").asValor());
            receitaDespesa.getResultadoIMoedaOriginal().setConteudo(registroTxt.fieldByName("RESORIGINAL").asValor());
            declaracaoIRPF.getAtividadeRural().getExterior().getReceitasDespesas().recuperarLista().add(receitaDespesa);
            ++n;
        }
    }

    public void montarContribuinteIRPFAnoAnterior(Vector vector, Contribuinte contribuinte) throws GeracaoTxtException {
        RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
        contribuinte.getTituloEleitor().setConteudo(registroTxt.fieldByName("NR_TITELEITOR").asString());
        contribuinte.getDataNascimento().setConteudo(registroTxt.fieldByName("DT_NASCIM").asString());
        contribuinte.getNaturezaOcupacao().setConteudo(registroTxt.fieldByName("CD_NATUR").asString());
        contribuinte.getOcupacaoPrincipal().setConteudo(registroTxt.fieldByName("CD_OCUP").asString());
        contribuinte.getTipoLogradouro().setConteudo(registroTxt.fieldByName("TIP_LOGRA").asString());
        if (registroTxt.fieldByName("SG_UF").asString().trim().equals("EX")) {
            contribuinte.getExterior().setConteudo(Logico.SIM);
            contribuinte.getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
            contribuinte.getCodigoExterior().setConteudo(registroTxt.fieldByName("CD_EX").asString());
            contribuinte.getCidade().setConteudo(registroTxt.fieldByName("NM_MUNICIP").asString());
            contribuinte.getLogradouroExt().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
            contribuinte.getNumeroExt().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
            contribuinte.getBairroExt().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
            contribuinte.getComplementoExt().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
        } else {
            contribuinte.getExterior().setConteudo(Logico.NAO);
            contribuinte.getUf().setConteudo(registroTxt.fieldByName("SG_UF").asString());
            contribuinte.getMunicipio().setConteudo(registroTxt.fieldByName("CD_MUNICIP").asString());
            contribuinte.getPais().setConteudo("105");
            contribuinte.getLogradouro().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
            contribuinte.getNumero().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
            contribuinte.getBairro().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
            contribuinte.getComplemento().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
        }
        contribuinte.getNitPisPasep().setConteudo(registroTxt.fieldByName("NR_NITPISPASEP").asString());
        contribuinte.getCpfConjuge().setConteudo(registroTxt.fieldByName("NR_CPF_CONJUGE").asString());
        contribuinte.getRegistroProfissional().setConteudo(registroTxt.fieldByName("NR_REGISTRO_PROFISSIONAL").asString());
        contribuinte.getCep().setConteudo(registroTxt.fieldByName("NR_CEP").asString());
        contribuinte.getEmail().setConteudo(registroTxt.fieldByName("NM_EMAIL").asString());
        contribuinte.getDddCelular().setConteudo(registroTxt.fieldByName("NR_DDD_CELULAR").asString());
        contribuinte.getCelular().setConteudo(registroTxt.fieldByName("NR_CELULAR").asString());
        contribuinte.getDdd().setConteudo(registroTxt.fieldByName("NR_DDD_TELEFONE").asString());
        contribuinte.getTelefone().setConteudo(registroTxt.fieldByName("NR_TELEFONE").asString());
    }

    public void montarDependentesAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getDependentes().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            Dependente dependente = new Dependente();
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            dependente.setChave(registroTxt.fieldByName("NR_CHAVE").asString());
            dependente.getCodigo().setConteudo(registroTxt.fieldByName("CD_DEPEND").asString());
            dependente.getNome().setConteudo(registroTxt.fieldByName("NM_DEPEND").asString());
            dependente.getDataNascimento().setConteudo(registroTxt.fieldByName("DT_NASCIM").asString());
            dependente.getCpfDependente().setConteudo(registroTxt.fieldByName("NI_DEPEND").asString());
            dependente.getNitPisPasep().setConteudo(registroTxt.fieldByName("NR_NITPISPASEP").asString());
            declaracaoIRPF.getDependentes().recuperarLista().add(dependente);
            ++n;
        }
    }

    public void montarBensAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getBens().recuperarLista().clear();
        vector = (Vector)vector.clone();
        vector.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2;
                block4: {
                    RegistroTxt registroTxt = (RegistroTxt)object;
                    RegistroTxt registroTxt2 = (RegistroTxt)object2;
                    n2 = registroTxt.fieldByName("NR_CHAVE_BEM").asInteger();
                    n = registroTxt2.fieldByName("NR_CHAVE_BEM").asInteger();
                    if (n2 >= n) break block4;
                    return -1;
                }
                try {
                    if (n2 > n) {
                        return 1;
                    }
                }
                catch (GeracaoTxtException geracaoTxtException) {
                    System.exit(-1);
                }
                return 0;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        int n = 0;
        int n2 = 1;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            if (registroTxt.fieldByName("VR_ATUAL").asValor().comparacao(">", "0,00")) {
                Bem bem = new Bem(declaracaoIRPF);
                bem.getChave().setConteudo(n2++);
                bem.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_BEM").asString());
                int n3 = Bem.mapeiaCodigo21para22(registroTxt.fieldByName("CD_BEM").asInteger());
                bem.getCodGrupo().setConteudo(n3 / 100);
                bem.getCodigo().setConteudo(n3 % 100);
                bem.getValorExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_ATUAL").asValor());
                if (registroTxt.fieldByName("VR_ATUAL").asString().equals(registroTxt.fieldByName("VR_ANTER").asString())) {
                    bem.getValorExercicioAtual().setConteudo(registroTxt.fieldByName("VR_ATUAL").asValor());
                } else {
                    bem.getValorExercicioAtual().clear();
                }
                int n4 = registroTxt.fieldByName("IN_EXTERIOR").asInteger();
                if (n4 == 1) {
                    bem.getPais().setConteudo(registroTxt.fieldByName("CD_PAIS").asString());
                } else {
                    bem.getPais().setConteudo("105");
                }
                bem.getLogradouro().setConteudo(registroTxt.fieldByName("NM_LOGRA").asString());
                bem.getNumero().setConteudo(registroTxt.fieldByName("NR_NUMERO").asString());
                bem.getComplemento().setConteudo(registroTxt.fieldByName("NM_COMPLEM").asString());
                bem.getBairro().setConteudo(registroTxt.fieldByName("NM_BAIRRO").asString());
                bem.getCep().setConteudo(registroTxt.fieldByName("NR_CEP").asString());
                bem.getUf().setConteudo(registroTxt.fieldByName("SG_UF").asString());
                bem.getMunicipio().setConteudo(registroTxt.fieldByName("CD_MUNICIP").asString());
                bem.getNomeMunicipio().setConteudo(registroTxt.fieldByName("NM_MUNICIP").asString());
                bem.getRegistrado().setConteudo(registroTxt.fieldByName("NM_IND_REG_IMOV").asString());
                bem.getMatricula().setConteudo(registroTxt.fieldByName("MATRIC_IMOV").asString());
                bem.getAreaTotal().setConteudo(registroTxt.fieldByName("AREA").asValor());
                bem.getUnidade().setConteudo(registroTxt.fieldByName("NM_UNID").asString());
                bem.getNomeCartorio().setConteudo(registroTxt.fieldByName("NM_CARTORIO").asString());
                bem.getDataAquisicao().setConteudo(registroTxt.fieldByName("DT_AQUISICAO").asString());
                bem.getIPTU().setConteudo(registroTxt.fieldByName("NR_IPTU").asString());
                bem.getRenavan().setConteudo(registroTxt.fieldByName("NR_RENAVAN").asString());
                bem.getRegAviaCivil().setConteudo(registroTxt.fieldByName("NR_DEP_AVIACAO_CIVIL").asString());
                bem.getRegCapPortos().setConteudo(registroTxt.fieldByName("NR_CAPITANIA_PORTOS").asString());
                bem.getAgencia().setConteudo(registroTxt.fieldByName("NR_AGENCIA").asString());
                bem.getConta().setConteudo(registroTxt.fieldByName("NR_CONTA").asString());
                bem.getContaDV().setConteudo(registroTxt.fieldByName("NR_DV_CONTA").asString());
                bem.getCPFCNPJ().setConteudo(registroTxt.fieldByName("NM_CPFCNPJ").asString());
                bem.getBanco().setConteudo(registroTxt.fieldByName("NR_BANCO").asString());
                if (!registroTxt.fieldByName("IN_TIPO_BENEFIC").asString().equals(" ")) {
                    bem.getCPFTitDep().setConteudo(registroTxt.fieldByName("NR_CPF_BENEFIC").asString());
                }
                bem.getCIB().setConteudo(registroTxt.fieldByName("NR_NIRF").asString());
                declaracaoIRPF.getBens().recuperarLista().add(bem);
            }
            ++n;
        }
    }

    public void montarDividasAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getDividas().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            if (registroTxt.fieldByName("VR_ATUAL").asValor().comparacao(">", "0,00")) {
                Divida divida = new Divida();
                divida.getDiscriminacao().setConteudo(registroTxt.fieldByName("TX_DIV").asString());
                divida.getCodigo().setConteudo(registroTxt.fieldByName("CD_DIV").asString());
                divida.getValorExercicioAnterior().setConteudo(registroTxt.fieldByName("VR_ATUAL").asValor());
                divida.getValorExercicioAtual().clear();
                declaracaoIRPF.getDividas().recuperarLista().add(divida);
            }
            ++n;
        }
    }

    public void montarRendPJDependAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        declaracaoIRPF.getColecaoRendPJDependente().recuperarLista().clear();
        int n = 0;
        while (n < vector.size()) {
            RendPJDependente rendPJDependente = new RendPJDependente(declaracaoIRPF.getIdentificadorDeclaracao());
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            rendPJDependente.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
            rendPJDependente.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
            rendPJDependente.getCpfDependente().setConteudo(registroTxt.fieldByName("CPF_BENEF").asString());
            declaracaoIRPF.getColecaoRendPJDependente().recuperarLista().add(rendPJDependente);
            ++n;
        }
    }

    public void montarRendPJTitularAnoAnterior(Vector vector, DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        if (vector.size() > 0) {
            declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().clear();
            int n = 0;
            while (n < vector.size()) {
                RendPJTitular rendPJTitular = new RendPJTitular(declaracaoIRPF.getIdentificadorDeclaracao());
                RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
                rendPJTitular.getNIFontePagadora().setConteudo(registroTxt.fieldByName("NR_PAGADOR").asString());
                rendPJTitular.getNomeFontePagadora().setConteudo(registroTxt.fieldByName("NM_PAGADOR").asString());
                declaracaoIRPF.getColecaoRendPJTitular().recuperarLista().add(rendPJTitular);
                ++n;
            }
        }
    }

    public RegistroTxt getRegistroRecibo(Vector vector) throws GeracaoTxtException {
        if (vector.size() > 0) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            return registroTxt;
        }
        throw new GeracaoTxtException("Detalhe do recibo n\u00e3o encontrado.");
    }

    public RegistroTxt getRegistroHeader(Vector vector) throws GeracaoTxtException {
        if (vector.size() > 0) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(0);
            return registroTxt;
        }
        throw new GeracaoTxtException("Registro Header do arquivo n\u00e3o encontrado.");
    }
}

