/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.impl.IdDeclaracaoImpl;
import serpro.ppgd.negocio.impl.IdUsuarioImpl;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.PreenchedorCodigo;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;

public class FabricaUtilitarios {
    private static Properties properties;
    public static String nomeClasseId;
    public static String nomeClasseIdDeclaracao;
    public static String nomeClasseDeclaracao;
    public static boolean usaCacheParaReflexao;
    public static Map cacheTempToReflection;

    public static String getPathCompletoDirAplicacao() {
        String string;
        URL uRL = FabricaUtilitarios.class.getResource("/aplicacao.properties");
        if (uRL == null) {
            string = System.getProperty("user.dir");
        } else {
            URI uRI = null;
            try {
                uRI = new URI(uRL.getFile());
                String string2 = uRI.getPath();
                if (string2 == null) {
                    string2 = uRL.getPath();
                }
                string = UtilitariosArquivo.extraiPath(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                string = System.getProperty("user.dir");
            }
        }
        if (string == null || string.equals("")) {
            string = ".";
        }
        return string;
    }

    public static Properties getProperties() {
        String string;
        if (properties == null && ((string = (properties = UtilitariosArquivo.loadProperties("/aplicacao.properties", FabricaUtilitarios.class)).getProperty("aplicacao.diretorio.dados")) == null || string.equals(""))) {
            string = FabricaUtilitarios.getPathCompletoDirAplicacao();
            properties.setProperty("aplicacao.diretorio.dados", string);
        }
        return properties;
    }

    public static String getPathCompletoDirDadosAplicacao() {
        String string = FabricaUtilitarios.getProperties().getProperty("aplicacao.diretorio.dados");
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        string = string + "aplicacao/dados";
        return string;
    }

    public static String getPathCompletoDirImpressao() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "impressao";
    }

    public static String getPathCompletoDirGravadas() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "gravadas";
    }

    public static String getPathCompletoDirTransmitidas() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "transmitidas";
    }

    public static String getPathCompletoDirLib() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "lib";
    }

    public static void criaDiretorioBasicos() {
        File file = new File(FabricaUtilitarios.getPathCompletoDirImpressao());
        file.mkdirs();
        file = new File(FabricaUtilitarios.getPathCompletoDirGravadas());
        file.mkdirs();
        file = new File(FabricaUtilitarios.getPathCompletoDirTransmitidas());
        file.mkdirs();
        file = new File(FabricaUtilitarios.getPathCompletoDirLib());
        file.mkdirs();
    }

    public static List getFieldsCamposInformacao(Class clazz) {
        Vector<Field> vector = new Vector<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!Informacao.class.isAssignableFrom(fieldArray[i].getType())) continue;
            vector.add(fieldArray[i]);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(ObjetoNegocio.class)) {
            vector.addAll(FabricaUtilitarios.getFieldsCamposInformacao(clazz.getSuperclass()));
        }
        return vector;
    }

    public static List getAllFields(Class clazz) {
        if (usaCacheParaReflexao && cacheTempToReflection.containsKey(clazz)) {
            return (List)cacheTempToReflection.get(clazz);
        }
        Vector<Field> vector = new Vector<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            vector.add(fieldArray[i]);
        }
        if (clazz.getSuperclass() != null) {
            vector.addAll(FabricaUtilitarios.getAllFields(clazz.getSuperclass()));
        }
        if (usaCacheParaReflexao) {
            cacheTempToReflection.put(clazz, vector);
        }
        return vector;
    }

    public static List getAllFieldsOfSpecificType(Class clazz, Class clazz2) {
        Vector<Field> vector = new Vector<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!clazz2.isAssignableFrom(fieldArray[i].getType())) continue;
            vector.add(fieldArray[i]);
        }
        if (clazz.getSuperclass() != null) {
            vector.addAll(FabricaUtilitarios.getAllFieldsOfSpecificType(clazz.getSuperclass(), clazz2));
        }
        return vector;
    }

    public static List getFieldsCamposObjetoNegocio(Class clazz) {
        Vector<Field> vector = new Vector<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!ObjetoNegocio.class.isAssignableFrom(fieldArray[i].getType())) continue;
            vector.add(fieldArray[i]);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(ObjetoNegocio.class)) {
            vector.addAll(FabricaUtilitarios.getFieldsCamposInformacao(clazz.getSuperclass()));
        }
        return vector;
    }

    public static Object getValorField(Field field, Object object) {
        Object object2;
        boolean bl = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object3 = field.get(object);
            field.setAccessible(bl);
            object2 = object3;
        }
        catch (Exception exception) {
            field.setAccessible(bl);
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + exception.getMessage());
        }
        return object2;
    }

    public static Object getValorField(String string, Object object) {
        Object object2;
        try {
            Field field = null;
            for (Field field2 : FabricaUtilitarios.getFieldsCamposInformacao(object.getClass())) {
                if (!field2.getName().equals(string)) continue;
                field = field2;
            }
            object2 = FabricaUtilitarios.getValorField(field, object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + exception.getMessage());
        }
        return object2;
    }

    public static Object getValorFieldGenerico(String string, Object object) {
        Exception exception;
        block4: {
            block3: {
                Field field;
                Iterator iterator;
                try {
                    if (object == null) break block3;
                    iterator = FabricaUtilitarios.getAllFields(object.getClass()).iterator();
                    field = null;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    break block4;
                }
                while (iterator.hasNext()) {
                    field = (Field)iterator.next();
                    if (!field.getName().equals(string)) continue;
                    Field field2 = field;
                    return FabricaUtilitarios.getValorField(field2, object);
                }
            }
            return null;
        }
        Exception exception3 = exception;
        throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + string + " \nErro:\n" + exception3.getMessage());
    }

    public static Object obtemAtributo(ObjetoNegocio objetoNegocio, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Object object = objetoNegocio;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object = FabricaUtilitarios.getValorFieldGenerico(string2, object);
        }
        return object;
    }

    public static Object obtemAtributoComExcecao(ObjetoNegocio objetoNegocio, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Object object = objetoNegocio;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object = FabricaUtilitarios.getValorFieldGenericoComExcecao(string2, object);
        }
        return object;
    }

    public static Object getValorFieldGenericoComExcecao(String string, Object object) {
        Exception exception;
        block3: {
            Iterator iterator;
            Field field;
            try {
                field = null;
                iterator = FabricaUtilitarios.getAllFields(object.getClass()).iterator();
            }
            catch (Exception exception2) {
                exception = exception2;
                break block3;
            }
            while (iterator.hasNext()) {
                field = (Field)iterator.next();
                if (!field.getName().equals(string)) continue;
                Field field2 = field;
                return FabricaUtilitarios.getValorField(field2, object);
            }
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + string);
        }
        Exception exception3 = exception;
        throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + string + " \nErro:\n" + exception3.getMessage());
    }

    public static Object invocaMetodo(String string, Object object, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(exception);
        }
        return object2;
    }

    public static Field getField(Object object, Object object2) {
        Exception exception;
        block3: {
            Iterator iterator;
            try {
                iterator = FabricaUtilitarios.getFieldsCamposInformacao(object.getClass()).iterator();
            }
            catch (Exception exception2) {
                exception = exception2;
                break block3;
            }
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                Object object3 = FabricaUtilitarios.getValorField(field, object);
                if (object3 == null || !object3.getClass().isAssignableFrom(object2.getClass()) || !object3.equals(object2)) continue;
                return field;
            }
            return null;
        }
        Exception exception3 = exception;
        throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do Field referente ao atributo :" + exception3.getMessage());
    }

    public static Field getFieldPorNome(Class clazz, String string) {
        Field field = null;
        for (Field field2 : FabricaUtilitarios.getAllFields(clazz.getClass())) {
            if (!field2.getName().equals(string)) continue;
            field = field2;
            break;
        }
        return field;
    }

    public static void preencherObjetoComAtributosXml(Object object, Element element) {
        for (Field field : FabricaUtilitarios.getAllFieldsOfSpecificType(object.getClass(), Informacao.class)) {
            Informacao informacao = (Informacao)FabricaUtilitarios.getValorField(field, object);
            try {
                String string = element.getAttribute(field.getName());
                if (string != null) {
                    informacao.setConteudo(string);
                    continue;
                }
                informacao.setConteudo("");
            }
            catch (Exception exception) {}
        }
    }

    public static void preencherXMLComAtributosDoObjeto(Object object, Element element) {
        for (Field field : FabricaUtilitarios.getFieldsCamposInformacao(object.getClass())) {
            Informacao informacao = (Informacao)FabricaUtilitarios.getValorField(field, object);
            try {
                String string = informacao.asString();
                if (string != null) {
                    element.setAttribute(field.getName(), string);
                    continue;
                }
                element.setAttribute(field.getName(), "");
            }
            catch (Exception exception) {}
        }
    }

    public static List verificarPendencias(Object object) {
        Vector vector = new Vector();
        if (object == null) {
            return vector;
        }
        if (object instanceof ObjetoNegocio) {
            if (object instanceof Colecao) {
                ((Colecao)object).excluirRegistrosEmBranco();
            }
        } else {
            return vector;
        }
        vector.addAll(((ObjetoNegocio)object).verificarPendencias(-1));
        Field[] fieldArray = object.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2 = null;
            try {
                object2 = FabricaUtilitarios.getValorField(fieldArray[i], object);
            }
            catch (Exception exception) {
                LogPPGD.erro("N\u00e3o foi poss\u00edvel obter valor do atributo->" + fieldArray[i].getName());
            }
            if (object2 == null || Modifier.isTransient(fieldArray[i].getModifiers()) || !(object2 instanceof ObjetoNegocio) || object2 instanceof IdDeclaracao) continue;
            if (object instanceof Colecao) {
                ((Colecao)object).excluirRegistrosEmBranco();
            }
            vector.addAll(FabricaUtilitarios.verificarPendencias((ObjetoNegocio)object2));
        }
        return vector;
    }

    public static Document carregarDOM(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(string));
        }
        catch (SAXParseException sAXParseException) {
            LogPPGD.erro("Erro de parsing de " + sAXParseException.getSystemId() + ". linha " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            LogPPGD.erro("Erro de parsing: " + exception.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            LogPPGD.erro("Erro de I/O: " + iOException.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        return document;
    }

    public static void ordenarElementosPorColuna(final int n, List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                ElementoTabela elementoTabela = (ElementoTabela)object;
                ElementoTabela elementoTabela2 = (ElementoTabela)object2;
                if (n >= elementoTabela.size()) {
                    return UtilitariosString.removeAcentos(elementoTabela.getConteudo(0)).compareTo(UtilitariosString.removeAcentos(elementoTabela2.getConteudo(0)));
                }
                return UtilitariosString.removeAcentos(elementoTabela.getConteudo(n)).compareTo(UtilitariosString.removeAcentos(elementoTabela2.getConteudo(n)));
            }
        });
    }

    public static ObjetoNegocio instanciaObjetoNegocio(Class clazz, IdDeclaracao idDeclaracao) {
        ObjetoNegocio objetoNegocio = null;
        try {
            Class[] classArray = new Class[]{IdDeclaracao.class};
            Object[] objectArray = new Object[]{idDeclaracao};
            Constructor constructor = null;
            try {
                constructor = clazz.getConstructor(classArray);
                objetoNegocio = (ObjetoNegocio)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                objetoNegocio = (ObjetoNegocio)clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(instantiationException);
        }
        return objetoNegocio;
    }

    public static ObjetoNegocio instanciaObjetoNegocio(Class clazz) throws Exception {
        return (ObjetoNegocio)clazz.newInstance();
    }

    public static void preencheObjetoNegocioComResultSet(ResultSet resultSet, Object object) {
        for (Field field : FabricaUtilitarios.getAllFieldsOfSpecificType(object.getClass(), Informacao.class)) {
            Informacao informacao = (Informacao)FabricaUtilitarios.getValorField(field, object);
            if (informacao instanceof Valor && ((Valor)informacao).isCampoCalculado()) continue;
            try {
                informacao.setConteudo(resultSet.getString(field.getName()));
            }
            catch (Exception exception) {}
        }
    }

    public static PreenchedorCodigo criaPreenchedorCodigo() {
        return new PreenchedorCodigo();
    }

    public static PreenchedorCodigo criaPreenchedorCodigo(Codigo codigo) {
        return new PreenchedorCodigo(codigo);
    }

    private void preencheColecao(Colecao colecao, IdDeclaracao idDeclaracao, String string, ResultSet resultSet) {
        String string2 = "";
        try {
            while (resultSet.next()) {
                ObjetoNegocio objetoNegocio = FabricaUtilitarios.instanciaObjetoNegocio(colecao.getTipoItens(), idDeclaracao);
                FabricaUtilitarios.preencheObjetoNegocioComResultSet(resultSet, objetoNegocio);
                colecao.recuperarLista().add(objetoNegocio);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    static {
        nomeClasseId = null;
        nomeClasseIdDeclaracao = null;
        nomeClasseDeclaracao = null;
        nomeClasseId = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.id", IdUsuarioImpl.class.getName());
        nomeClasseIdDeclaracao = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.iddeclaracao", IdDeclaracaoImpl.class.getName());
        nomeClasseDeclaracao = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.declaracao");
        usaCacheParaReflexao = false;
        cacheTempToReflection = new Hashtable();
    }
}

