/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.negocio.ConstantesGlobais;

public class GravadorTXT {
    private static final Logger logger = Logger.getLogger("srf.irpf.importacaoGravacao.ImportarDeclaracao.ImportadorTxt");
    private static IdentificadorDeclaracao objIdDeclGerar;

    public static void gravarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao, String string) throws GeracaoTxtException, IOException {
        objIdDeclGerar = identificadorDeclaracao;
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", GravadorTXT.montaNome(ConstantesRepositorio.GRAV_GERACAO, string));
        repositorioDeclaracaoCentralTxt.gravarDeclaracao(identificadorDeclaracao);
    }

    public static void copiarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao, String string) throws GeracaoTxtException, IOException {
        objIdDeclGerar = identificadorDeclaracao;
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", GravadorTXT.montaNome(ConstantesRepositorio.GRAV_COPIA, string));
        repositorioDeclaracaoCentralTxt.salvarDeclaracao(identificadorDeclaracao);
    }

    private static File montaNome(byte by, String string) {
        StringBuffer stringBuffer = new StringBuffer(new File(string).getAbsolutePath());
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(objIdDeclGerar.getCpf().asString() + "-IRPF-A-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-");
        stringBuffer.append(objIdDeclGerar.isRetificadora() ? "RETIF." : "ORIGI.");
        stringBuffer.append(by == ConstantesRepositorio.GRAV_GERACAO ? "DEC" : "DBK");
        String string2 = stringBuffer.toString();
        return new File(stringBuffer.toString());
    }

    public static String montaNome(byte by, String string, IdentificadorDeclaracao identificadorDeclaracao) {
        StringBuffer stringBuffer = new StringBuffer(new File(string).getAbsolutePath());
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(identificadorDeclaracao.getCpf().asString() + "-IRPF-A-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-");
        stringBuffer.append(identificadorDeclaracao.isRetificadora() ? "RETIF." : "ORIGI.");
        stringBuffer.append(by == ConstantesRepositorio.GRAV_GERACAO ? "DEC" : "DBK");
        return stringBuffer.toString();
    }

    public static String montaNomeArquivoTXT(byte by, IdentificadorDeclaracao identificadorDeclaracao) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(identificadorDeclaracao.getCpf().asString() + "-IRPF-A-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-");
        stringBuffer.append(identificadorDeclaracao.isRetificadora() ? "RETIF." : "ORIGI.");
        stringBuffer.append(by == ConstantesRepositorio.GRAV_GERACAO ? "DEC" : "DBK");
        return stringBuffer.toString();
    }

    public static boolean fileExists(IdentificadorDeclaracao identificadorDeclaracao, String string, byte by) {
        objIdDeclGerar = identificadorDeclaracao;
        return GravadorTXT.montaNome(by, string).exists();
    }
}

