/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;

public class ObservadorDebitoAutomatico
extends Observador {
    private CalculoImposto calculoImposto = null;
    private DeclaracaoIRPF dec;
    private IdentificadorDeclaracao identificadorDec;
    private Contribuinte contribuinte;
    private boolean eraImpostoRestituir = false;

    public ObservadorDebitoAutomatico(CalculoImposto calculoImposto, IdentificadorDeclaracao identificadorDeclaracao, Contribuinte contribuinte) {
        this.calculoImposto = calculoImposto;
        this.identificadorDec = identificadorDeclaracao;
        this.contribuinte = contribuinte;
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        if (!"habilitado".equals(string)) {
            this.habilitadesabilitaDadosBancarios();
        }
    }

    public void habilitadesabilitaDadosBancarios() {
        boolean bl = this.calculoImposto.getDebitoAutomatico().asString().equals("autorizado");
        boolean bl2 = this.calculoImposto.getImpostoRestituir().comparacao(">", "0,00");
        if (bl2) {
            this.calculoImposto.getBanco().setHabilitado(true);
            this.calculoImposto.getAgencia().setReadOnly(false);
            this.calculoImposto.getContaCredito().setReadOnly(false);
            this.calculoImposto.getDvContaCredito().setReadOnly(false);
            this.calculoImposto.getIndicadorPrimeiraQuota().setReadOnly(true);
            this.calculoImposto.getDebitoAutomatico().setConteudo("N");
            if (!this.eraImpostoRestituir) {
                this.calculoImposto.getBanco().clear();
                this.calculoImposto.getAgencia().clear();
                this.calculoImposto.getContaCredito().clear();
                this.calculoImposto.getDvContaCredito().clear();
                this.calculoImposto.getIndicadorPrimeiraQuota().clear();
            }
            this.calculoImposto.getBanco().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancos());
            if (this.contribuinte.getExterior().asString().equals(Logico.SIM)) {
                this.calculoImposto.getBanco().setHabilitado(false);
                this.calculoImposto.getAgencia().setReadOnly(true);
                this.calculoImposto.getContaCredito().setReadOnly(true);
                this.calculoImposto.getDvContaCredito().setReadOnly(true);
                this.calculoImposto.getBanco().setConteudo("001");
                this.calculoImposto.getAgencia().setConteudo("0686");
            }
            this.eraImpostoRestituir = bl2;
        } else if (this.identificadorDec.getDeclaracaoRetificadora().asString().equals(Logico.SIM)) {
            this.calculoImposto.getBanco().setHabilitado(false);
            this.calculoImposto.getAgencia().setReadOnly(true);
            this.calculoImposto.getContaCredito().setReadOnly(true);
            this.calculoImposto.getDvContaCredito().setReadOnly(true);
            this.calculoImposto.getDebitoAutomatico().setConteudo("N");
            this.calculoImposto.getBanco().clear();
            this.calculoImposto.getAgencia().clear();
            this.calculoImposto.getContaCredito().clear();
            this.calculoImposto.getDvContaCredito().clear();
        } else {
            this.calculoImposto.getIndicadorPrimeiraQuota().setReadOnly(!bl);
            this.calculoImposto.getBanco().setHabilitado(bl);
            this.calculoImposto.getAgencia().setReadOnly(!bl);
            this.calculoImposto.getContaCredito().setReadOnly(!bl);
            this.calculoImposto.getDvContaCredito().setReadOnly(!bl);
            if (!bl) {
                this.calculoImposto.getBanco().clear();
                this.calculoImposto.getAgencia().clear();
                this.calculoImposto.getContaCredito().clear();
                this.calculoImposto.getDvContaCredito().clear();
                this.calculoImposto.getIndicadorPrimeiraQuota().clear();
            }
            if (bl) {
                this.calculoImposto.getBanco().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosDebito());
            }
        }
    }
}

