/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.exterior;

import java.util.List;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ReceitaDespesa
extends ObjetoNegocio {
    private Codigo pais = new Codigo(this, "", CadastroTabelasIRPF.recuperarPaisesExterior());
    private Alfa descricaoPais = new Alfa(this, "");
    private Valor receitaBruta = new Valor(this, "");
    private Valor despesaCusteio = new Valor(this, "");
    private Valor resultadoIMoedaOriginal = new Valor(this, "");
    private Valor resultadoI_EmDolar = new Valor(this, "");

    public ReceitaDespesa() {
        this.resultadoIMoedaOriginal.setReadOnly(true);
        this.receitaBruta.addObservador(this);
        this.despesaCusteio.addObservador(this);
        this.getPais().addObservador(new Observador(){

            @Override
            public void notifica(Object object, String string, Object object2, Object object3) {
                ReceitaDespesa.this.descricaoPais.setConteudo(ReceitaDespesa.this.getPais().getConteudoAtual(1));
            }
        });
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        this.resultadoIMoedaOriginal.setConteudo(this.receitaBruta.operacao('-', this.despesaCusteio));
    }

    public Valor getDespesaCusteio() {
        return this.despesaCusteio;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getReceitaBruta() {
        return this.receitaBruta;
    }

    public Valor getResultadoIMoedaOriginal() {
        return this.resultadoIMoedaOriginal;
    }

    public Valor getResultadoI_EmDolar() {
        return this.resultadoI_EmDolar;
    }

    @Override
    public boolean isVazio() {
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }
}

