/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.ArrayUtilities;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static double calculatePieDatasetTotal(PieDataset pieDataset) {
        if (pieDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List list = pieDataset.getKeys();
        double d = 0.0;
        for (Comparable comparable : list) {
            if (comparable == null) continue;
            Number number = pieDataset.getValue(comparable);
            double d2 = 0.0;
            if (number != null) {
                d2 = number.doubleValue();
            }
            if (!(d2 > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getRowIndex(comparable);
        return DatasetUtilities.createPieDatasetForRow(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Comparable comparable = categoryDataset.getColumnKey(i);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n, i));
        }
        return defaultPieDataset;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getColumnIndex(comparable);
        return DatasetUtilities.createPieDatasetForColumn(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Comparable comparable = categoryDataset.getRowKey(i);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(i, n));
        }
        return defaultPieDataset;
    }

    public static PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d) {
        return DatasetUtilities.createConsolidatedPieDataset(pieDataset, comparable, d, 2);
    }

    public static PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        double d2 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        List list = pieDataset.getKeys();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (Comparable comparable2 : list) {
            double d3;
            Number number = pieDataset.getValue(comparable2);
            if (number == null || !((d3 = number.doubleValue()) / d2 < d)) continue;
            arrayList.add(comparable2);
        }
        Iterator iterator = list.iterator();
        double d4 = 0.0;
        while (iterator.hasNext()) {
            Comparable comparable3 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable3);
            if (number == null) continue;
            if (arrayList.contains(comparable3) && arrayList.size() >= n) {
                d4 += number.doubleValue();
                continue;
            }
            defaultPieDataset.setValue(comparable3, number);
        }
        if (arrayList.size() >= n) {
            defaultPieDataset.setValue(comparable, d4);
        }
        return defaultPieDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < dArray.length; ++i) {
            String string3 = string + (i + 1);
            for (int j = 0; j < dArray[i].length; ++j) {
                String string4 = string2 + (j + 1);
                defaultCategoryDataset.addValue(new Double(dArray[i][j]), (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, Number[][] numberArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < numberArray.length; ++i) {
            String string3 = string + (i + 1);
            for (int j = 0; j < numberArray[i].length; ++j) {
                String string4 = string2 + (j + 1);
                defaultCategoryDataset.addValue(numberArray[i][j], (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(Comparable[] comparableArray, Comparable[] comparableArray2, double[][] dArray) {
        if (comparableArray == null) {
            throw new IllegalArgumentException("Null 'rowKeys' argument.");
        }
        if (comparableArray2 == null) {
            throw new IllegalArgumentException("Null 'columnKeys' argument.");
        }
        if (ArrayUtilities.hasDuplicateItems(comparableArray)) {
            throw new IllegalArgumentException("Duplicate items in 'rowKeys'.");
        }
        if (ArrayUtilities.hasDuplicateItems(comparableArray2)) {
            throw new IllegalArgumentException("Duplicate items in 'columnKeys'.");
        }
        if (comparableArray.length != dArray.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n = Math.max(n, dArray[i].length);
        }
        if (comparableArray2.length != n) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < dArray.length; ++i) {
            Comparable comparable = comparableArray[i];
            for (int j = 0; j < dArray[i].length; ++j) {
                Comparable comparable2 = comparableArray2[j];
                defaultCategoryDataset.addValue(new Double(dArray[i][j]), comparable, comparable2);
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(Comparable comparable, KeyedValues keyedValues) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'rowData' argument.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            defaultCategoryDataset.addValue(keyedValues.getValue(i), comparable, keyedValues.getKey(i));
        }
        return defaultCategoryDataset;
    }

    public static XYDataset sampleFunction2D(Function2D function2D, double d, double d2, int n, Comparable comparable) {
        if (function2D == null) {
            throw new IllegalArgumentException("Null 'f' argument.");
        }
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'seriesKey' argument.");
        }
        if (d >= d2) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries xYSeries = new XYSeries(comparable);
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d4 = d + d3 * (double)i;
            xYSeries.add(d4, function2D.getValue(d4));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static boolean isEmptyOrNull(PieDataset pieDataset) {
        if (pieDataset == null) {
            return true;
        }
        int n = pieDataset.getItemCount();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            double d;
            Number number = pieDataset.getValue(i);
            if (number == null || !((d = number.doubleValue()) > 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return true;
        }
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        if (n == 0 || n2 == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (categoryDataset.getValue(i, j) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyOrNull(XYDataset xYDataset) {
        boolean bl = true;
        if (xYDataset != null) {
            for (int i = 0; i < xYDataset.getSeriesCount(); ++i) {
                if (xYDataset.getItemCount(i) <= 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static Range findDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.findDomainBounds(xYDataset, true);
    }

    public static Range findDomainBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            range = domainInfo.getDomainBounds(bl);
        } else {
            range = DatasetUtilities.iterateDomainBounds(xYDataset, bl);
        }
        return range;
    }

    public static Range iterateDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateDomainBounds(xYDataset, true);
    }

    public static Range iterateDomainBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    double d3 = intervalXYDataset.getStartXValue(i, j);
                    double d4 = intervalXYDataset.getEndXValue(i, j);
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d4);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    double d5;
                    double d6 = d5 = xYDataset.getXValue(i, j);
                    d = Math.min(d, d5);
                    d2 = Math.max(d2, d6);
                }
            }
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range findRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findRangeBounds(categoryDataset, true);
    }

    public static Range findRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            range = rangeInfo.getRangeBounds(bl);
        } else {
            range = DatasetUtilities.iterateCategoryRangeBounds(categoryDataset, bl);
        }
        return range;
    }

    public static Range findRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.findRangeBounds(xYDataset, true);
    }

    public static Range findRangeBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            range = rangeInfo.getRangeBounds(bl);
        } else {
            range = DatasetUtilities.iterateXYRangeBounds(xYDataset);
        }
        return range;
    }

    public static Range iterateCategoryRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        boolean bl2 = bl && categoryDataset instanceof IntervalCategoryDataset;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Number number;
                Number number2;
                if (bl2) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number2 = intervalCategoryDataset.getStartValue(i, j);
                    number = intervalCategoryDataset.getEndValue(i, j);
                } else {
                    number = number2 = categoryDataset.getValue(i, j);
                }
                if (number2 != null) {
                    d = Math.min(d, number2.doubleValue());
                }
                if (number == null) continue;
                d2 = Math.max(d2, number.doubleValue());
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range iterateXYRangeBounds(XYDataset xYDataset) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d3;
                double d4;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d4 = xYDataset2.getStartYValue(i, j);
                    d3 = xYDataset2.getEndYValue(i, j);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d4 = xYDataset2.getLowValue(i, j);
                    d3 = xYDataset2.getHighValue(i, j);
                } else {
                    d3 = d4 = xYDataset.getYValue(i, j);
                }
                if (!Double.isNaN(d4)) {
                    d = Math.min(d, d4);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Number findMinimumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getStartXValue(i, j);
                } else {
                    d3 = xYDataset.getXValue(i, j);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        d = d2 == Double.POSITIVE_INFINITY ? null : new Double(d2);
        return d;
    }

    public static Number findMaximumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getEndXValue(i, j);
                } else {
                    d3 = xYDataset.getXValue(i, j);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        d = d2 == Double.NEGATIVE_INFINITY ? null : new Double(d2);
        return d;
    }

    public static Number findMinimumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d = Double.POSITIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getStartValue(i, j);
                } else {
                    number = categoryDataset.getValue(i, j);
                }
                if (number == null) continue;
                d = Math.min(d, number.doubleValue());
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMinimumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getStartYValue(i, j);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getLowValue(i, j);
                } else {
                    d2 = xYDataset.getYValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.min(d, d2);
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMaximumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getEndValue(i, j);
                } else {
                    number = categoryDataset.getValue(i, j);
                }
                if (number == null) continue;
                d = Math.max(d, number.doubleValue());
            }
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMaximumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getEndYValue(i, j);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getHighValue(i, j);
                } else {
                    d2 = xYDataset.getYValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.max(d, d2);
            }
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, 0.0);
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset, double d) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            double d4 = d;
            double d5 = d;
            int n2 = categoryDataset.getRowCount();
            for (int j = 0; j < n2; ++j) {
                Number number = categoryDataset.getValue(j, i);
                if (number == null) continue;
                double d6 = number.doubleValue();
                if (d6 > 0.0) {
                    d4 += d6;
                }
                if (!(d6 < 0.0)) continue;
                d5 += d6;
            }
            d2 = Math.min(d2, d5);
            d3 = Math.max(d3, d4);
        }
        if (d2 <= d3) {
            range = new Range(d2, d3);
        }
        return range;
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset, KeyToGroupMap keyToGroupMap) {
        Range range = null;
        if (categoryDataset != null) {
            int n;
            int n2;
            int[] nArray = new int[categoryDataset.getRowCount()];
            for (n2 = 0; n2 < categoryDataset.getRowCount(); ++n2) {
                nArray[n2] = keyToGroupMap.getGroupIndex(keyToGroupMap.getGroup(categoryDataset.getRowKey(n2)));
            }
            n2 = keyToGroupMap.getGroupCount();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            int n3 = categoryDataset.getColumnCount();
            for (n = 0; n < n3; ++n) {
                int n4;
                double[] dArray3 = new double[n2];
                double[] dArray4 = new double[n2];
                int n5 = categoryDataset.getRowCount();
                for (n4 = 0; n4 < n5; ++n4) {
                    Number number = categoryDataset.getValue(n4, n);
                    if (number == null) continue;
                    double d = number.doubleValue();
                    if (d > 0.0) {
                        dArray3[nArray[n4]] = dArray3[nArray[n4]] + d;
                    }
                    if (!(d < 0.0)) continue;
                    dArray4[nArray[n4]] = dArray4[nArray[n4]] + d;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4] = Math.min(dArray[n4], dArray4[n4]);
                    dArray2[n4] = Math.max(dArray2[n4], dArray3[n4]);
                }
            }
            for (n = 0; n < n2; ++n) {
                range = Range.combine(range, new Range(dArray[n], dArray2[n]));
            }
        }
        return range;
    }

    public static Number findMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                int n2 = categoryDataset.getColumnCount();
                for (int j = 0; j < n2; ++j) {
                    double d4;
                    Number number = categoryDataset.getValue(j, i);
                    if (number == null || !((d4 = number.doubleValue()) < 0.0)) continue;
                    d3 += d4;
                }
                d2 = Math.min(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Number findMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                int n2 = categoryDataset.getRowCount();
                for (int j = 0; j < n2; ++j) {
                    double d4;
                    Number number = categoryDataset.getValue(j, i);
                    if (number == null || !((d4 = number.doubleValue()) > 0.0)) continue;
                    d3 += d4;
                }
                d2 = Math.max(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeBounds(tableXYDataset, 0.0);
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset, double d) {
        if (tableXYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d2 = d;
        double d3 = d;
        for (int i = 0; i < tableXYDataset.getItemCount(); ++i) {
            double d4 = d;
            double d5 = d;
            int n = tableXYDataset.getSeriesCount();
            for (int j = 0; j < n; ++j) {
                double d6 = tableXYDataset.getYValue(j, i);
                if (Double.isNaN(d6)) continue;
                if (d6 > 0.0) {
                    d4 += d6;
                    continue;
                }
                d5 += d6;
            }
            if (d4 > d3) {
                d3 = d4;
            }
            if (!(d5 < d2)) continue;
            d2 = d5;
        }
        if (d2 <= d3) {
            return new Range(d2, d3);
        }
        return null;
    }

    public static double calculateStackTotal(TableXYDataset tableXYDataset, int n) {
        double d = 0.0;
        int n2 = tableXYDataset.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = tableXYDataset.getYValue(i, n);
            if (Double.isNaN(d2)) continue;
            d += d2;
        }
        return d;
    }

    public static Range findCumulativeRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d3 = 0.0;
            for (int j = 0; j < categoryDataset.getColumnCount() - 1; ++j) {
                Number number = categoryDataset.getValue(i, j);
                if (number == null) continue;
                bl = false;
                double d4 = number.doubleValue();
                d = Math.min(d, d3 += d4);
                d2 = Math.max(d2, d3);
            }
        }
        if (!bl) {
            return new Range(d, d2);
        }
        return null;
    }
}

