/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.ValueDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class MeterPlot
extends Plot
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2987472457734470962L;
    static final Paint DEFAULT_DIAL_BACKGROUND_PAINT = Color.black;
    static final Paint DEFAULT_NEEDLE_PAINT = Color.green;
    static final Font DEFAULT_VALUE_FONT = new Font("SansSerif", 1, 12);
    static final Paint DEFAULT_VALUE_PAINT = Color.yellow;
    public static final int DEFAULT_METER_ANGLE = 270;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    private ValueDataset dataset;
    private DialShape shape = DialShape.CIRCLE;
    private int meterAngle = 270;
    private Range range = new Range(0.0, 100.0);
    private double tickSize = 10.0;
    private transient Paint tickPaint = Color.white;
    private String units = "Units";
    private Font valueFont;
    private transient Paint valuePaint;
    private boolean drawBorder;
    private transient Paint dialOutlinePaint;
    private transient Paint dialBackgroundPaint;
    private transient Paint needlePaint = DEFAULT_NEEDLE_PAINT;
    private boolean tickLabelsVisible = true;
    private Font tickLabelFont = DEFAULT_LABEL_FONT;
    private transient Paint tickLabelPaint = Color.black;
    private NumberFormat tickLabelFormat = NumberFormat.getInstance();
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private List intervals;

    public MeterPlot() {
        this(null);
    }

    public MeterPlot(ValueDataset valueDataset) {
        this.valueFont = DEFAULT_VALUE_FONT;
        this.valuePaint = DEFAULT_VALUE_PAINT;
        this.dialBackgroundPaint = DEFAULT_DIAL_BACKGROUND_PAINT;
        this.intervals = new ArrayList();
        this.setDataset(valueDataset);
    }

    public DialShape getDialShape() {
        return this.shape;
    }

    public void setDialShape(DialShape dialShape) {
        if (dialShape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.shape = dialShape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        if (n < 1 || n > 360) {
            throw new IllegalArgumentException("Invalid 'angle' (" + n + ")");
        }
        this.meterAngle = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        if (!(range.getLength() > 0.0)) {
            throw new IllegalArgumentException("Range length must be positive.");
        }
        this.range = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires 'size' > 0.");
        }
        this.tickSize = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getTickPaint() {
        return this.tickPaint;
    }

    public void setTickPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNeedlePaint() {
        return this.needlePaint;
    }

    public void setNeedlePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.needlePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (this.tickLabelsVisible != bl) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getTickLabelFormat() {
        return this.tickLabelFormat;
    }

    public void setTickLabelFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.tickLabelFormat = numberFormat;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.valueFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.valuePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialBackgroundPaint() {
        return this.dialBackgroundPaint;
    }

    public void setDialBackgroundPaint(Paint paint) {
        this.dialBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialOutlinePaint() {
        return this.dialOutlinePaint;
    }

    public void setDialOutlinePaint(Paint paint) {
        this.dialOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        ValueDataset valueDataset2 = this.dataset;
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.dataset = valueDataset;
        if (valueDataset != null) {
            this.setDatasetGroup(valueDataset.getGroup());
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public List getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    public void addInterval(MeterInterval meterInterval) {
        if (meterInterval == null) {
            throw new IllegalArgumentException("Null 'interval' argument.");
        }
        this.intervals.add(meterInterval);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearIntervals() {
        this.intervals.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        for (MeterInterval meterInterval : this.intervals) {
            Paint paint = meterInterval.getBackgroundPaint();
            if (paint == null) {
                paint = meterInterval.getOutlinePaint();
            }
            LegendItem legendItem = new LegendItem(meterInterval.getLabel(), meterInterval.getLabel(), null, null, (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), paint);
            legendItemCollection.add(legendItem);
        }
        return legendItemCollection;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        rectangle2D.setRect(rectangle2D.getX() + 4.0, rectangle2D.getY() + 4.0, rectangle2D.getWidth() - 8.0, rectangle2D.getHeight() - 8.0);
        if (this.drawBorder) {
            this.drawBackground(graphics2D, rectangle2D);
        }
        double d = 6.0;
        double d2 = 6.0;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2 + (this.meterAngle <= 180 && this.shape != DialShape.CIRCLE ? rectangle2D.getHeight() / 1.25 : 0.0);
        double d7 = Math.min(d5, d6) / 2.0;
        d3 = (d3 + d3 + d5) / 2.0 - d7;
        d4 = (d4 + d4 + d6) / 2.0 - d7;
        d5 = 2.0 * d7;
        d6 = 2.0 * d7;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)double_).getX() - 4.0, ((RectangularShape)double_).getY() - 4.0, ((RectangularShape)double_).getWidth() + 8.0, ((RectangularShape)double_).getHeight() + 8.0);
        double d8 = double_.getCenterX();
        double d9 = double_.getCenterY();
        ValueDataset valueDataset = this.getDataset();
        if (valueDataset != null) {
            Serializable serializable2;
            double d10 = this.range.getLowerBound();
            double d11 = this.range.getUpperBound();
            Shape shape = graphics2D.getClip();
            graphics2D.clip(double_2);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            if (this.dialBackgroundPaint != null) {
                this.fillArc(graphics2D, double_2, d10, d11, this.dialBackgroundPaint, true);
            }
            this.drawTicks(graphics2D, double_, d10, d11);
            this.drawArcForInterval(graphics2D, double_, new MeterInterval("", this.range, this.dialOutlinePaint, new BasicStroke(1.0f), null));
            for (Serializable serializable2 : this.intervals) {
                this.drawArcForInterval(graphics2D, double_, (MeterInterval)serializable2);
            }
            serializable2 = valueDataset.getValue();
            if (serializable2 != null) {
                double d12 = ((Number)serializable2).doubleValue();
                this.drawValueLabel(graphics2D, double_);
                if (this.range.contains(d12)) {
                    graphics2D.setPaint(this.needlePaint);
                    graphics2D.setStroke(new BasicStroke(2.0f));
                    double d13 = ((RectangularShape)double_).getWidth() / 2.0 + 3.0 + 15.0;
                    double d14 = this.valueToAngle(d12);
                    double d15 = d8 + d13 * Math.cos(Math.PI * (d14 / 180.0));
                    double d16 = d9 - d13 * Math.sin(Math.PI * (d14 / 180.0));
                    Polygon polygon = new Polygon();
                    if (d14 > 135.0 && d14 < 225.0 || d14 < 45.0 && d14 > -45.0) {
                        double d17 = d9 - 2.5;
                        double d18 = d9 + 2.5;
                        polygon.addPoint((int)d8, (int)d17);
                        polygon.addPoint((int)d8, (int)d18);
                    } else {
                        polygon.addPoint((int)(d8 - 2.5), (int)d9);
                        polygon.addPoint((int)(d8 + 2.5), (int)d9);
                    }
                    polygon.addPoint((int)d15, (int)d16);
                    graphics2D.fill(polygon);
                    Ellipse2D.Double double_3 = new Ellipse2D.Double(d8 - 5.0, d9 - 5.0, 10.0, 10.0);
                    graphics2D.fill(double_3);
                }
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
        if (this.drawBorder) {
            this.drawOutline(graphics2D, rectangle2D);
        }
    }

    protected void drawArcForInterval(Graphics2D graphics2D, Rectangle2D rectangle2D, MeterInterval meterInterval) {
        double d = meterInterval.getRange().getLowerBound();
        double d2 = meterInterval.getRange().getUpperBound();
        Paint paint = meterInterval.getOutlinePaint();
        Stroke stroke = meterInterval.getOutlineStroke();
        Paint paint2 = meterInterval.getBackgroundPaint();
        if (paint2 != null) {
            this.fillArc(graphics2D, rectangle2D, d, d2, paint2, false);
        }
        if (paint != null) {
            if (stroke != null) {
                this.drawArc(graphics2D, rectangle2D, d, d2, paint, stroke);
            }
            this.drawTick(graphics2D, rectangle2D, d, true);
            this.drawTick(graphics2D, rectangle2D, d2, true);
        }
    }

    protected void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint, Stroke stroke) {
        double d3 = this.valueToAngle(d2);
        double d4 = this.valueToAngle(d);
        double d5 = d4 - d3;
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getWidth();
        double d9 = rectangle2D.getHeight();
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (paint != null && stroke != null) {
            Arc2D.Double double_ = new Arc2D.Double(d6, d7, d8, d9, d3, d5, 0);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(double_);
        }
    }

    protected void fillArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint, boolean bl) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        double d3 = this.valueToAngle(d2);
        double d4 = this.valueToAngle(d);
        double d5 = d4 - d3;
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getWidth();
        double d9 = rectangle2D.getHeight();
        int n = 0;
        if (this.shape == DialShape.PIE) {
            n = 2;
        } else if (this.shape == DialShape.CHORD) {
            n = bl && this.meterAngle > 180 ? 1 : 2;
        } else if (this.shape == DialShape.CIRCLE) {
            n = 2;
            if (bl) {
                d5 = 360.0;
            }
        } else {
            throw new IllegalStateException("DialShape not recognised.");
        }
        graphics2D.setPaint(paint);
        Arc2D.Double double_ = new Arc2D.Double(d6, d7, d8, d9, d3, d5, n);
        graphics2D.fill(double_);
    }

    public double valueToAngle(double d) {
        double d2 = 180 + (this.meterAngle - 180) / 2;
        return d2 - (d -= this.range.getLowerBound()) / this.range.getLength() * (double)this.meterAngle;
    }

    protected void drawTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2) {
        for (double d3 = d; d3 <= d2; d3 += this.tickSize) {
            this.drawTick(graphics2D, rectangle2D, d3);
        }
    }

    protected void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        this.drawTick(graphics2D, rectangle2D, d, false);
    }

    protected void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl) {
        double d2 = this.valueToAngle(d);
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        graphics2D.setPaint(this.tickPaint);
        graphics2D.setStroke(new BasicStroke(2.0f));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = rectangle2D.getWidth() / 2.0 + 3.0;
        double d8 = d7 - 15.0;
        double d9 = d3 + d7 * Math.cos(Math.PI * (d2 / 180.0));
        double d10 = d4 - d7 * Math.sin(Math.PI * (d2 / 180.0));
        d5 = d3 + d8 * Math.cos(Math.PI * (d2 / 180.0));
        d6 = d4 - d8 * Math.sin(Math.PI * (d2 / 180.0));
        Line2D.Double double_ = new Line2D.Double(d9, d10, d5, d6);
        graphics2D.draw(double_);
        if (this.tickLabelsVisible && bl) {
            String string = this.tickLabelFormat.format(d);
            graphics2D.setFont(this.tickLabelFont);
            graphics2D.setPaint(this.tickLabelPaint);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            double d11 = d5;
            double d12 = d6;
            if (d2 == 90.0 || d2 == 270.0) {
                d11 -= rectangle2D2.getWidth() / 2.0;
            } else if (d2 < 90.0 || d2 > 270.0) {
                d11 -= rectangle2D2.getWidth();
            }
            d12 = d2 > 135.0 && d2 < 225.0 || d2 > 315.0 || d2 < 45.0 ? (d12 -= rectangle2D2.getHeight() / 2.0) : (d12 += rectangle2D2.getHeight() / 2.0);
            graphics2D.drawString(string, (float)d11, (float)d12);
        }
    }

    protected void drawValueLabel(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Number number;
        graphics2D.setFont(this.valueFont);
        graphics2D.setPaint(this.valuePaint);
        String string = "No value";
        if (this.dataset != null && (number = this.dataset.getValue()) != null) {
            string = this.tickLabelFormat.format(number.doubleValue()) + " " + this.units;
        }
        float f = (float)rectangle2D.getCenterX();
        float f2 = (float)rectangle2D.getCenterY() + 10.0f;
        TextUtilities.drawAlignedString(string, graphics2D, f, f2, TextAnchor.TOP_CENTER);
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Meter_Plot");
    }

    @Override
    public void zoom(double d) {
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MeterPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MeterPlot meterPlot = (MeterPlot)object;
        if (!ObjectUtilities.equal(this.units, meterPlot.units)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.range, meterPlot.range)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.intervals, meterPlot.intervals)) {
            return false;
        }
        if (!PaintUtilities.equal(this.dialOutlinePaint, meterPlot.dialOutlinePaint)) {
            return false;
        }
        if (this.shape != meterPlot.shape) {
            return false;
        }
        if (!PaintUtilities.equal(this.dialBackgroundPaint, meterPlot.dialBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.needlePaint, meterPlot.needlePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.valueFont, meterPlot.valueFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.valuePaint, meterPlot.valuePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickPaint, meterPlot.tickPaint)) {
            return false;
        }
        if (this.tickSize != meterPlot.tickSize) {
            return false;
        }
        if (this.tickLabelsVisible != meterPlot.tickLabelsVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelFont, meterPlot.tickLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, meterPlot.tickLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelFormat, meterPlot.tickLabelFormat)) {
            return false;
        }
        if (this.drawBorder != meterPlot.drawBorder) {
            return false;
        }
        return this.meterAngle == meterPlot.meterAngle;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.dialBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.needlePaint, objectOutputStream);
        SerialUtilities.writePaint(this.valuePaint, objectOutputStream);
        SerialUtilities.writePaint(this.tickPaint, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dialBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.needlePaint = SerialUtilities.readPaint(objectInputStream);
        this.valuePaint = SerialUtilities.readPaint(objectInputStream);
        this.tickPaint = SerialUtilities.readPaint(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MeterPlot meterPlot = (MeterPlot)super.clone();
        meterPlot.tickLabelFormat = (NumberFormat)this.tickLabelFormat.clone();
        meterPlot.intervals = new ArrayList(this.intervals);
        if (meterPlot.dataset != null) {
            meterPlot.dataset.addChangeListener(meterPlot);
        }
        return meterPlot;
    }
}

