/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.encoders;

import java.util.Hashtable;
import org.jfree.chart.encoders.ImageEncoder;

public class ImageEncoderFactory {
    private static Hashtable encoders = null;

    private static void init() {
        encoders = new Hashtable();
        encoders.put("jpeg", "org.jfree.chart.encoders.SunJPEGEncoderAdapter");
        try {
            Class.forName("javax.imageio.ImageIO");
            Class.forName("org.jfree.chart.encoders.SunPNGEncoderAdapter");
            encoders.put("png", "org.jfree.chart.encoders.SunPNGEncoderAdapter");
            encoders.put("jpeg", "org.jfree.chart.encoders.SunJPEGEncoderAdapter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            encoders.put("png", "org.jfree.chart.encoders.KeypointPNGEncoderAdapter");
        }
    }

    public static void setImageEncoder(String string, String string2) {
        encoders.put(string, string2);
    }

    public static ImageEncoder newInstance(String string) {
        ImageEncoder imageEncoder = null;
        String string2 = (String)encoders.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Unsupported image format - " + string);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            imageEncoder = (ImageEncoder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, float f) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setQuality(f);
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, boolean bl) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setEncodingAlpha(bl);
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, float f, boolean bl) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setQuality(f);
        imageEncoder.setEncodingAlpha(bl);
        return imageEncoder;
    }

    static {
        ImageEncoderFactory.init();
    }
}

