/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class NestedTypeBinding
extends SourceTypeBinding {
    public SourceTypeBinding enclosingType;
    public SyntheticArgumentBinding[] enclosingInstances;
    public SyntheticArgumentBinding[] outerLocalVariables;
    public int enclosingInstancesSlotSize;
    public int outerLocalVariablesSlotSize;

    public NestedTypeBinding(char[][] cArray, ClassScope classScope, SourceTypeBinding sourceTypeBinding) {
        super(cArray, sourceTypeBinding.fPackage, classScope);
        this.tagBits |= 4L;
        this.enclosingType = sourceTypeBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.outerLocalVariables == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            this.outerLocalVariables = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n;
            int n2 = n = this.outerLocalVariables.length;
            int n3 = n;
            while (--n3 >= 0) {
                if (this.outerLocalVariables[n3].actualOuterLocalVariable == localVariableBinding) {
                    return this.outerLocalVariables[n3];
                }
                if (this.outerLocalVariables[n3].id <= localVariableBinding.id) continue;
                n2 = n3;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n + 1];
            System.arraycopy(this.outerLocalVariables, 0, syntheticArgumentBindingArray, 0, n2);
            syntheticArgumentBindingArray[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            System.arraycopy(this.outerLocalVariables, n2, syntheticArgumentBindingArray, n2 + 1, n - n2);
            this.outerLocalVariables = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgument(ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.enclosingInstances == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n;
            int n2 = n = this.enclosingInstances.length;
            int n3 = n;
            while (--n3 >= 0) {
                if (this.enclosingInstances[n3].type == referenceBinding) {
                    return this.enclosingInstances[n3];
                }
                if (this.enclosingType() != referenceBinding) continue;
                n2 = 0;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n + 1];
            System.arraycopy(this.enclosingInstances, 0, syntheticArgumentBindingArray, n2 == 0 ? 1 : 0, n);
            syntheticArgumentBindingArray[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(LocalVariableBinding localVariableBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(localVariableBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(localVariableBinding);
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(referenceBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(referenceBinding);
        }
        return syntheticArgumentBinding;
    }

    public final void computeSyntheticArgumentSlotSizes() {
        int n;
        int n2 = 0;
        int n3 = this.enclosingInstances == null ? 0 : this.enclosingInstances.length;
        for (n = 0; n < n3; ++n) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.enclosingInstances[n];
            syntheticArgumentBinding.resolvedPosition = n2 + 1;
            if (n2 + 1 > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, this.scope.referenceType());
            }
            if (syntheticArgumentBinding.type == TypeBinding.LONG || syntheticArgumentBinding.type == TypeBinding.DOUBLE) {
                n2 += 2;
                continue;
            }
            ++n2;
        }
        this.enclosingInstancesSlotSize = n2;
        n2 = 0;
        n = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        for (int i = 0; i < n; ++i) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[i];
            if (syntheticArgumentBinding.type == TypeBinding.LONG || syntheticArgumentBinding.type == TypeBinding.DOUBLE) {
                n2 += 2;
                continue;
            }
            ++n2;
        }
        this.outerLocalVariablesSlotSize = n2;
    }

    @Override
    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        if (this.outerLocalVariables == null) {
            return null;
        }
        int n = this.outerLocalVariables.length;
        while (--n >= 0) {
            if (this.outerLocalVariables[n].actualOuterLocalVariable != localVariableBinding) continue;
            return this.outerLocalVariables[n];
        }
        return null;
    }

    public SyntheticArgumentBinding[] syntheticEnclosingInstances() {
        return this.enclosingInstances;
    }

    @Override
    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.enclosingInstances == null) {
            return null;
        }
        int n = this.enclosingInstances.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        for (int i = 0; i < n; ++i) {
            referenceBindingArray[i] = (ReferenceBinding)this.enclosingInstances[i].type;
        }
        return referenceBindingArray;
    }

    @Override
    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.outerLocalVariables;
    }

    public void updateInnerEmulationDependents() {
    }

    public SyntheticArgumentBinding getSyntheticArgument(ReferenceBinding referenceBinding, boolean bl) {
        if (this.enclosingInstances == null) {
            return null;
        }
        int n = this.enclosingInstances.length;
        while (--n >= 0) {
            if (this.enclosingInstances[n].type != referenceBinding || this.enclosingInstances[n].actualOuterLocalVariable != null) continue;
            return this.enclosingInstances[n];
        }
        if (!bl) {
            n = this.enclosingInstances.length;
            while (--n >= 0) {
                if (this.enclosingInstances[n].actualOuterLocalVariable != null || this.enclosingInstances[n].type.findSuperTypeWithSameErasure(referenceBinding) == null) continue;
                return this.enclosingInstances[n];
            }
        }
        return null;
    }
}

