/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);
    public ASTNode associatedNode;
    public FlowContext parent;
    public NullInfoRegistry initsOnFinally;
    boolean deferNullDiagnostic;
    boolean preemptNullDiagnostic;
    public static final int CAN_ONLY_NULL_NON_NULL = 20;
    public static final int CAN_ONLY_NULL = 21;
    public static final int MAY_NULL = 22;
    public static final int CAN_ONLY_NON_NULL = 23;

    public FlowContext(FlowContext flowContext, ASTNode aSTNode) {
        this.parent = flowContext;
        this.associatedNode = aSTNode;
        if (flowContext != null) {
            this.deferNullDiagnostic = flowContext.deferNullDiagnostic || flowContext.preemptNullDiagnostic;
            this.initsOnFinally = flowContext.initsOnFinally;
        }
    }

    public BranchLabel breakLabel() {
        return null;
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        FlowContext flowContext = this;
        while (flowContext != null) {
            TypeConstants typeConstants;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                typeConstants = (ExceptionHandlingFlowContext)flowContext;
                ReferenceBinding[] referenceBindingArray = ((ExceptionHandlingFlowContext)typeConstants).handledExceptions;
                if (((ExceptionHandlingFlowContext)typeConstants).handledExceptions != Binding.NO_EXCEPTIONS) {
                    boolean bl = false;
                    block5: for (ReferenceBinding referenceBinding : referenceBindingArray) {
                        int n = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                        switch (n) {
                            case -1: {
                                ((ExceptionHandlingFlowContext)typeConstants).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, bl);
                                bl = true;
                                continue block5;
                            }
                            case 1: {
                                ((ExceptionHandlingFlowContext)typeConstants).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, false);
                            }
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (((ExceptionHandlingFlowContext)typeConstants).isMethodContext) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    if (typeBinding.isUncheckedException(false)) {
                        return;
                    }
                    if (!(((ExceptionHandlingFlowContext)typeConstants).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)typeConstants).associatedNode).isConstructor() || !abstractMethodDeclaration.binding.declaringClass.isAnonymousType()) break;
                    ((ExceptionHandlingFlowContext)typeConstants).mergeUnhandledException(typeBinding);
                    return;
                }
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext instanceof InsideSubRoutineFlowContext && (typeConstants = flowContext.associatedNode) instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)typeConstants;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
        blockScope.problemReporter().unhandledException(typeBinding, aSTNode);
    }

    public void checkExceptionHandlers(TypeBinding[] typeBindingArray, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n;
        if (typeBindingArray == null || (n = typeBindingArray.length) == 0) {
            return;
        }
        int n2 = n;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        typeBindingArray = new TypeBinding[n];
        System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
        FlowContext flowContext = this;
        while (flowContext != null) {
            Object object2;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                Object object3;
                int n3;
                object = (ExceptionHandlingFlowContext)flowContext;
                object2 = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    int n4;
                    n3 = ((ReferenceBinding[])object2).length;
                    object3 = new boolean[n];
                    for (n4 = 0; n4 < n3; ++n4) {
                        ReferenceBinding referenceBinding = object2[n4];
                        block6: for (int i = 0; i < n; ++i) {
                            TypeBinding typeBinding = typeBindingArray[i];
                            if (typeBinding == null) continue;
                            int n5 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                            switch (n5) {
                                case -1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, (boolean)object3[i]);
                                    if (object3[i] != false) continue block6;
                                    object3[i] = true;
                                    --n2;
                                    continue block6;
                                }
                                case 1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, false);
                                }
                            }
                        }
                    }
                    for (n4 = 0; n4 < n; ++n4) {
                        if (object3[n4] == false) continue;
                        typeBindingArray[n4] = null;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).isMethodContext) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    for (n3 = 0; n3 < n; ++n3) {
                        TypeBinding typeBinding = typeBindingArray[n3];
                        object3 = typeBinding;
                        if (typeBinding == null || !((TypeBinding)object3).isUncheckedException(false)) continue;
                        --n2;
                        typeBindingArray[n3] = null;
                    }
                    if (!(((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode).isConstructor() || !abstractMethodDeclaration.binding.declaringClass.isAnonymousType()) break;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding = typeBindingArray[i];
                        if (typeBinding == null) continue;
                        ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                    }
                    return;
                }
            }
            if (n2 == 0) {
                return;
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext instanceof InsideSubRoutineFlowContext && (object = flowContext.associatedNode) instanceof TryStatement) {
                object2 = (TryStatement)object;
                flowInfo.addInitializationsFrom(object2.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
        block10: for (int i = 0; i < n; ++i) {
            object = typeBindingArray[i];
            if (object == null) continue;
            for (int j = 0; j < i; ++j) {
                if (typeBindingArray[j] == object) continue block10;
            }
            blockScope.problemReporter().unhandledException((TypeBinding)object, aSTNode);
        }
    }

    public BranchLabel continueLabel() {
        return null;
    }

    public FlowContext getTargetContextForBreakLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            char[] cArray2;
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if ((cArray2 = flowContext.labelName()) != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        FlowContext flowContext3 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext3 = flowContext;
            } else if (flowContext.isContinuable()) {
                flowContext2 = flowContext;
            }
            char[] cArray2 = flowContext.labelName();
            if (cArray2 != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 != null && flowContext.associatedNode.concreteStatement() == flowContext2.associatedNode) {
                    if (flowContext3 == null) {
                        return flowContext2;
                    }
                    return flowContext3;
                }
                return NotContinuableContext;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isBreakable() && flowContext.labelName() == null) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isContinuable()) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
    }

    public void recordSettingFinal(VariableBinding variableBinding, Reference reference, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            FlowContext flowContext = this;
            while (flowContext != null && flowContext.recordFinalAssignment(variableBinding, reference)) {
                flowContext = flowContext.parent;
            }
        }
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n) {
            case 20: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    return;
                }
            }
            case 21: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (!flowInfo.isPotentiallyUnknown(localVariableBinding)) break;
                return;
            }
            case 22: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                scope.problemReporter().localVariableMayBeNull(localVariableBinding, expression);
                return;
            }
        }
        if (this.parent != null) {
            this.parent.recordUsingNullReference(scope, localVariableBinding, expression, n, flowInfo);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subroutine() {
        return null;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FlowContext flowContext = this;
        int n2 = 0;
        while ((flowContext = flowContext.parent) != null) {
            ++n2;
        }
        FlowContext[] flowContextArray = new FlowContext[n2 + 1];
        flowContext = this;
        int n3 = n2;
        while (n3 >= 0) {
            flowContextArray[n3--] = flowContext;
            flowContext = flowContext.parent;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(flowContextArray[n].individualToString()).append('\n');
        }
        stringBuffer.append('*');
        for (n = 0; n < n2 + 1; ++n) {
            stringBuffer.append('\t');
        }
        stringBuffer.append(this.individualToString()).append('\n');
        return stringBuffer.toString();
    }
}

