/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    @Override
    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding typeBinding;
            int n;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.declaringClass.isLocalType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.arguments != null) {
                int n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[n].binding);
                }
            }
            if (this.statements != null) {
                n = 0;
                for (Statement statement : this.statements) {
                    if (!statement.complainIfUnreachable(flowInfo, this.scope, n != 0)) {
                        flowInfo = statement.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                        continue;
                    }
                    n = 1;
                }
            }
            if ((typeBinding = this.binding.returnType) == TypeBinding.VOID || this.isAbstract()) {
                this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    @Override
    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        if (this.returnType == null) {
            return stringBuffer;
        }
        return this.returnType.printExpression(0, stringBuffer).append(' ');
    }

    @Override
    public void resolveStatements() {
        long l;
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        if (this.typeParameters != null) {
            int n = this.typeParameters.length;
            for (int i = 0; i < n; ++i) {
                this.typeParameters[i].resolve(this.scope);
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (this.binding != null && (l = compilerOptions.sourceLevel) >= 0x310000L) {
            int n = this.binding.modifiers;
            boolean bl = (this.binding.tagBits & 0x1000000000000L) != 0L;
            boolean bl2 = this.binding.declaringClass.isInterface();
            if (bl) {
                if (!(!bl2 && (n & 0x10000008) == 0x10000000 || l >= 0x320000L && (n & 0x20000008) == 0x20000000)) {
                    this.scope.problemReporter().methodMustOverride(this);
                }
            } else if (!bl2 && (n & 0x10000008) == 0x10000000) {
                this.scope.problemReporter().missingOverrideAnnotation(this);
            }
        }
        switch (TypeDeclaration.kind(this.scope.referenceType().modifiers)) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) == 0 && (this.modifiers & 0x400) == 0) break;
                this.scope.problemReporter().methodNeedingNoBody(this);
            }
        }
        super.resolveStatements();
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                for (n = 0; n < n2; ++n) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

