/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MemberValuePair
extends ASTNode {
    public char[] name;
    public Expression value;
    public MethodBinding binding;
    public ElementValuePair compilerElementPair = null;

    public MemberValuePair(char[] cArray, int n, int n2, Expression expression) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.value = expression;
        if (expression instanceof ArrayInitializer) {
            expression.bits |= 1;
        }
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.name).append(" = ");
        this.value.print(0, stringBuffer);
        return stringBuffer;
    }

    public void resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        Object object;
        if (this.value == null) {
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        if (typeBinding == null) {
            if (this.value instanceof ArrayInitializer) {
                this.value.resolveTypeExpecting(blockScope, null);
            } else {
                this.value.resolveType(blockScope);
            }
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        this.value.setExpectedType(typeBinding);
        if (this.value instanceof ArrayInitializer) {
            object = (ArrayInitializer)this.value;
            typeBinding2 = ((ArrayInitializer)object).resolveTypeExpecting(blockScope, this.binding.returnType);
        } else if (this.value instanceof ArrayAllocationExpression) {
            blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.value);
            this.value.resolveType(blockScope);
            typeBinding2 = null;
        } else {
            typeBinding2 = this.value.resolveType(blockScope);
        }
        this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
        if (typeBinding2 == null) {
            return;
        }
        object = typeBinding.leafComponentType();
        if (!(this.value.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, typeBinding2.id) || typeBinding2.isCompatibleWith(typeBinding))) {
            if (!(typeBinding.isArrayType() && typeBinding.dimensions() == 1 && (this.value.isConstantValueOfTypeAssignableToType(typeBinding2, (TypeBinding)object) || ((TypeBinding)object).isBaseType() && BaseTypeBinding.isWidening(((TypeBinding)object).id, typeBinding2.id)) || typeBinding2.isCompatibleWith((TypeBinding)object))) {
                if (((TypeBinding)object).isAnnotationType() && !typeBinding2.isAnnotationType()) {
                    blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
                } else {
                    blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.value);
                }
                return;
            }
        } else {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding.leafComponentType(), typeBinding2.leafComponentType());
            this.value.computeConversion(blockScope, typeBinding, typeBinding2);
        }
        switch (((TypeBinding)object).erasure().id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = expressionArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (expressionArray[i].constant != Constant.NotAConstant) continue;
                        blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expressionArray[i]);
                    }
                    break;
                }
                if (this.value.constant != Constant.NotAConstant) break;
                if (typeBinding2.isArrayType()) {
                    blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.value);
                    break;
                }
                blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value);
                break;
            }
            case 16: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    for (Expression expression : expressionArray) {
                        if (expression instanceof ClassLiteralAccess) continue;
                        blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, expression);
                    }
                    break;
                }
                if (this.value instanceof ClassLiteralAccess) break;
                blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, this.value);
                break;
            }
            default: {
                if (((TypeBinding)object).isEnum()) {
                    if (this.value instanceof NullLiteral) {
                        blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value);
                        break;
                    }
                    if (this.value instanceof ArrayInitializer) {
                        ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                        Expression[] expressionArray = arrayInitializer.expressions;
                        if (expressionArray == null) break;
                        for (Expression expression : expressionArray) {
                            if (expression instanceof NullLiteral) {
                                blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expression);
                                continue;
                            }
                            if (!(expression instanceof NameReference)) continue;
                            NameReference nameReference = (NameReference)expression;
                            Binding binding = nameReference.binding;
                            if (binding.kind() != 1) continue;
                            FieldBinding fieldBinding = (FieldBinding)binding;
                            if (fieldBinding.declaringClass.isEnum()) continue;
                            blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expression);
                        }
                        break;
                    }
                    if (!(this.value instanceof NameReference)) break;
                    NameReference nameReference = (NameReference)this.value;
                    Binding binding = nameReference.binding;
                    if (binding.kind() != 1) break;
                    FieldBinding fieldBinding = (FieldBinding)binding;
                    if (fieldBinding.declaringClass.isEnum()) break;
                    if (!fieldBinding.type.isArrayType()) {
                        blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value);
                        break;
                    }
                    blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.value);
                    break;
                }
                if (!((TypeBinding)object).isAnnotationType()) break;
                if (!typeBinding2.leafComponentType().isAnnotationType()) {
                    blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
                    break;
                }
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    for (Expression expression : expressionArray) {
                        if (!(expression instanceof NullLiteral) && expression instanceof Annotation) continue;
                        blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, expression, (TypeBinding)object);
                    }
                    break;
                }
                if (this.value instanceof Annotation) break;
                blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.value != null) {
            this.value.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (aSTVisitor.visit(this, compilationUnitScope) && this.value != null) {
            this.value.traverse(aSTVisitor, compilationUnitScope);
        }
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

