/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    boolean discardEnclosingInstance;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int n) {
        this.accessMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                }
            }
            TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                flowContext.checkExceptionHandlers(typeBindingArray, this.accessMode == 1 ? (ASTNode)((Object)blockScope.methodScope().referenceContext) : this, flowInfo, blockScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            int n = codeStream.position;
            codeStream.aload_0();
            ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
            if (referenceBinding.erasure().id == 41 || referenceBinding.isEnum()) {
                codeStream.aload_1();
                codeStream.iload_2();
            }
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.discardEnclosingInstance ? null : this.qualification, this);
            }
            this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
            }
            if (this.syntheticAccessor != null) {
                int n2 = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
                for (int i = 0; i < n2; ++i) {
                    codeStream.aconst_null();
                }
                codeStream.invokespecial(this.syntheticAccessor);
            } else {
                codeStream.invokespecial(this.codegenBinding);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    @Override
    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if ((flowInfo.tagBits & 1) == 0 && referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.qualification != null);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                }
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        ExplicitConstructorCall.printIndent(n, stringBuffer);
        if (this.qualification != null) {
            this.qualification.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.accessMode == 3) {
            stringBuffer.append("this(");
        } else {
            stringBuffer.append("super(");
        }
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(");");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(BlockScope blockScope) {
        MethodScope methodScope = blockScope.methodScope();
        try {
            int n;
            TypeBinding[] typeBindingArray;
            AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
            if (abstractMethodDeclaration == null || !abstractMethodDeclaration.isConstructor() || ((ConstructorDeclaration)abstractMethodDeclaration).constructorCall != this) {
                blockScope.problemReporter().invalidExplicitConstructorCall(this);
                return;
            }
            methodScope.isConstructorCall = true;
            ReferenceBinding referenceBinding = blockScope.enclosingReceiverType();
            if (this.accessMode != 3) {
                referenceBinding = referenceBinding.superclass();
            }
            if (referenceBinding == null) {
                return;
            }
            if (this.accessMode == 2 && referenceBinding.erasure().id == 41) {
                blockScope.problemReporter().cannotInvokeSuperConstructorInEnum(this, methodScope.referenceMethod().binding);
            }
            if (this.qualification != null) {
                if (this.accessMode != 2) {
                    blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, referenceBinding);
                }
                if ((typeBindingArray = referenceBinding.enclosingType()) == null) {
                    blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, referenceBinding);
                    this.discardEnclosingInstance = true;
                } else {
                    TypeBinding typeBinding = this.qualification.resolveTypeExpecting(blockScope, (TypeBinding)typeBindingArray);
                    this.qualification.computeConversion(blockScope, typeBinding, typeBinding);
                }
            }
            if (this.typeArguments != null) {
                int n2 = this.typeArguments.length;
                boolean bl = false;
                this.genericTypeArguments = new TypeBinding[n2];
                for (n = 0; n < n2; ++n) {
                    this.genericTypeArguments[n] = this.typeArguments[n].resolveType(blockScope, true);
                    if (this.genericTypeArguments[n] != null) continue;
                    bl = true;
                }
                if (bl) {
                    return;
                }
            }
            typeBindingArray = Binding.NO_PARAMETERS;
            boolean bl = false;
            if (this.arguments != null) {
                n = 0;
                int n3 = this.arguments.length;
                typeBindingArray = new TypeBinding[n3];
                for (int i = 0; i < n3; ++i) {
                    Expression expression = this.arguments[i];
                    if (expression instanceof CastExpression) {
                        expression.bits |= 0x20;
                        bl = true;
                    }
                    if ((typeBindingArray[i] = expression.resolveType(blockScope)) != null) continue;
                    n = 1;
                }
                if (n != 0) {
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n3];
                    int n4 = n3;
                    while (--n4 >= 0) {
                        typeBindingArray2[n4] = typeBindingArray[n4] == null ? referenceBinding : typeBindingArray[n4];
                    }
                    this.binding = blockScope.findMethod(referenceBinding, TypeConstants.INIT, typeBindingArray2, this);
                    return;
                }
            } else if (referenceBinding.erasure().id == 41) {
                typeBindingArray = new TypeBinding[]{blockScope.getJavaLangString(), TypeBinding.INT};
            }
            this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, blockScope, this.accessMode != 1)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
                ExplicitConstructorCall.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl, this);
                if (this.binding.isPrivate() || referenceBinding.isLocalType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            methodScope.isConstructorCall = false;
        }
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n) {
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.qualification != null) {
                this.qualification.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

