/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Log log = LogFactory.getLog(ConvertUtils.class);
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean bl) {
        this.defaultBoolean = new Boolean(bl);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.class);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte by) {
        this.defaultByte = new Byte(by);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), Byte.class);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char c) {
        this.defaultCharacter = new Character(c);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), Character.class);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double d) {
        this.defaultDouble = new Double(d);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), Double.class);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float f) {
        this.defaultFloat = new Float(f);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), Float.class);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int n) {
        this.defaultInteger = new Integer(n);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), Integer.class);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long l) {
        this.defaultLong = new Long(l);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), Long.class);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short s) {
        defaultShort = new Short(s);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), Short.class);
    }

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            if (Array.getLength(object) < 1) {
                return null;
            }
            if ((object = Array.get(object, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(String.class);
            return (String)converter.convert(String.class, object);
        }
        Converter converter = this.lookup(String.class);
        return (String)converter.convert(String.class, object);
    }

    public Object convert(String string, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string '" + string + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        Converter converter;
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + stringArray.length + "] to class '" + clazz2.getName() + "[]'");
        }
        if ((converter = this.lookup(clazz2)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Array.set(object, i, converter.convert(clazz2, stringArray[i]));
        }
        return object;
    }

    public void deregister() {
        boolean[] blArray = new boolean[]{};
        byte[] byArray = new byte[]{};
        char[] cArray = new char[]{};
        double[] dArray = new double[]{};
        float[] fArray = new float[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        short[] sArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        this.register(Boolean.class, new BooleanConverter(this.defaultBoolean));
        this.register(blArray.getClass(), new BooleanArrayConverter(blArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        this.register(Byte.class, new ByteConverter(this.defaultByte));
        this.register(byArray.getClass(), new ByteArrayConverter(byArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        this.register(Character.class, new CharacterConverter(this.defaultCharacter));
        this.register(cArray.getClass(), new CharacterArrayConverter(cArray));
        this.register(Class.class, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        this.register(Double.class, new DoubleConverter(this.defaultDouble));
        this.register(dArray.getClass(), new DoubleArrayConverter(dArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        this.register(Float.class, new FloatConverter(this.defaultFloat));
        this.register(fArray.getClass(), new FloatArrayConverter(fArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        this.register(Integer.class, new IntegerConverter(this.defaultInteger));
        this.register(nArray.getClass(), new IntegerArrayConverter(nArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        this.register(Long.class, new LongConverter(this.defaultLong));
        this.register(lArray.getClass(), new LongArrayConverter(lArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        this.register(Short.class, new ShortConverter(defaultShort));
        this.register(sArray.getClass(), new ShortArrayConverter(sArray));
        this.register(String.class, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(File.class, new FileConverter());
        this.register(URL.class, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }
}

