/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    public static final String VIEWER_RENDER_BUFFER_MAX_SIZE = "net.sf.jasperreports.viewer.render.buffer.max.size";
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_PRINT = 3;
    public static final int REPORT_RESOLUTION = 72;
    protected float MIN_ZOOM = 0.5f;
    protected float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    JasperPrint jasperPrint = null;
    private int pageIndex = 0;
    private float zoom = 0.0f;
    private JRGraphics2DExporter exporter = null;
    private int screenResolution = 72;
    protected float realZoom = 0.0f;
    private DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private ResourceBundle resourceBundle = null;
    private int downX = 0;
    private int downY = 0;
    private List hyperlinkListeners = new ArrayList();
    private Map linksMap = new HashMap();
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JRViewer.this.hyperlinkClicked(mouseEvent);
        }
    };
    private List saveContributors = new ArrayList();
    protected JToggleButton btnActualSize;
    protected JButton btnFirst;
    protected JToggleButton btnFitPage;
    protected JToggleButton btnFitWidth;
    protected JButton btnLast;
    protected JButton btnNext;
    protected JButton btnPrevious;
    protected JButton btnPrint;
    protected JButton btnReload;
    protected JButton btnSave;
    protected JButton btnZoomIn;
    protected JButton btnZoomOut;
    protected JComboBox cmbZoom;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private PageRenderer lblPage;
    protected JLabel lblStatus;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    private JPanel pnlPage;
    protected JPanel pnlSep01;
    protected JPanel pnlSep02;
    protected JPanel pnlSep03;
    protected JPanel pnlStatus;
    private JScrollPane scrollPane;
    protected JPanel tlbToolBar;
    protected JTextField txtGoTo;

    public JRViewer(String string, boolean bl) throws JRException {
        this(string, bl, null);
    }

    public JRViewer(InputStream inputStream, boolean bl) throws JRException {
        this(inputStream, bl, null);
    }

    public JRViewer(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public JRViewer(String string, boolean bl, Locale locale) throws JRException {
        this(string, bl, locale, null);
    }

    public JRViewer(InputStream inputStream, boolean bl, Locale locale) throws JRException {
        this(inputStream, bl, locale, null);
    }

    public JRViewer(JasperPrint jasperPrint, Locale locale) {
        this(jasperPrint, locale, null);
    }

    public JRViewer(String string, boolean bl, Locale locale, ResourceBundle resourceBundle) throws JRException {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(string, bl);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(InputStream inputStream, boolean bl, Locale locale, ResourceBundle resourceBundle) throws JRException {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(inputStream, bl);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(JasperPrint jasperPrint, Locale locale, ResourceBundle resourceBundle) {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(jasperPrint);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void clear() {
        this.emptyContainer(this);
        this.jasperPrint = null;
    }

    protected void setZooms() {
    }

    public void addSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.add(jRSaveContributor);
    }

    public void removeSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.remove(jRSaveContributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void addHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.add(jRHyperlinkListener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.remove(jRHyperlinkListener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    protected void initResources(Locale locale, ResourceBundle resourceBundle) {
        if (locale != null) {
            this.setLocale(locale);
        } else {
            this.setLocale(Locale.getDefault());
        }
        this.resourceBundle = resourceBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resourceBundle;
    }

    protected String getBundleString(String string) {
        return this.resourceBundle.getString(string);
    }

    protected void initSaveContributors() {
        String[] stringArray = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class clazz = JRClassLoader.loadClassForName(stringArray[i]);
                Method method = clazz.getMethod("getInstance", null);
                JRSaveContributor jRSaveContributor = (JRSaveContributor)method.invoke(null, (Object[])null);
                this.saveContributors.add(jRSaveContributor);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void gotoHyperlink(JRPrintHyperlink jRPrintHyperlink) {
        switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 3: {
                Container container;
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                Map map = this.jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex jRPrintAnchorIndex = (JRPrintAnchorIndex)map.get(jRPrintHyperlink.getHyperlinkAnchor());
                if (jRPrintAnchorIndex.getPageIndex() != this.pageIndex) {
                    this.setPageIndex(jRPrintAnchorIndex.getPageIndex());
                    this.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport jViewport = (JViewport)container;
                int n = (int)((float)jRPrintAnchorIndex.getElementAbsoluteX() * this.realZoom);
                int n2 = (int)((float)jRPrintAnchorIndex.getElementAbsoluteY() * this.realZoom);
                int n3 = this.pnlInScroll.getWidth() - jViewport.getWidth();
                int n4 = this.pnlInScroll.getHeight() - jViewport.getHeight();
                if (n < 0) {
                    n = 0;
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                jViewport.setViewPosition(new Point(n, n2));
                break;
            }
            case 4: {
                int n = this.pageIndex + 1;
                if (jRPrintHyperlink.getHyperlinkPage() != null) {
                    n = jRPrintHyperlink.getHyperlinkPage();
                }
                if (n < 1 || n > this.jasperPrint.getPages().size() || n == this.pageIndex + 1) break;
                this.setPageIndex(n - 1);
                this.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport jViewport = (JViewport)container;
                jViewport.setViewPosition(new Point(0, 0));
                break;
            }
            case 5: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + jRPrintHyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 6: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + jRPrintHyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 7: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink of type " + jRPrintHyperlink.getLinkType());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    protected boolean isOnlyHyperlinkListener() {
        int n;
        if (this.hyperlinkListeners == null) {
            n = 0;
        } else {
            n = this.hyperlinkListeners.size();
            if (this.hyperlinkListeners.contains(this)) {
                --n;
            }
        }
        return n == 0;
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            defaultComboBoxModel.addElement("" + this.zooms[i] + "%");
        }
        this.cmbZoom.setModel(defaultComboBoxModel);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new PageRenderer(this);
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/save.GIF")));
        this.btnSave.setToolTipText(this.getBundleString("save"));
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnSaveActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/print.GIF")));
        this.btnPrint.setToolTipText(this.getBundleString("print"));
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnPrintActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setToolTipText(this.getBundleString("reload"));
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(23, 23));
        this.btnReload.setMinimumSize(new Dimension(23, 23));
        this.btnReload.setPreferredSize(new Dimension(23, 23));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnReloadActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/first.GIF")));
        this.btnFirst.setToolTipText(this.getBundleString("first.page"));
        this.btnFirst.setMargin(new Insets(2, 2, 2, 2));
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnFirstActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText(this.getBundleString("previous.page"));
        this.btnPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnPreviousActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/next.GIF")));
        this.btnNext.setToolTipText(this.getBundleString("next.page"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnNextActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/last.GIF")));
        this.btnLast.setToolTipText(this.getBundleString("last.page"));
        this.btnLast.setMargin(new Insets(2, 2, 2, 2));
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnLastActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnLast);
        this.txtGoTo.setToolTipText(this.getBundleString("go.to.page"));
        this.txtGoTo.setMaximumSize(new Dimension(40, 23));
        this.txtGoTo.setMinimumSize(new Dimension(40, 23));
        this.txtGoTo.setPreferredSize(new Dimension(40, 23));
        this.txtGoTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.txtGoToActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.txtGoTo);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.btnActualSize.setToolTipText(this.getBundleString("actual.size"));
        this.btnActualSize.setMargin(new Insets(2, 2, 2, 2));
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnActualSizeActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.btnFitPage.setToolTipText(this.getBundleString("fit.page"));
        this.btnFitPage.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnFitPageActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.btnFitWidth.setToolTipText(this.getBundleString("fit.width"));
        this.btnFitWidth.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnFitWidthActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText(this.getBundleString("zoom.in"));
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnZoomInActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText(this.getBundleString("zoom.out"));
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.btnZoomOutActionPerformed(actionEvent);
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(this.getBundleString("zoom.ratio"));
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRViewer.this.cmbZoomActionPerformed(actionEvent);
            }
        });
        this.cmbZoom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JRViewer.this.cmbZoomItemStateChanged(itemEvent);
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlMain.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JRViewer.this.pnlMainComponentResized(componentEvent);
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JRViewer.this.pnlLinksMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JRViewer.this.pnlLinksMouseReleased(mouseEvent);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                JRViewer.this.pnlLinksMouseDragged(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        this.add((Component)this.pnlStatus, "South");
    }

    void txtGoToActionPerformed(ActionEvent actionEvent) {
        try {
            int n = Integer.parseInt(this.txtGoTo.getText());
            if (n != this.pageIndex + 1 && n > 0 && n <= this.jasperPrint.getPages().size()) {
                this.setPageIndex(n - 1);
                this.refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cmbZoomItemStateChanged(ItemEvent itemEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    void pnlMainComponentResized(ComponentEvent componentEvent) {
        if (this.btnFitPage.isSelected()) {
            this.fitPage();
            this.btnFitPage.setSelected(true);
        } else if (this.btnFitWidth.isSelected()) {
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnActualSizeActionPerformed(ActionEvent actionEvent) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    void btnFitWidthActionPerformed(ActionEvent actionEvent) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnFitPageActionPerformed(ActionEvent actionEvent) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    void btnSaveActionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        for (n = 0; n < this.saveContributors.size(); ++n) {
            jFileChooser.addChoosableFileFilter((JRSaveContributor)this.saveContributors.get(n));
        }
        if (this.saveContributors.size() > 0) {
            jFileChooser.setFileFilter((JRSaveContributor)this.saveContributors.get(0));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            File file = jFileChooser.getSelectedFile();
            JRSaveContributor jRSaveContributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                jRSaveContributor = (JRSaveContributor)fileFilter;
            } else {
                int n2 = 0;
                while (jRSaveContributor == null && n2 < this.saveContributors.size()) {
                    if ((jRSaveContributor = (JRSaveContributor)this.saveContributors.get(n2++)).accept(file)) continue;
                    jRSaveContributor = null;
                }
                if (jRSaveContributor == null) {
                    jRSaveContributor = new JRPrintSaveContributor();
                }
            }
            try {
                jRSaveContributor.save(this.jasperPrint, file);
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                JOptionPane.showMessageDialog(this, this.getBundleString("error.saving"));
            }
        }
    }

    void pnlLinksMouseDragged(MouseEvent mouseEvent) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Point point = jViewport.getViewPosition();
            int n = point.x - (mouseEvent.getX() - this.downX);
            int n2 = point.y - (mouseEvent.getY() - this.downY);
            int n3 = this.pnlInScroll.getWidth() - jViewport.getWidth();
            int n4 = this.pnlInScroll.getHeight() - jViewport.getHeight();
            if (n < 0) {
                n = 0;
            }
            if (n > n3) {
                n = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            jViewport.setViewPosition(new Point(n, n2));
        }
    }

    void pnlLinksMouseReleased(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    void pnlLinksMousePressed(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = mouseEvent.getX();
        this.downY = mouseEvent.getY();
    }

    void btnPrintActionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JasperPrintManager.printReport(JRViewer.this.jasperPrint, true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(JRViewer.this, JRViewer.this.getBundleString("error.printing"));
                }
            }
        });
        thread.start();
    }

    void btnLastActionPerformed(ActionEvent actionEvent) {
        this.setPageIndex(this.jasperPrint.getPages().size() - 1);
        this.refreshPage();
    }

    void btnNextActionPerformed(ActionEvent actionEvent) {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    void btnPreviousActionPerformed(ActionEvent actionEvent) {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    void btnFirstActionPerformed(ActionEvent actionEvent) {
        this.setPageIndex(0);
        this.refreshPage();
    }

    void btnReloadActionPerformed(ActionEvent actionEvent) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                this.jasperPrint = null;
                this.setPageIndex(0);
                this.refreshPage();
                JOptionPane.showMessageDialog(this, this.getBundleString("error.loading"));
            }
            this.zoom = 0.0f;
            this.realZoom = 0.0f;
            this.setZoomRatio(1.0f);
        }
    }

    void btnZoomInActionPerformed(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n = (int)(100.0f * this.getZoomRatio());
        int n2 = Arrays.binarySearch(this.zooms, n);
        if (n2 < 0) {
            this.setZoomRatio((float)this.zooms[-n2 - 1] / 100.0f);
        } else if (n2 < this.cmbZoom.getModel().getSize() - 1) {
            this.setZoomRatio((float)this.zooms[n2 + 1] / 100.0f);
        }
    }

    void btnZoomOutActionPerformed(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n = (int)(100.0f * this.getZoomRatio());
        int n2 = Arrays.binarySearch(this.zooms, n);
        if (n2 > 0) {
            this.setZoomRatio((float)this.zooms[n2 - 1] / 100.0f);
        } else if (n2 < -1) {
            this.setZoomRatio((float)this.zooms[-n2 - 2] / 100.0f);
        }
    }

    void cmbZoomActionPerformed(ActionEvent actionEvent) {
        float f = this.getZoomRatio();
        if (f < this.MIN_ZOOM) {
            f = this.MIN_ZOOM;
        }
        if (f > this.MAX_ZOOM) {
            f = this.MAX_ZOOM;
        }
        this.setZoomRatio(f);
    }

    void hyperlinkClicked(MouseEvent mouseEvent) {
        JPanel jPanel = (JPanel)mouseEvent.getSource();
        JRPrintHyperlink jRPrintHyperlink = (JRPrintHyperlink)this.linksMap.get(jPanel);
        this.hyperlinkClicked(jRPrintHyperlink);
    }

    protected void hyperlinkClicked(JRPrintHyperlink jRPrintHyperlink) {
        try {
            JRHyperlinkListener jRHyperlinkListener = null;
            for (int i = 0; i < this.hyperlinkListeners.size(); ++i) {
                jRHyperlinkListener = (JRHyperlinkListener)this.hyperlinkListeners.get(i);
                jRHyperlinkListener.gotoHyperlink(jRPrintHyperlink);
            }
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
            JOptionPane.showMessageDialog(this, this.getBundleString("error.hyperlink"));
        }
    }

    private void setPageIndex(int n) {
        this.pageIndex = n;
        if (this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0) {
            this.btnFirst.setEnabled(this.pageIndex > 0);
            this.btnPrevious.setEnabled(this.pageIndex > 0);
            this.btnNext.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
            this.btnLast.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
            this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
            this.txtGoTo.setText("" + (this.pageIndex + 1));
            this.lblStatus.setText(MessageFormat.format(this.getBundleString("page"), new Integer(this.pageIndex + 1), new Integer(this.jasperPrint.getPages().size())));
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
            this.lblStatus.setText("");
        }
    }

    protected void loadReport(String string, boolean bl) throws JRException {
        this.jasperPrint = bl ? JRPrintXmlLoader.load(string) : (JasperPrint)JRLoader.loadObject(string);
        this.type = 1;
        this.isXML = bl;
        this.reportFileName = string;
        this.btnReload.setEnabled(true);
        this.setPageIndex(0);
    }

    protected void loadReport(InputStream inputStream, boolean bl) throws JRException {
        this.jasperPrint = bl ? JRPrintXmlLoader.load(inputStream) : (JasperPrint)JRLoader.loadObject(inputStream);
        this.type = 2;
        this.isXML = bl;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void loadReport(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void refreshPage() {
        long l;
        if (this.jasperPrint == null || this.jasperPrint.getPages() == null || this.jasperPrint.getPages().size() == 0) {
            this.pnlPage.setVisible(false);
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            if (this.jasperPrint != null) {
                JOptionPane.showMessageDialog(this, this.getBundleString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.zoom < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.zoom > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
        Dimension dimension = new Dimension((int)((float)this.jasperPrint.getPageWidth() * this.realZoom) + 8, (int)((float)this.jasperPrint.getPageHeight() * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dimension);
        this.pnlPage.setMinimumSize(dimension);
        this.pnlPage.setPreferredSize(dimension);
        long l2 = JRProperties.getLongProperty(VIEWER_RENDER_BUFFER_MAX_SIZE);
        boolean bl = l2 <= 0L ? false : (l = JRPrinterAWT.getImageSize(this.jasperPrint, this.realZoom)) <= l2;
        this.lblPage.setRenderImage(bl);
        if (bl) {
            Image image = null;
            ImageIcon imageIcon = null;
            try {
                image = JasperPrintManager.printPageToImage(this.jasperPrint, this.pageIndex, this.realZoom);
                imageIcon = new ImageIcon(image);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
            }
            this.lblPage.setIcon(imageIcon);
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap();
        this.createHyperlinks();
        if (!bl) {
            this.lblPage.setIcon(null);
            this.pnlMain.validate();
            this.pnlMain.repaint();
        }
    }

    protected void createHyperlinks() {
        List list = this.jasperPrint.getPages();
        JRPrintPage jRPrintPage = (JRPrintPage)list.get(this.pageIndex);
        List list2 = jRPrintPage.getElements();
        if (list2 != null && list2.size() > 0) {
            for (JRPrintElement jRPrintElement : list2) {
                Object object;
                JPanel jPanel;
                boolean bl;
                JRRenderable jRRenderable;
                JRImageMapRenderer jRImageMapRenderer = null;
                if (jRPrintElement instanceof JRPrintImage && (jRRenderable = ((JRPrintImage)jRPrintElement).getRenderer()) instanceof JRImageMapRenderer) {
                    jRImageMapRenderer = (JRImageMapRenderer)jRRenderable;
                }
                boolean bl2 = jRImageMapRenderer != null;
                JRPrintHyperlink jRPrintHyperlink = null;
                if (!bl2 && jRPrintElement instanceof JRPrintHyperlink) {
                    jRPrintHyperlink = (JRPrintHyperlink)((Object)jRPrintElement);
                }
                boolean bl3 = bl = jRPrintHyperlink != null && jRPrintHyperlink.getHyperlinkType() != 1;
                if (!bl && !bl2) continue;
                if (bl) {
                    jPanel = new JPanel();
                    jPanel.addMouseListener(this.mouseListener);
                } else {
                    object = new Rectangle(0, 0, jRPrintElement.getWidth(), jRPrintElement.getHeight());
                    jPanel = new ImageMapPanel((Rectangle)object, jRImageMapRenderer);
                }
                if (bl) {
                    jPanel.setCursor(new Cursor(12));
                }
                jPanel.setLocation((int)((float)jRPrintElement.getX() * this.realZoom), (int)((float)jRPrintElement.getY() * this.realZoom));
                jPanel.setSize((int)((float)jRPrintElement.getWidth() * this.realZoom), (int)((float)jRPrintElement.getHeight() * this.realZoom));
                jPanel.setOpaque(false);
                object = bl ? this.getHyperlinkTooltip(jRPrintHyperlink) : "";
                jPanel.setToolTipText((String)object);
                this.pnlLinks.add(jPanel);
                this.linksMap.put(jPanel, jRPrintElement);
            }
        }
    }

    protected String getHyperlinkTooltip(JRPrintHyperlink jRPrintHyperlink) {
        String string = jRPrintHyperlink.getHyperlinkTooltip();
        if (string == null) {
            string = this.getFallbackTooltip(jRPrintHyperlink);
        }
        return string;
    }

    protected String getFallbackTooltip(JRPrintHyperlink jRPrintHyperlink) {
        String string = null;
        switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                string = jRPrintHyperlink.getHyperlinkReference();
                break;
            }
            case 3: {
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = "#page " + jRPrintHyperlink.getHyperlinkPage();
                break;
            }
            case 5: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = string + "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case 6: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = string + "#page " + jRPrintHyperlink.getHyperlinkPage();
                break;
            }
        }
        return string;
    }

    private void emptyContainer(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Container)) continue;
                this.emptyContainer((Container)componentArray[i]);
            }
        }
        componentArray = null;
        container.removeAll();
        container = null;
    }

    private float getZoomRatio() {
        float f = this.zoom;
        try {
            f = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return f;
    }

    public void setZoomRatio(float f) {
        if (f > 0.0f) {
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(f * 100.0f) + "%");
            if (this.zoom != f) {
                this.zoom = f;
                this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
                this.refreshPage();
            }
        }
    }

    private void setRealZoomRatio(float f) {
        if (f > 0.0f && this.realZoom != f) {
            this.zoom = f * 72.0f / (float)this.screenResolution;
            this.realZoom = f;
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refreshPage();
        }
    }

    public void setFitWidthZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
    }

    public void setFitPageZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight());
    }

    protected void paintPage(Graphics2D graphics2D) {
        try {
            if (this.exporter == null) {
                this.exporter = new JRGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
            this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics2D);
            this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(this.pageIndex));
            this.exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(this.realZoom));
            this.exporter.setParameter(JRExporterParameter.OFFSET_X, new Integer(1));
            this.exporter.setParameter(JRExporterParameter.OFFSET_Y, new Integer(1));
            this.exporter.exportReport();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, this.getBundleString("error.displaying"));
        }
    }

    private void fitPage() {
        float f;
        float f2 = ((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight();
        this.setRealZoomRatio(f2 < (f = ((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth()) ? f2 : f);
    }

    class PageRenderer
    extends JLabel {
        private boolean renderImage;
        JRViewer viewer = null;

        public PageRenderer(JRViewer jRViewer2) {
            this.viewer = jRViewer2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.isRenderImage()) {
                super.paintComponent(graphics);
            } else {
                this.viewer.paintPage((Graphics2D)graphics.create());
            }
        }

        public boolean isRenderImage() {
            return this.renderImage;
        }

        public void setRenderImage(boolean bl) {
            this.renderImage = bl;
        }
    }

    protected class ImageMapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        protected final List imageAreaHyperlinks;

        public ImageMapPanel(Rectangle rectangle, JRImageMapRenderer jRImageMapRenderer) {
            try {
                this.imageAreaHyperlinks = jRImageMapRenderer.getImageAreaHyperlinks(rectangle);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException(jRException);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null) {
                string = JRViewer.this.getHyperlinkTooltip(jRPrintImageAreaHyperlink.getHyperlink());
            }
            if (string == null) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null && jRPrintImageAreaHyperlink.getHyperlink().getHyperlinkType() != 1) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(MouseEvent mouseEvent) {
            return this.getImageMapArea((int)((float)mouseEvent.getX() / JRViewer.this.realZoom), (int)((float)mouseEvent.getY() / JRViewer.this.realZoom));
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(int n, int n2) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = null;
            Iterator iterator = this.imageAreaHyperlinks.iterator();
            while (jRPrintImageAreaHyperlink == null && iterator.hasNext()) {
                JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink2 = (JRPrintImageAreaHyperlink)iterator.next();
                if (!jRPrintImageAreaHyperlink2.getArea().containsPoint(n, n2)) continue;
                jRPrintImageAreaHyperlink = jRPrintImageAreaHyperlink2;
            }
            return jRPrintImageAreaHyperlink;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null) {
                JRViewer.this.hyperlinkClicked(jRPrintImageAreaHyperlink.getHyperlink());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

