/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class JasperDesign
extends JRBaseReport {
    private static final long serialVersionUID = 10200L;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private JRDesignDataset mainDesignDataset;
    private Map datasetMap = new HashMap();
    private List datasetList = new ArrayList();
    private transient List crosstabs;

    public JasperDesign() {
        this.setMainDataset(new JRDesignDataset(true));
    }

    public void setName(String string) {
        this.name = string;
        this.mainDesignDataset.setName(string);
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
    }

    public void setPrintOrder(byte by) {
        this.printOrder = by;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
    }

    public void setOrientation(byte by) {
        this.orientation = by;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public void setColumnSpacing(int n) {
        this.columnSpacing = n;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    public void setBottomMargin(int n) {
        this.bottomMargin = n;
    }

    public void setBackground(JRBand jRBand) {
        this.background = jRBand;
    }

    public void setTitle(JRBand jRBand) {
        this.title = jRBand;
    }

    public void setTitleNewPage(boolean bl) {
        this.isTitleNewPage = bl;
    }

    public void setSummary(JRBand jRBand) {
        this.summary = jRBand;
    }

    public void setSummaryNewPage(boolean bl) {
        this.isSummaryNewPage = bl;
    }

    public void setFloatColumnFooter(boolean bl) {
        this.isFloatColumnFooter = bl;
    }

    public void setPageHeader(JRBand jRBand) {
        this.pageHeader = jRBand;
    }

    public void setPageFooter(JRBand jRBand) {
        this.pageFooter = jRBand;
    }

    public void setLastPageFooter(JRBand jRBand) {
        this.lastPageFooter = jRBand;
    }

    public void setColumnHeader(JRBand jRBand) {
        this.columnHeader = jRBand;
    }

    public void setColumnFooter(JRBand jRBand) {
        this.columnFooter = jRBand;
    }

    public void setDetail(JRBand jRBand) {
        this.detail = jRBand;
    }

    public void setScriptletClass(String string) {
        this.mainDesignDataset.setScriptletClass(string);
    }

    public void setFormatFactoryClass(String string) {
        this.formatFactoryClass = string;
    }

    public void setResourceBundle(String string) {
        this.mainDesignDataset.setResourceBundle(string);
    }

    public void addImport(String string) {
        if (this.importsSet == null) {
            this.importsSet = new HashSet();
        }
        this.importsSet.add(string);
    }

    public void removeImport(String string) {
        if (this.importsSet != null) {
            this.importsSet.remove(string);
        }
    }

    public void setDefaultFont(JRReportFont jRReportFont) {
        this.defaultFont = jRReportFont;
    }

    @Override
    public JRReportFont[] getFonts() {
        JRReportFont[] jRReportFontArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(jRReportFontArray);
        return jRReportFontArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public void addFont(JRReportFont jRReportFont) throws JRException {
        if (this.fontsMap.containsKey(jRReportFont.getName())) {
            throw new JRException("Duplicate declaration of report font : " + jRReportFont.getName());
        }
        this.fontsList.add(jRReportFont);
        this.fontsMap.put(jRReportFont.getName(), jRReportFont);
        if (jRReportFont.isDefault()) {
            this.setDefaultFont(jRReportFont);
        }
    }

    public JRReportFont removeFont(String string) {
        return this.removeFont((JRReportFont)this.fontsMap.get(string));
    }

    public JRReportFont removeFont(JRReportFont jRReportFont) {
        if (jRReportFont != null) {
            if (jRReportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(jRReportFont);
            this.fontsMap.remove(jRReportFont.getName());
        }
        return jRReportFont;
    }

    public void setDefaultStyle(JRStyle jRStyle) {
        this.defaultStyle = jRStyle;
    }

    @Override
    public JRStyle[] getStyles() {
        JRStyle[] jRStyleArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(jRStyleArray);
        return jRStyleArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public void addStyle(JRStyle jRStyle) throws JRException {
        if (this.stylesMap.containsKey(jRStyle.getName())) {
            throw new JRException("Duplicate declaration of report style : " + jRStyle.getName());
        }
        this.stylesList.add(jRStyle);
        this.stylesMap.put(jRStyle.getName(), jRStyle);
        if (jRStyle.isDefault()) {
            this.setDefaultStyle(jRStyle);
        }
    }

    public JRStyle removeStyle(String string) {
        return this.removeStyle((JRStyle)this.stylesMap.get(string));
    }

    public JRStyle removeStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            if (jRStyle.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(jRStyle);
            this.stylesMap.remove(jRStyle.getName());
        }
        return jRStyle;
    }

    public List getParametersList() {
        return this.mainDesignDataset.getParametersList();
    }

    public Map getParametersMap() {
        return this.mainDesignDataset.getParametersMap();
    }

    public void addParameter(JRParameter jRParameter) throws JRException {
        this.mainDesignDataset.addParameter(jRParameter);
    }

    public JRParameter removeParameter(String string) {
        return this.mainDesignDataset.removeParameter(string);
    }

    public JRParameter removeParameter(JRParameter jRParameter) {
        return this.mainDesignDataset.removeParameter(jRParameter);
    }

    public void setQuery(JRDesignQuery jRDesignQuery) {
        this.mainDesignDataset.setQuery(jRDesignQuery);
    }

    public List getFieldsList() {
        return this.mainDesignDataset.getFieldsList();
    }

    public Map getFieldsMap() {
        return this.mainDesignDataset.getFieldsMap();
    }

    public void addField(JRField jRField) throws JRException {
        this.mainDesignDataset.addField(jRField);
    }

    public JRField removeField(String string) {
        return this.mainDesignDataset.removeField(string);
    }

    public JRField removeField(JRField jRField) {
        return this.mainDesignDataset.removeField(jRField);
    }

    public List getSortFieldsList() {
        return this.mainDesignDataset.getSortFieldsList();
    }

    public void addSortField(JRSortField jRSortField) throws JRException {
        this.mainDesignDataset.addSortField(jRSortField);
    }

    public JRSortField removeSortField(String string) {
        return this.mainDesignDataset.removeSortField(string);
    }

    public JRSortField removeSortField(JRSortField jRSortField) {
        return this.mainDesignDataset.removeSortField(jRSortField);
    }

    public List getVariablesList() {
        return this.mainDesignDataset.getVariablesList();
    }

    public Map getVariablesMap() {
        return this.mainDesignDataset.getVariablesMap();
    }

    public void addVariable(JRDesignVariable jRDesignVariable) throws JRException {
        this.mainDesignDataset.addVariable(jRDesignVariable);
    }

    public JRVariable removeVariable(String string) {
        return this.mainDesignDataset.removeVariable(string);
    }

    public JRVariable removeVariable(JRVariable jRVariable) {
        return this.mainDesignDataset.removeVariable(jRVariable);
    }

    public List getGroupsList() {
        return this.mainDesignDataset.getGroupsList();
    }

    public Map getGroupsMap() {
        return this.mainDesignDataset.getGroupsMap();
    }

    public void addGroup(JRDesignGroup jRDesignGroup) throws JRException {
        this.mainDesignDataset.addGroup(jRDesignGroup);
    }

    public JRGroup removeGroup(String string) {
        return this.mainDesignDataset.removeGroup(string);
    }

    public JRGroup removeGroup(JRGroup jRGroup) {
        return this.mainDesignDataset.removeGroup(jRGroup);
    }

    public Collection getExpressions() {
        return JRExpressionCollector.collectExpressions(this);
    }

    @Override
    public JRDataset[] getDatasets() {
        JRDataset[] jRDatasetArray = new JRDataset[this.datasetList.size()];
        this.datasetList.toArray(jRDatasetArray);
        return jRDatasetArray;
    }

    public List getDatasetsList() {
        return this.datasetList;
    }

    public Map getDatasetMap() {
        return this.datasetMap;
    }

    public void addDataset(JRDesignDataset jRDesignDataset) throws JRException {
        if (this.datasetMap.containsKey(jRDesignDataset.getName())) {
            throw new JRException("Duplicate declaration of dataset : " + jRDesignDataset.getName());
        }
        this.datasetList.add(jRDesignDataset);
        this.datasetMap.put(jRDesignDataset.getName(), jRDesignDataset);
    }

    public JRDataset removeDataset(String string) {
        return this.removeDataset((JRDataset)this.datasetMap.get(string));
    }

    public JRDataset removeDataset(JRDataset jRDataset) {
        if (jRDataset != null) {
            this.datasetList.remove(jRDataset);
            this.datasetMap.remove(jRDataset.getName());
        }
        return jRDataset;
    }

    public JRDesignDataset getMainDesignDataset() {
        return this.mainDesignDataset;
    }

    public void setMainDataset(JRDesignDataset jRDesignDataset) {
        this.mainDesignDataset = jRDesignDataset;
        this.mainDataset = this.mainDesignDataset;
        this.mainDesignDataset.setName(this.getName());
    }

    public void preprocess() {
        this.collectCrosstabs();
        for (JRDesignCrosstab jRDesignCrosstab : this.crosstabs) {
            jRDesignCrosstab.preprocess();
        }
    }

    protected List getCrosstabs() {
        if (this.crosstabs == null) {
            this.collectCrosstabs();
        }
        return this.crosstabs;
    }

    protected List collectCrosstabs() {
        this.crosstabs = new ArrayList();
        this.collectCrosstabs(this.background);
        this.collectCrosstabs(this.title);
        this.collectCrosstabs(this.pageHeader);
        this.collectCrosstabs(this.columnHeader);
        this.collectCrosstabs(this.detail);
        this.collectCrosstabs(this.columnFooter);
        this.collectCrosstabs(this.pageFooter);
        this.collectCrosstabs(this.lastPageFooter);
        this.collectCrosstabs(this.summary);
        JRGroup[] jRGroupArray = this.getGroups();
        if (jRGroupArray != null) {
            for (int i = 0; i < jRGroupArray.length; ++i) {
                this.collectCrosstabs(jRGroupArray[i].getGroupHeader());
                this.collectCrosstabs(jRGroupArray[i].getGroupFooter());
            }
        }
        return this.crosstabs;
    }

    protected void collectCrosstabs(JRBand jRBand) {
        if (jRBand != null) {
            this.collectCrosstabs(jRBand.getElements());
        }
    }

    protected void collectCrosstabs(JRElement[] jRElementArray) {
        if (jRElementArray != null) {
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRElement jRElement = jRElementArray[i];
                if (jRElement instanceof JRCrosstab) {
                    this.crosstabs.add(jRElement);
                    continue;
                }
                if (!(jRElement instanceof JRFrame)) continue;
                JRFrame jRFrame = (JRFrame)jRElement;
                this.collectCrosstabs(jRFrame.getElements());
            }
        }
    }

    public void setIgnorePagination(boolean bl) {
        this.ignorePagination = bl;
    }

    public JRExpression getFilterExpression() {
        return this.mainDesignDataset.getFilterExpression();
    }

    public void setFilterExpression(JRExpression jRExpression) {
        this.mainDesignDataset.setFilterExpression(jRExpression);
    }
}

