/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRStringUtil;

public abstract class JRAbstractCompiler
implements JRCompiler {
    private static final int NAME_SUFFIX_RANDOM_MAX = 1000000;
    private static final Random random = new Random();
    private final boolean needsSourceFiles;

    protected JRAbstractCompiler(boolean bl) {
        this.needsSourceFiles = bl;
    }

    public static String getUnitName(JasperReport jasperReport, JRDataset jRDataset) {
        return JRAbstractCompiler.getUnitName((JRReport)jasperReport, jRDataset, jasperReport.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport jRReport, JRDataset jRDataset, String string) {
        String string2 = jRDataset.isMainDataset() ? jRReport.getName() : jRReport.getName() + "_" + jRDataset.getName();
        string2 = JRStringUtil.getLiteral(string2) + string;
        return string2;
    }

    public static String getUnitName(JasperReport jasperReport, JRCrosstab jRCrosstab) {
        return JRAbstractCompiler.getUnitName((JRReport)jasperReport, jRCrosstab.getId(), jasperReport.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport jRReport, JRCrosstab jRCrosstab, JRExpressionCollector jRExpressionCollector, String string) {
        Integer n = jRExpressionCollector.getCrosstabId(jRCrosstab);
        if (n == null) {
            throw new JRRuntimeException("Crosstab ID not found.");
        }
        return JRAbstractCompiler.getUnitName(jRReport, n, string);
    }

    protected static String getUnitName(JRReport jRReport, int n, String string) {
        return JRStringUtil.getLiteral(jRReport.getName()) + "_CROSSTAB" + n + string;
    }

    @Override
    public final JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        Object object4;
        Object object2;
        this.checkLanguage(jasperDesign.getLanguage());
        JRExpressionCollector jRExpressionCollector = JRExpressionCollector.collector(jasperDesign);
        this.verifyDesign(jasperDesign, jRExpressionCollector);
        String string = JRAbstractCompiler.createNameSuffix();
        boolean bl = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        File file = null;
        if (!(!bl && !this.needsSourceFiles || (file = new File((String)(object2 = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir")))).exists() && file.isDirectory())) {
            throw new JRException("Temporary directory not found : " + (String)object2);
        }
        object2 = jasperDesign.getDatasetsList();
        List list = jasperDesign.getCrosstabs();
        JRCompilationUnit[] jRCompilationUnitArray = new JRCompilationUnit[object2.size() + list.size() + 1];
        jRCompilationUnitArray[0] = this.createCompileUnit(jasperDesign, jasperDesign.getMainDesignDataset(), jRExpressionCollector, file, string);
        int n = 1;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object4 = (JRDesignDataset)object3.next();
            jRCompilationUnitArray[n] = this.createCompileUnit(jasperDesign, (JRDesignDataset)object4, jRExpressionCollector, file, string);
            ++n;
        }
        for (Object object4 : list) {
            jRCompilationUnitArray[n] = this.createCompileUnit(jasperDesign, (JRDesignCrosstab)object4, jRExpressionCollector, file, string);
            ++n;
        }
        object3 = JRProperties.getProperty("net.sf.jasperreports.compiler.classpath");
        try {
            Object object5;
            object4 = this.compileUnits(jRCompilationUnitArray, (String)object3, file);
            if (object4 != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + (String)object4);
            }
            JRReportCompileData jRReportCompileData = new JRReportCompileData();
            jRReportCompileData.setMainDatasetCompileData(jRCompilationUnitArray[0].getCompileData());
            Object object6 = object2.listIterator();
            while (object6.hasNext()) {
                object5 = (JRDesignDataset)object6.next();
                jRReportCompileData.setDatasetCompileData((JRDataset)object5, jRCompilationUnitArray[object6.nextIndex()].getCompileData());
            }
            object6 = list.listIterator();
            while (object6.hasNext()) {
                object5 = (JRDesignCrosstab)object6.next();
                Integer n2 = jRExpressionCollector.getCrosstabId((JRCrosstab)object5);
                jRReportCompileData.setCrosstabCompileData(n2, jRCompilationUnitArray[object2.size() + object6.nextIndex()].getCompileData());
            }
            object5 = object6 = new JasperReport(jasperDesign, this.getCompilerClass(), jRReportCompileData, jRExpressionCollector, string);
            return object5;
        }
        catch (JRException jRException) {
            throw jRException;
        }
        catch (Exception exception) {
            throw new JRException("Error compiling report design.", exception);
        }
        finally {
            if (this.needsSourceFiles && !bl) {
                this.deleteSourceFiles(jRCompilationUnitArray);
            }
        }
    }

    private static String createNameSuffix() {
        return "_" + System.currentTimeMillis() + "_" + random.nextInt(1000000);
    }

    protected String getCompilerClass() {
        return this.getClass().getName();
    }

    private void verifyDesign(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) throws JRException {
        Collection collection = JRVerifier.verifyDesign(jasperDesign, jRExpressionCollector);
        if (collection != null && collection.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Report design not valid : ");
            int n = 1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t " + n + ". " + (String)iterator.next());
                ++n;
            }
            throw new JRException(stringBuffer.toString());
        }
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignDataset jRDesignDataset, JRExpressionCollector jRExpressionCollector, File file, String string) throws JRException {
        String string2 = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, jRDesignDataset, string);
        JRSourceCompileTask jRSourceCompileTask = new JRSourceCompileTask(jasperDesign, jRDesignDataset, jRExpressionCollector, string2);
        String string3 = this.generateSourceCode(jRSourceCompileTask);
        File file2 = this.getSourceFile(file, string2, string3);
        return new JRCompilationUnit(string2, string3, file2, jRExpressionCollector.getExpressions(jRDesignDataset));
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignCrosstab jRDesignCrosstab, JRExpressionCollector jRExpressionCollector, File file, String string) throws JRException {
        String string2 = JRAbstractCompiler.getUnitName(jasperDesign, jRDesignCrosstab, jRExpressionCollector, string);
        JRSourceCompileTask jRSourceCompileTask = new JRSourceCompileTask(jasperDesign, jRDesignCrosstab, jRExpressionCollector, string2);
        String string3 = this.generateSourceCode(jRSourceCompileTask);
        File file2 = this.getSourceFile(file, string2, string3);
        return new JRCompilationUnit(string2, string3, file2, jRExpressionCollector.getExpressions(jRDesignCrosstab));
    }

    private File getSourceFile(File file, String string, String string2) throws JRException {
        File file2 = null;
        if (file != null) {
            String string3 = this.getSourceFileName(string);
            file2 = new File(file, string3);
            JRSaver.saveClassSource(string2, file2);
        }
        return file2;
    }

    private void deleteSourceFiles(JRCompilationUnit[] jRCompilationUnitArray) {
        for (int i = 0; i < jRCompilationUnitArray.length; ++i) {
            jRCompilationUnitArray[i].getSourceFile().delete();
        }
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        String string = JRAbstractCompiler.getUnitName(jasperReport, jRDataset);
        JRReportCompileData jRReportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable serializable = jRReportCompileData.getDatasetCompileData(jRDataset);
        return this.loadEvaluator(serializable, string);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab jRCrosstab) throws JRException {
        String string = JRAbstractCompiler.getUnitName(jasperReport, jRCrosstab);
        JRReportCompileData jRReportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable serializable = jRReportCompileData.getCrosstabCompileData(jRCrosstab);
        return this.loadEvaluator(serializable, string);
    }

    protected abstract JREvaluator loadEvaluator(Serializable var1, String var2) throws JRException;

    protected abstract void checkLanguage(String var1) throws JRException;

    protected abstract String generateSourceCode(JRSourceCompileTask var1) throws JRException;

    protected abstract String compileUnits(JRCompilationUnit[] var1, String var2, File var3) throws JRException;

    protected abstract String getSourceFileName(String var1);
}

