/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;

public final class Utilities {
    private static Boolean cachedIsLafAqua;
    private static boolean lafChangeHandlerRegistered;

    private Utilities() {
    }

    public static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = Utilities.computeIsLafAqua();
            Utilities.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!lafChangeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
            lafChangeHandlerRegistered = true;
        }
    }

    private static boolean computeIsLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    static {
        lafChangeHandlerRegistered = false;
    }

    private static final class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("lookAndFeel")) {
                cachedIsLafAqua = null;
            }
        }
    }
}

