/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class FormSpec
implements Serializable {
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double d) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = d;
        if (d < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    protected FormSpec(DefaultAlignment defaultAlignment, String string) {
        this(defaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(string.toLowerCase(Locale.ENGLISH));
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    private void parseAndInitValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String string2 = stringTokenizer.nextToken();
        DefaultAlignment defaultAlignment = DefaultAlignment.valueOf(string2, this.isHorizontal());
        if (defaultAlignment != null) {
            this.defaultAlignment = defaultAlignment;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            string2 = stringTokenizer.nextToken();
        }
        this.parseAndInitSize(string2);
        if (stringTokenizer.hasMoreTokens()) {
            this.resizeWeight = this.decodeResize(stringTokenizer.nextToken());
        }
    }

    private void parseAndInitSize(String string) {
        if (string.startsWith("max(") && string.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(string, false);
            return;
        }
        if (string.startsWith("min(") && string.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(string, true);
            return;
        }
        this.size = this.decodeAtomicSize(string);
    }

    private Size parseAndInitBoundedSize(String string, boolean bl) {
        int n = string.indexOf(59);
        String string2 = string.substring(4, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        Size size = this.decodeAtomicSize(string2);
        Size size2 = this.decodeAtomicSize(string3);
        if (size instanceof ConstantSize) {
            if (size2 instanceof Sizes.ComponentSize) {
                return new BoundedSize(size2, bl ? null : size, bl ? size : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size, bl ? null : size2, bl ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size decodeAtomicSize(String string) {
        Sizes.ComponentSize componentSize = Sizes.ComponentSize.valueOf(string);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.valueOf(string, this.isHorizontal());
    }

    private double decodeResize(String string) {
        if (string.equals("g") || string.equals("grow")) {
            return 1.0;
        }
        if (string.equals("n") || string.equals("nogrow") || string.equals("none")) {
            return 0.0;
        }
        if ((string.startsWith("grow(") || string.startsWith("g(")) && string.endsWith(")")) {
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            String string2 = string.substring(n + 1, n2);
            return Double.parseDouble(string2);
        }
        throw new IllegalArgumentException("The resize argument '" + string + "' is invalid.  Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment);
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("grow");
        } else {
            stringBuffer.append("grow(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public final String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment.abbreviation());
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("g");
        } else {
            stringBuffer.append("g(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    abstract boolean isHorizontal();

    final int maximumSize(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
        return this.size.maximumSize(container, list, measure, measure2, measure3);
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String string) {
            this.name = string;
        }

        private static DefaultAlignment valueOf(String string, boolean bl) {
            if (string.equals("f") || string.equals("fill")) {
                return FILL_ALIGN;
            }
            if (string.equals("c") || string.equals("center")) {
                return CENTER_ALIGN;
            }
            if (bl) {
                if (string.equals("r") || string.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (string.equals("l") || string.equals("left")) {
                    return LEFT_ALIGN;
                }
                return null;
            }
            if (string.equals("t") || string.equals("top")) {
                return TOP_ALIGN;
            }
            if (string.equals("b") || string.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

