/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;
    private boolean didResolve = false;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.type;
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int n) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n = 0;
        int n2 = this.typeArguments.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
            ++n;
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * 2;
                cArray2[n5] = 91;
                cArray2[n5 + 1] = 93;
                ++n4;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        Object object;
        this.constant = Constant.NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        if (referenceBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            referenceBinding = this.resolvedType.enclosingType();
            if (referenceBinding != null && (referenceBinding.isGenericType() || referenceBinding.isParameterizedType())) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)this.resolvedType;
                referenceBinding = referenceBinding2.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding) : scope.environment().convertToParameterizedType(referenceBinding);
            }
        } else {
            this.resolvedType = scope.getMemberType(this.token, (ReferenceBinding)referenceBinding.erasure());
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, this.resolvedType, referenceBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().deprecatedType(this.resolvedType, this);
            }
        }
        boolean bl2 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl2) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.resolvedType;
        int n = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding typeBinding;
            object = this.typeArguments[n2];
            TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object).resolveTypeArgument((ClassScope)scope, referenceBinding3, n2) : ((TypeReference)object).resolveTypeArgument((BlockScope)scope, referenceBinding3, n2);
            if (typeBinding == null) {
                bl3 = true;
            } else {
                typeBindingArray[n2] = typeBinding;
            }
            ++n2;
        }
        if (bl3) {
            return null;
        }
        if (bl2) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding3, this, typeBindingArray)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding3.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
            scope.problemReporter().nonGenericTypeCannotBeParameterized(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (n != typeVariableBindingArray.length) {
            scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (!referenceBinding3.isStatic() && referenceBinding != null && referenceBinding.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)referenceBinding3.erasure(), referenceBinding), typeBindingArray);
            return null;
        }
        object = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding3.erasure(), typeBindingArray, referenceBinding);
        if (bl) {
            ((ParameterizedTypeBinding)object).boundCheck(scope, this.typeArguments);
        }
        this.resolvedType = object;
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n2 = this.typeArguments.length - 1;
        int n3 = 0;
        while (n3 < n2) {
            this.typeArguments[n3].print(0, stringBuffer);
            stringBuffer.append(", ");
            ++n3;
        }
        this.typeArguments[n2].print(0, stringBuffer);
        stringBuffer.append(">");
        if ((this.bits & 0x4000) != 0) {
            n3 = 0;
            while (n3 < this.dimensions - 1) {
                stringBuffer.append("[]");
                ++n3;
            }
            stringBuffer.append("...");
        } else {
            n3 = 0;
            while (n3 < this.dimensions) {
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, null, bl);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = 0;
            int n2 = this.typeArguments.length;
            while (n < n2) {
                this.typeArguments[n].traverse(aSTVisitor, blockScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = 0;
            int n2 = this.typeArguments.length;
            while (n < n2) {
                this.typeArguments[n].traverse(aSTVisitor, classScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

