/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String key = null;
    protected byte positionType;
    protected byte stretchType;
    protected boolean isPrintRepeatedValues = true;
    protected Byte mode;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean isRemoveLineWhenBlank = false;
    protected boolean isPrintInFirstWholeBand = false;
    protected boolean isPrintWhenDetailOverflows = false;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRExpression printWhenExpression = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRElementGroup elementGroup = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;

    protected JRBaseElement(JRDefaultStyleProvider jRDefaultStyleProvider) {
        this.defaultStyleProvider = jRDefaultStyleProvider;
    }

    protected JRBaseElement(JRElement jRElement, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRElement, this);
        this.defaultStyleProvider = jRBaseObjectFactory.getDefaultStyleProvider();
        this.parentStyle = jRBaseObjectFactory.getStyle(jRElement.getStyle());
        this.key = jRElement.getKey();
        this.positionType = jRElement.getPositionType();
        this.stretchType = jRElement.getStretchType();
        this.isPrintRepeatedValues = jRElement.isPrintRepeatedValues();
        this.mode = jRElement.getOwnMode();
        this.x = jRElement.getX();
        this.y = jRElement.getY();
        this.width = jRElement.getWidth();
        this.height = jRElement.getHeight();
        this.isRemoveLineWhenBlank = jRElement.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = jRElement.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = jRElement.isPrintWhenDetailOverflows();
        this.forecolor = jRElement.getOwnForecolor();
        this.backcolor = jRElement.getOwnBackcolor();
        this.printWhenExpression = jRBaseObjectFactory.getExpression(jRElement.getPrintWhenExpression());
        this.printWhenGroupChanges = jRBaseObjectFactory.getGroup(jRElement.getPrintWhenGroupChanges());
        this.elementGroup = jRBaseObjectFactory.getElementGroup(jRElement.getElementGroup());
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public byte getPositionType() {
        return this.positionType;
    }

    public void setPositionType(byte by) {
        this.positionType = by;
    }

    public byte getStretchType() {
        return this.stretchType;
    }

    public void setStretchType(byte by) {
        this.stretchType = by;
    }

    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    public void setPrintRepeatedValues(boolean bl) {
        this.isPrintRepeatedValues = bl;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = new Byte(by);
    }

    public void setMode(Byte by) {
        this.mode = by;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    public void setRemoveLineWhenBlank(boolean bl) {
        this.isRemoveLineWhenBlank = bl;
    }

    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    public void setPrintInFirstWholeBand(boolean bl) {
        this.isPrintInFirstWholeBand = bl;
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    public void setPrintWhenDetailOverflows(boolean bl) {
        this.isPrintWhenDetailOverflows = bl;
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    public void setForecolor(Color color) {
        this.forecolor = color;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color color) {
        this.backcolor = color;
    }

    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRStyle getStyle() {
        return this.parentStyle;
    }
}

