/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Hashtable;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJTitular
extends Observador {
    private ColecaoRendPJTitular colecaoRendPJ = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendPJTitular(ColecaoRendPJTitular colecaoRendPJTitular, DeclaracaoIRPF declaracaoIRPF) {
        this.colecaoRendPJ = colecaoRendPJTitular;
        this.declaracaoIRPF = declaracaoIRPF;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                RendPJTitular rendPJTitular = (RendPJTitular)object3;
                rendPJTitular.addObservador(this);
                this.calculaTotaisRendRecebidoPJ();
                this.calculaTotaisContribPrev();
                this.calculaTotaisDecimoTerceiro();
                this.calculaTotaisImpostoRetido();
            } else if (string.equals("ObjetoRemovido")) {
                RendPJTitular rendPJTitular = (RendPJTitular)object3;
                rendPJTitular.removeObservador(this);
                this.calculaTotaisRendRecebidoPJ();
                this.calculaTotaisContribPrev();
                this.calculaTotaisDecimoTerceiro();
                this.calculaTotaisImpostoRetido();
            } else if (string.equals("Contr. Prev. Oficial")) {
                this.calculaTotaisContribPrev();
            } else if (string.equals("13\u00ba Sal\u00e1rio")) {
                this.calculaTotaisDecimoTerceiro();
            } else if (string.equals("IR Retido na Fonte")) {
                this.calculaTotaisImpostoRetido();
            } else if (string.equals("Rend. Recebid") || string.equals("NI da Fonte Pagadora")) {
                this.calculaTotaisRendRecebidoPJ();
            }
        }
    }

    private void calculaTotaisImpostoRetido() {
        Valor valor = new Valor();
        for (RendPJTitular rendPJTitular : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJTitular.getImpostoRetidoFonte());
        }
        this.colecaoRendPJ.getTotaisImpostoRetidoFonte().setConteudo(valor);
    }

    private void calculaTotaisDecimoTerceiro() {
        Valor valor = new Valor();
        for (RendPJTitular rendPJTitular : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJTitular.getDecimoTerceiro());
        }
        this.declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiro().setConteudo(valor);
        this.colecaoRendPJ.getTotaisDecimoTerceiro().setConteudo(valor);
    }

    private void calculaTotaisContribPrev() {
        Valor valor = new Valor();
        for (RendPJTitular rendPJTitular : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJTitular.getContribuicaoPrevOficial());
        }
        this.colecaoRendPJ.getTotaisContribuicaoPrevOficial().setConteudo(valor);
    }

    private void calculaTotaisRendRecebidoPJ() {
        RendPJTitular rendPJTitular = null;
        Hashtable<String, Valor> hashtable = new Hashtable<String, Valor>();
        this.colecaoRendPJ.getNiMaiorFontePagadora().clear();
        Valor valor = new Valor();
        Iterator iterator = this.colecaoRendPJ.recuperarLista().iterator();
        this.colecaoRendPJ.getNiMaiorFontePagadora().clear();
        this.colecaoRendPJ.getTotaisRendRecebidoPJ().clear();
        while (iterator.hasNext()) {
            Valor valor2;
            RendPJTitular rendPJTitular2 = (RendPJTitular)iterator.next();
            valor.append('+', rendPJTitular2.getRendRecebidoPJ());
            if (!hashtable.containsKey(rendPJTitular2.getNIFontePagadora().asString())) {
                valor2 = new Valor();
                valor2.setConteudo(rendPJTitular2.getRendRecebidoPJ().getConteudoFormatado());
                hashtable.put(rendPJTitular2.getNIFontePagadora().asString(), valor2);
            } else {
                valor2 = (Valor)hashtable.get(rendPJTitular2.getNIFontePagadora().asString());
                valor2.append('+', valor2.getConteudoFormatado());
            }
            if (rendPJTitular == null) {
                rendPJTitular = rendPJTitular2;
            } else {
                Valor valor3;
                valor2 = (Valor)hashtable.get(rendPJTitular2.getNIFontePagadora().asString());
                if (valor2.comparacao(">", (valor3 = (Valor)hashtable.get(rendPJTitular.getNIFontePagadora().asString())).getConteudoFormatado())) {
                    rendPJTitular = rendPJTitular2;
                }
            }
            this.colecaoRendPJ.getNiMaiorFontePagadora().setConteudo(rendPJTitular.getNIFontePagadora().getConteudoFormatado());
            this.colecaoRendPJ.getTotaisRendRecebidoPJ().setConteudo(valor);
        }
    }
}

