/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jdesktop.layout.LayoutStyle;

class WindowsLayoutStyle
extends LayoutStyle {
    private int baseUnitX;
    private int baseUnitY;

    WindowsLayoutStyle() {
    }

    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, int n, int n2, Container container) {
        boolean bl;
        super.getPreferredGap(jComponent, jComponent2, n, n2, container);
        if (n == 3) {
            if (n2 == 3 || n2 == 7) {
                int n3 = this.getButtonChildIndent(jComponent, n2);
                if (n3 != 0) {
                    return n3;
                }
                return 10;
            }
            n = 0;
        }
        if (n == 1) {
            return this.getCBRBPadding(jComponent, jComponent2, n2, this.dluToPixels(7, n2));
        }
        boolean bl2 = jComponent.getUIClassID() == "LabelUI";
        boolean bl3 = bl = jComponent2.getUIClassID() == "LabelUI";
        if ((bl2 && !bl || bl && !bl2) && (n2 == 3 || n2 == 7)) {
            return this.getCBRBPadding(jComponent, jComponent2, n2, this.dluToPixels(3, n2));
        }
        return this.getCBRBPadding(jComponent, jComponent2, n2, this.dluToPixels(4, n2));
    }

    public int getContainerGap(JComponent jComponent, int n, Container container) {
        super.getContainerGap(jComponent, n, container);
        return this.getCBRBPadding(jComponent, n, this.dluToPixels(7, n));
    }

    private int dluToPixels(int n, int n2) {
        if (this.baseUnitX == 0) {
            this.calculateBaseUnits();
        }
        if (n2 == 3 || n2 == 7) {
            return n * this.baseUnitX / 4;
        }
        assert (n2 == 1 || n2 == 5);
        return n * this.baseUnitY / 8;
    }

    private void calculateBaseUnits() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(UIManager.getFont("Button.font"));
        this.baseUnitX = fontMetrics.stringWidth("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        this.baseUnitX = (this.baseUnitX / 26 + 1) / 2;
        this.baseUnitY = fontMetrics.getAscent() + fontMetrics.getDescent() - 1;
    }
}

