/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int n) {
        this.explicitDeclarations = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean bl = false;
        int n = 0;
        int n2 = this.statements.length;
        while (n < n2) {
            Statement statement = this.statements[n];
            if (!statement.complainIfUnreachable(flowInfo, this.scope, bl)) {
                flowInfo = statement.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                bl = true;
            }
            ++n;
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].generateCode(this.scope, codeStream);
                ++n2;
            }
        }
        if (this.scope != blockScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.statements == null) {
            return stringBuffer;
        }
        int n2 = 0;
        while (n2 < this.statements.length) {
            this.statements[n2].printStatement(n + 1, stringBuffer);
            stringBuffer.append('\n');
            ++n2;
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        Block.printIndent(n, stringBuffer);
        stringBuffer.append("{\n");
        this.printBody(n, stringBuffer);
        return Block.printIndent(n, stringBuffer).append('}');
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? blockScope : new BlockScope(blockScope, this.explicitDeclarations);
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                this.statements[n].resolve(this.scope);
                ++n;
            }
        }
    }

    public void resolveUsing(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = blockScope;
        if (this.statements != null) {
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                this.statements[n].resolve(this.scope);
                ++n;
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.statements != null) {
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                this.statements[n].traverse(aSTVisitor, this.scope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void branchChainTo(BranchLabel branchLabel) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(branchLabel);
        }
    }
}

