/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.WaferMapPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.general.WaferMapDataset;

public class WaferMapRenderer
extends AbstractRenderer {
    private Map paintIndex = new HashMap();
    private WaferMapPlot plot;
    private int paintLimit;
    private static final int DEFAULT_PAINT_LIMIT = 35;
    public static final int POSITION_INDEX = 0;
    public static final int VALUE_INDEX = 1;
    private int paintIndexMethod;

    public WaferMapRenderer() {
        this(null, null);
    }

    public WaferMapRenderer(int n, int n2) {
        this(new Integer(n), new Integer(n2));
    }

    public WaferMapRenderer(Integer n, Integer n2) {
        this.paintLimit = n == null ? 35 : n;
        this.paintIndexMethod = 1;
        if (n2 != null && this.isMethodValid(n2)) {
            this.paintIndexMethod = n2;
        }
    }

    private boolean isMethodValid(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        WaferMapPlot waferMapPlot = this.getPlot();
        if (waferMapPlot != null) {
            drawingSupplier = waferMapPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    public WaferMapPlot getPlot() {
        return this.plot;
    }

    public void setPlot(WaferMapPlot waferMapPlot) {
        this.plot = waferMapPlot;
        this.makePaintIndex();
    }

    public Paint getChipColor(Number number) {
        return this.getSeriesPaint(this.getPaintIndex(number));
    }

    private int getPaintIndex(Number number) {
        return (Integer)this.paintIndex.get(number);
    }

    private void makePaintIndex() {
        if (this.plot == null) {
            return;
        }
        WaferMapDataset waferMapDataset = this.plot.getDataset();
        Number number = waferMapDataset.getMinValue();
        Number number2 = waferMapDataset.getMaxValue();
        Set set = waferMapDataset.getUniqueValues();
        if (set.size() <= this.paintLimit) {
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.paintIndex.put(iterator.next(), new Integer(n++));
            }
        } else {
            switch (this.paintIndexMethod) {
                case 0: {
                    this.makePositionIndex(set);
                    break;
                }
                case 1: {
                    this.makeValueIndex(number2, number, set);
                    break;
                }
            }
        }
    }

    private void makePositionIndex(Set set) {
        int n = (int)Math.ceil((double)set.size() / (double)this.paintLimit);
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.paintIndex.put(iterator.next(), new Integer(n3));
            if (++n2 % n == 0) {
                ++n3;
            }
            if (n3 <= this.paintLimit) continue;
            n3 = this.paintLimit;
        }
    }

    private void makeValueIndex(Number number, Number number2, Set set) {
        double d = number.doubleValue() - number2.doubleValue();
        double d2 = d / (double)this.paintLimit;
        int n = 0;
        double d3 = number2.doubleValue() + d2;
        for (Number number3 : set) {
            while (number3.doubleValue() > d3) {
                d3 += d2;
                if (++n <= this.paintLimit) continue;
                n = this.paintLimit;
            }
            this.paintIndex.put(number3, new Integer(n));
        }
    }

    public LegendItemCollection getLegendCollection() {
        LegendItemCollection legendItemCollection;
        block4: {
            legendItemCollection = new LegendItemCollection();
            if (this.paintIndex == null || this.paintIndex.size() <= 0) break block4;
            if (this.paintIndex.size() <= this.paintLimit) {
                for (Map.Entry entry : this.paintIndex.entrySet()) {
                    String string;
                    String string2 = string = entry.getKey().toString();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
                    Paint paint = this.getSeriesPaint((Integer)entry.getValue());
                    Color color = Color.black;
                    Stroke stroke = DEFAULT_STROKE;
                    legendItemCollection.add(new LegendItem(string, string2, null, null, (Shape)double_, paint, stroke, (Paint)color));
                }
            } else {
                HashSet hashSet = new HashSet();
                for (Map.Entry entry : this.paintIndex.entrySet()) {
                    String string;
                    if (!hashSet.add(entry.getValue())) continue;
                    String string3 = string = String.valueOf(this.getMinPaintValue((Integer)entry.getValue()).toString()) + " - " + this.getMaxPaintValue((Integer)entry.getValue()).toString();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
                    Paint paint = this.getSeriesPaint((Integer)entry.getValue());
                    Color color = Color.black;
                    Stroke stroke = DEFAULT_STROKE;
                    legendItemCollection.add(new LegendItem(string, string3, null, null, (Shape)double_, paint, stroke, (Paint)color));
                }
            }
        }
        return legendItemCollection;
    }

    private Number getMinPaintValue(Integer n) {
        double d = Double.POSITIVE_INFINITY;
        for (Map.Entry entry : this.paintIndex.entrySet()) {
            if (!((Integer)entry.getValue()).equals(n) || !(((Number)entry.getKey()).doubleValue() < d)) continue;
            d = ((Number)entry.getKey()).doubleValue();
        }
        return new Double(d);
    }

    private Number getMaxPaintValue(Integer n) {
        double d = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : this.paintIndex.entrySet()) {
            if (!((Integer)entry.getValue()).equals(n) || !(((Number)entry.getKey()).doubleValue() > d)) continue;
            d = ((Number)entry.getKey()).doubleValue();
        }
        return new Double(d);
    }
}

