/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;

public class Hour
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -835471579831937652L;
    public static final int FIRST_HOUR_IN_DAY = 0;
    public static final int LAST_HOUR_IN_DAY = 23;
    private Day day;
    private byte hour;
    private long firstMillisecond;
    private long lastMillisecond;

    public Hour() {
        this(new Date());
    }

    public Hour(int n, Day day) {
        if (day == null) {
            throw new IllegalArgumentException("Null 'day' argument.");
        }
        this.hour = (byte)n;
        this.day = day;
        this.peg(Calendar.getInstance());
    }

    public Hour(int n, int n2, int n3, int n4) {
        this(n, new Day(n2, n3, n4));
    }

    public Hour(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Hour(Date date, TimeZone timeZone) {
        if (date == null) {
            throw new IllegalArgumentException("Null 'time' argument.");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone);
        this.peg(Calendar.getInstance());
    }

    public int getHour() {
        return this.hour;
    }

    public Day getDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDayOfMonth() {
        return this.day.getDayOfMonth();
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Day day;
        Hour hour = this.hour != 0 ? new Hour(this.hour - 1, this.day) : ((day = (Day)this.day.previous()) != null ? new Hour(23, day) : null);
        return hour;
    }

    public RegularTimePeriod next() {
        Day day;
        Hour hour = this.hour != 23 ? new Hour(this.hour + 1, this.day) : ((day = (Day)this.day.next()) != null ? new Hour(0, day) : null);
        return hour;
    }

    public long getSerialIndex() {
        return this.day.getSerialIndex() * 24L + (long)this.hour;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Hour)) {
            return false;
        }
        Hour hour = (Hour)object;
        if (this.hour != hour.hour) {
            return false;
        }
        return this.day.equals(hour.day);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.hour;
        n = 37 * n + this.day.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            n = this.getDay().compareTo(hour.getDay());
            if (n == 0) {
                n = this.hour - hour.getHour();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public static Hour parseHour(String string) {
        Hour hour = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            int n = Integer.parseInt(string3 = string3.trim());
            if (n >= 0 && n <= 23) {
                hour = new Hour(n, day);
            }
        }
        return hour;
    }
}

