/*
 * ============================================================================
 * GNU Lesser General Public License
 * ============================================================================
 *
 * JasperReports - Free Java report-generating library.
 * Copyright (C) 2001-2006 JasperSoft Corporation http://www.jaspersoft.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 * 
 * JasperSoft Corporation
 * 303 Second Street, Suite 450 North
 * San Francisco, CA 94107
 * http://www.jaspersoft.com
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRConstants;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: JRTemplateGraphicElement.java 1229 2006-04-19 13:27:35 +0300 (Wed, 19 Apr 2006) teodord $
 */
public class JRTemplateGraphicElement extends JRTemplateElement
{


	/**
	 *
	 */
	private static final long serialVersionUID = JRConstants.SERIAL_VERSION_UID;

	/**
	 *
	 */
	private Byte pen = null;
	private Byte fill = null;


	/**
	 *
	 */
	protected JRTemplateGraphicElement(JRDefaultStyleProvider defaultStyleProvider)
	{
		super(defaultStyleProvider);
	}

	/**
	 *
	 */
	protected JRTemplateGraphicElement(JRDefaultStyleProvider defaultStyleProvider, JRGraphicElement graphicElement)
	{
		super(defaultStyleProvider);

		setGraphicElement(graphicElement);
	}


	/**
	 *
	 */
	protected void setGraphicElement(JRGraphicElement graphicElement)
	{
		super.setElement(graphicElement);
		
		setPen(graphicElement.getPen());
		setFill(graphicElement.getFill());
	}

	/**
	 *
	 */
	public byte getPen()
	{
		return JRStyleResolver.getPen(this, JRGraphicElement.PEN_1_POINT);
	}
		
	/**
	 *
	 */
	public Byte getOwnPen()
	{
		return pen;
	}
		
	/**
	 *
	 */
	protected void setPen(byte pen)
	{
		this.pen = new Byte(pen);
	}
		
	/**
	 *
	 */
	protected void setPen(Byte pen)
	{
		this.pen = pen;
	}
		
	/**
	 *
	 */
	public byte getFill()
	{
		return JRStyleResolver.getFill(this, JRGraphicElement.FILL_SOLID);
	}
		
	/**
	 *
	 */
	public Byte getOwnFill()
	{
		return fill;
	}
		
	/**
	 *
	 */
	protected void setFill(byte fill)
	{
		this.fill = new Byte(fill);
	}
	
	/**
	 *
	 */
	protected void setFill(Byte fill)
	{
		this.fill = fill;
	}
	

}
