/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.util.ThreadLocalStack;

public class JRResourcesUtil {
    private static URLStreamHandlerFactory globalURLHandlerFactory;
    private static ThreadLocalStack localURLHandlerFactoryStack;
    private static ClassLoader globalClassLoader;
    private static ThreadLocalStack localClassLoaderStack;

    static {
        localURLHandlerFactoryStack = new ThreadLocalStack();
        localClassLoaderStack = new ThreadLocalStack();
    }

    public static URL createURL(String string, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        URL uRL;
        URLStreamHandler uRLStreamHandler = JRResourcesUtil.getURLHandler(string, uRLStreamHandlerFactory);
        try {
            uRL = uRLStreamHandler == null ? new URL(string) : new URL(null, string, uRLStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public static URLStreamHandler getURLHandler(String string, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        String string2;
        uRLStreamHandlerFactory = JRResourcesUtil.getURLHandlerFactory(uRLStreamHandlerFactory);
        URLStreamHandler uRLStreamHandler = null;
        if (uRLStreamHandlerFactory != null && (string2 = JRResourcesUtil.getURLProtocol(string)) != null) {
            uRLStreamHandler = uRLStreamHandlerFactory.createURLStreamHandler(string2);
        }
        return uRLStreamHandler;
    }

    private static String getURLProtocol(String string) {
        String string2;
        String string3 = null;
        int n = (string = string.trim()).indexOf(58);
        if (n > 0 && JRResourcesUtil.protocolValid(string2 = string.substring(0, n))) {
            string3 = string2;
        }
        return string3;
    }

    private static boolean protocolValid(String string) {
        int n = string.length();
        if (n < 1) {
            return false;
        }
        if (!Character.isLetter(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '+' && c != '-' && c != '.') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static URLStreamHandlerFactory getURLHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (uRLStreamHandlerFactory == null && (uRLStreamHandlerFactory = JRResourcesUtil.getThreadURLStreamHandlerFactory()) == null) {
            uRLStreamHandlerFactory = globalURLHandlerFactory;
        }
        return uRLStreamHandlerFactory;
    }

    public static URLStreamHandlerFactory getGlobalURLStreamHandlerFactory() {
        return globalURLHandlerFactory;
    }

    public static URLStreamHandlerFactory getThreadURLStreamHandlerFactory() {
        return (URLStreamHandlerFactory)localURLHandlerFactoryStack.top();
    }

    public static void setThreadURLHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        localURLHandlerFactoryStack.push(uRLStreamHandlerFactory);
    }

    public static void resetThreadURLHandlerFactory() {
        localURLHandlerFactoryStack.pop();
    }

    public static void setGlobalURLHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        globalURLHandlerFactory = uRLStreamHandlerFactory;
    }

    public static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = JRResourcesUtil.getThreadClassLoader()) == null) {
            classLoader = globalClassLoader;
        }
        return classLoader;
    }

    public static ClassLoader getGlobalClassLoader() {
        return globalClassLoader;
    }

    public static ClassLoader getThreadClassLoader() {
        return (ClassLoader)localClassLoaderStack.top();
    }

    public static void setThreadClassLoader(ClassLoader classLoader) {
        localClassLoaderStack.push(classLoader);
    }

    public static void resetClassLoader() {
        localClassLoaderStack.pop();
    }

    public static void setGlobalClassLoader(ClassLoader classLoader) {
        globalClassLoader = classLoader;
    }

    public static URL findClassLoaderResource(String string, ClassLoader classLoader, Class clazz) {
        classLoader = JRResourcesUtil.getClassLoader(classLoader);
        URL uRL = null;
        if (classLoader != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                uRL = classLoader.getResource(string);
            }
            if (uRL == null) {
                classLoader = clazz.getClassLoader();
                uRL = classLoader == null ? clazz.getResource("/" + string) : classLoader.getResource(string);
            }
        }
        return uRL;
    }
}

