/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int blockStart;
    public int caseCount;
    int[] constants;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchFlowContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
            FlowInfo flowInfo2 = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
            int n = 0;
            if (this.statements != null) {
                boolean bl = false;
                int n2 = 0;
                int n3 = 0;
                int n4 = this.statements.length;
                while (n3 < n4) {
                    Statement statement = this.statements[n3];
                    if (n < this.caseCount && statement == this.cases[n]) {
                        this.scope.enclosingCase = this.cases[n];
                        ++n;
                        if (n2 == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        flowInfo2 = ((FlowInfo)flowInfo2).mergedWith(flowInfo.unconditionalInits());
                        bl = false;
                        n2 = 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (n2 == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        flowInfo2 = ((FlowInfo)flowInfo2).mergedWith(flowInfo.unconditionalInits());
                        bl = false;
                        n2 = 0;
                    } else {
                        n2 = 1;
                    }
                    if (!statement.complainIfUnreachable(flowInfo2, this.scope, bl)) {
                        if ((flowInfo2 = statement.analyseCode(this.scope, switchFlowContext, flowInfo2)) == FlowInfo.DEAD_END) {
                            n2 = 2;
                        }
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
            }
            TypeBinding typeBinding = this.expression.resolvedType;
            if (this.caseCount > 0 && typeBinding.isEnum()) {
                SourceTypeBinding sourceTypeBinding = this.scope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(typeBinding);
            }
            if (this.defaultCase == null) {
                flowInfo.addPotentialInitializationsFrom(((FlowInfo)flowInfo2).mergedWith(switchFlowContext.initsOnBreak));
                this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo3 = flowInfo;
                return flowInfo3;
            }
            UnconditionalFlowInfo unconditionalFlowInfo = ((FlowInfo)flowInfo2).mergedWith(switchFlowContext.initsOnBreak);
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            UnconditionalFlowInfo unconditionalFlowInfo2 = unconditionalFlowInfo;
            return unconditionalFlowInfo2;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        try {
            int n;
            TypeBinding typeBinding;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int n2 = codeStream.position;
            this.breakLabel.initialize(codeStream);
            CaseLabel[] caseLabelArray = new CaseLabel[this.caseCount];
            boolean bl = this.caseCount != 0;
            int n3 = 0;
            while (n3 < this.caseCount) {
                this.cases[n3].targetLabel = caseLabelArray[n3] = new CaseLabel(codeStream);
                caseLabelArray[n3].tagBits |= 2;
                ++n3;
            }
            CaseLabel caseLabel = new CaseLabel(codeStream);
            if (bl) {
                caseLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = caseLabel;
            }
            if ((typeBinding = this.expression.resolvedType).isEnum()) {
                if (bl) {
                    codeStream.invokestatic(this.synthetic);
                    this.expression.generateCode(blockScope, codeStream, true);
                    codeStream.invokeEnumOrdinal(typeBinding.constantPoolName());
                    codeStream.iaload();
                } else {
                    this.expression.generateCode(blockScope, codeStream, false);
                }
            } else {
                this.expression.generateCode(blockScope, codeStream, bl);
            }
            if (bl) {
                int[] nArray = new int[this.caseCount];
                int n4 = 0;
                while (n4 < this.caseCount) {
                    nArray[n4] = n4;
                    ++n4;
                }
                int[] nArray2 = new int[this.caseCount];
                System.arraycopy(this.constants, 0, nArray2, 0, this.caseCount);
                CodeStream.sort(nArray2, 0, this.caseCount - 1, nArray);
                n = nArray2[this.caseCount - 1];
                int n5 = nArray2[0];
                if ((long)((double)this.caseCount * 2.5) > (long)n - (long)n5) {
                    if (n > 0x7FFF0000 && blockScope.compilerOptions().complianceLevel < 0x300000L) {
                        codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                    } else {
                        codeStream.tableswitch(caseLabel, n5, n, this.constants, nArray, caseLabelArray);
                    }
                } else {
                    codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                }
                codeStream.updateLastRecordedEndPC(this.scope, codeStream.position);
            }
            int n6 = 0;
            if (this.statements != null) {
                int n7 = 0;
                n = this.statements.length;
                while (n7 < n) {
                    Statement statement = this.statements[n7];
                    if (n6 < this.caseCount && statement == this.cases[n6]) {
                        this.scope.enclosingCase = this.cases[n6];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                        ++n6;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                    ++n7;
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                caseLabel.place();
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        SwitchStatement.printIndent(n, stringBuffer).append("switch (");
        this.expression.printExpression(0, stringBuffer).append(") {");
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statements.length) {
                stringBuffer.append('\n');
                if (this.statements[n2] instanceof CaseStatement) {
                    this.statements[n2].printStatement(n, stringBuffer);
                } else {
                    this.statements[n2].printStatement(n + 2, stringBuffer);
                }
                ++n2;
            }
        }
        stringBuffer.append("\n");
        return SwitchStatement.printIndent(n, stringBuffer).append('}');
    }

    /*
     * Unable to fully structure code
     */
    public void resolve(BlockScope var1_1) {
        block25: {
            try {
                block27: {
                    block28: {
                        var2_2 = false;
                        var3_3 = this.expression.resolveType(var1_1);
                        if (var3_3 == null) break block27;
                        this.expression.computeConversion(var1_1, var3_3, var3_3);
                        if (!var3_3.isBaseType()) break block28;
                        if (!this.expression.isConstantValueOfTypeAssignableToType(var3_3, TypeBinding.INT) && !var3_3.isCompatibleWith(TypeBinding.INT)) ** GOTO lbl-1000
                        break block27;
                    }
                    if (var3_3.isEnum()) {
                        var2_2 = true;
                    } else if (var1_1.isBoxingCompatibleWith(var3_3, TypeBinding.INT)) {
                        this.expression.computeConversion(var1_1, TypeBinding.INT, var3_3);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_1.problemReporter().incorrectSwitchType(this.expression, var3_3);
                        var3_3 = null;
                    }
                }
                if (this.statements != null) {
                    this.scope = new BlockScope(var1_1);
                    var4_4 = this.statements.length;
                    this.cases = new CaseStatement[var4_4];
                    this.constants = new int[var4_4];
                    var5_5 = null;
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    while (var8_8 < var4_4) {
                        var10_12 = this.statements[var8_8];
                        var9_10 = var10_12.resolveCase(this.scope, var3_3, this);
                        if (var9_10 != Constant.NotAConstant) {
                            var11_13 = var9_10.intValue();
                            var12_14 = 0;
                            while (var12_14 < var7_7) {
                                if (this.constants[var12_14] == var11_13) {
                                    var13_15 = (CaseStatement)var10_12;
                                    if (var5_5 == null) {
                                        this.scope.problemReporter().duplicateCase(this.cases[var12_14]);
                                        this.scope.problemReporter().duplicateCase(var13_15);
                                        var5_5 = new CaseStatement[var4_4];
                                        var5_5[var6_6++] = this.cases[var12_14];
                                        var5_5[var6_6++] = var13_15;
                                    } else {
                                        var14_16 = false;
                                        var15_17 = 2;
                                        while (var15_17 < var6_6) {
                                            if (var5_5[var15_17] == var10_12) {
                                                var14_16 = true;
                                                break;
                                            }
                                            ++var15_17;
                                        }
                                        if (!var14_16) {
                                            this.scope.problemReporter().duplicateCase(var13_15);
                                            var5_5[var6_6++] = var13_15;
                                        }
                                    }
                                }
                                ++var12_14;
                            }
                            this.constants[var7_7++] = var11_13;
                        }
                        ++var8_8;
                    }
                    if (var4_4 != var7_7) {
                        this.constants = new int[var7_7];
                        System.arraycopy(this.constants, 0, this.constants, 0, var7_7);
                    }
                } else if ((this.bits & 8) != 0) {
                    var1_1.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
                }
                if (!var2_2 || this.defaultCase != null || var1_1.compilerOptions().getSeverity(0x20000000000L) == -1) break block25;
                v0 = var4_4 = this.constants == null ? 0 : this.constants.length;
                if (var4_4 != this.caseCount || this.caseCount == ((ReferenceBinding)var3_3).enumConstantCount()) break block25;
                var5_5 = ((ReferenceBinding)var3_3.erasure()).fields();
                var6_6 = 0;
                var7_7 = var5_5.length;
                while (var6_6 < var7_7) {
                    block26: {
                        var8_9 = var5_5[var6_6];
                        if ((var8_9.modifiers & 16384) != 0) {
                            var9_11 = 0;
                            while (var9_11 < this.caseCount) {
                                if (var8_9.id + 1 != this.constants[var9_11]) {
                                    ++var9_11;
                                    continue;
                                }
                                break block26;
                            }
                            var1_1.problemReporter().missingEnumConstantCase(this, (FieldBinding)var8_9);
                        }
                    }
                    ++var6_6;
                }
            }
            finally {
                if (this.scope != null) {
                    this.scope.enclosingCase = null;
                }
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, this.scope);
            if (this.statements != null) {
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    this.statements[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void branchChainTo(BranchLabel branchLabel) {
        if (this.breakLabel.forwardReferenceCount > 0) {
            branchLabel.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

