/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class ModeloDeclaracao
extends ObjetoNegocio {
    public static final String LIMITE_ANUAL_27_MEIO_PORCENT = "31.501,44";
    public static final String LIMITE_ANUAL_15_PORCENT = "15.764,28";
    public static final String LIMITE_MENSAL_27_MEIO_PORCENT = "6.302,32";
    public static final String LIMITE_MENSAL_15_PORCENT = "2.364,64";
    public static final String NOME_TOTAL_REND_RECEB_MAIS_EXTERIOR = "Total de Rendimentos Recebidos";
    public static final String NOME_TOTAL_LIVRO_CAIXA_TIT_DEP = "Total Livro Caixa - TIT + DEP";
    protected DeclaracaoIRPF declaracaoIRPF = null;
    protected Valor impostoDevido = new Valor(this, "");
    protected Valor impostoDevidoII = new Valor(this, "");
    protected Valor baseCalculo = new Valor(this, "");
    protected Valor saldoImpostoPagar = new Valor(this, "");
    protected Valor impostoRestituir = new Valor(this, "");
    protected Valor rendRecebidoExterior = new Valor(this, "");
    protected Valor totalRendRecebidosMaisExterior = new Valor(this, "Total de Rendimentos Recebidos");
    protected Valor totalLivroCaixa = new Valor(this, "Total Livro Caixa - TIT + DEP");
    protected Valor totalDoacoesCampanhasEleitorais = new Valor(this, "");

    public ModeloDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        this.declaracaoIRPF = declaracaoIRPF;
        this.totalRendRecebidosMaisExterior.setReadOnly(true);
    }

    public Valor getTotalRendRecebidosMaisExterior() {
        return this.totalRendRecebidosMaisExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor calculaImposto(Valor valor) {
        Valor valor2 = new Valor();
        if (valor.comparacao("<", LIMITE_ANUAL_15_PORCENT)) {
            valor2.clear();
        } else if (valor.comparacao("<", LIMITE_ANUAL_27_MEIO_PORCENT)) {
            Valor valor3 = new Valor();
            valor3.setConteudo(valor.operacao('*', "0,15"));
            valor3.append('-', LIMITE_MENSAL_15_PORCENT);
            valor2.setConteudo(valor3);
        } else {
            Valor valor4 = new Valor();
            valor4.setConteudo(valor);
            valor4.converteQtdCasasDecimais(3);
            valor4.setConteudo(valor4.operacao('*', "0,275"));
            valor4.append('-', LIMITE_MENSAL_27_MEIO_PORCENT);
            valor4.converteQtdCasasDecimais(2);
            valor2.setConteudo(valor4);
        }
        return valor2;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getBaseCalculo() {
        return this.baseCalculo;
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getRendRecebidoExterior() {
        return this.rendRecebidoExterior;
    }

    public abstract void resumoRendimentosTributaveis();

    public abstract void resumoCalculoImposto();

    public abstract void resumoOutrasInformacoes();

    public abstract void aplicaValoresNaDeclaracao();

    public abstract Valor recuperarTotalRendimentosTributaveis();

    public abstract Valor recuperarTotalImpostoPago();

    public abstract String recuperarCodInImpostoPago();

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }
}

