/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.conjuge;

import serpro.ppgd.irpf.conjuge.Conjuge;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ObservadorConjuge
extends Observador {
    private Conjuge conjuge = null;

    public ObservadorConjuge(Conjuge conjuge) {
        this.conjuge = conjuge;
    }

    public Valor recuperarResultadoConjuge() {
        Valor valor = new Valor();
        if (this.conjuge.getDecSimplificada().asString().equals("0")) {
            valor.setConteudo(this.conjuge.getBaseCalculoImposto());
            valor.append('-', this.conjuge.getImpRetidoFonte());
            valor.append('+', this.conjuge.getRendIsentoNaoTributaveis());
            valor.append('+', this.conjuge.getRendSujeitosTribExcl());
        } else {
            valor.setConteudo(this.conjuge.getBaseCalculoImposto());
            valor.append('-', this.conjuge.getImpRetidoFonte());
            valor.append('-', this.conjuge.getCarneComImpComplementar());
            valor.append('+', this.conjuge.getRendIsentoNaoTributaveis());
            valor.append('+', this.conjuge.getRendSujeitosTribExcl());
        }
        if (valor.comparacao("<", "0,00")) {
            valor.clear();
        }
        this.conjuge.getResultado().setConteudo(valor);
        return this.conjuge.getResultado();
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("CPF")) {
                this.conjuge.getCpfConjuge().validar();
                if (this.conjuge.getCpfConjuge().isVazio() || !this.conjuge.getCpfConjuge().isValido()) {
                    this.desabilitaValores();
                    this.limpaValores();
                    this.conjuge.getDecSimplificada().setHabilitado(false);
                } else {
                    this.conjuge.getDecSimplificada().setHabilitado(true);
                }
            } else if (string.equals("O c\u00f4njuge apresentou declara\u00e7\u00e3o de ajuste anual simplificada?")) {
                if (!this.conjuge.getDecSimplificada().isVazio()) {
                    this.habilitaValores();
                } else {
                    this.desabilitaValores();
                }
                if (this.conjuge.getDecSimplificada().asString().equals("1")) {
                    this.conjuge.getCarneComImpComplementar().setReadOnly(false);
                    if (!this.conjuge.getValAntigoCarneLeao().isVazio()) {
                        this.conjuge.getCarneComImpComplementar().setConteudo(this.conjuge.getValAntigoCarneLeao());
                    }
                    if (!this.conjuge.getValAntigoImpostoRetidoFonte().isVazio()) {
                        this.conjuge.getImpRetidoFonte().setConteudo(this.conjuge.getValAntigoImpostoRetidoFonte());
                    }
                } else if (this.conjuge.getDecSimplificada().asString().equals("0")) {
                    this.conjuge.getCarneComImpComplementar().setReadOnly(true);
                    this.conjuge.getValAntigoCarneLeao().setConteudo(this.conjuge.getCarneComImpComplementar());
                    this.conjuge.getValAntigoImpostoRetidoFonte().setConteudo(this.conjuge.getImpRetidoFonte());
                    this.conjuge.getImpRetidoFonte().setConteudo(this.conjuge.getImpRetidoFonte().operacao('+', this.conjuge.getCarneComImpComplementar()));
                    this.conjuge.getCarneComImpComplementar().clear();
                }
            } else if (string.equals("Base de c\u00e1lculo") || string.equals("Base de c\u00e1lculo") || string.equals("Imposto retido na fonte") || string.equals("Carn\u00ea-Le\u00e3o e imposto complementar") || string.equals("Rendimentos isentos e n\u00e3o-tribut\u00e1veis") || string.equals("Rendimentos sujeitos \u00e0 tributa\u00e7\u00e3o exclusiva")) {
                this.recuperarResultadoConjuge();
            }
        }
    }

    private void limpaValores() {
        this.conjuge.getDecSimplificada().clear();
        this.conjuge.getBaseCalculoImposto().clear();
        this.conjuge.getImpRetidoFonte().clear();
        this.conjuge.getCarneComImpComplementar().clear();
        this.conjuge.getRendIsentoNaoTributaveis().clear();
        this.conjuge.getRendSujeitosTribExcl().clear();
        this.conjuge.getResultado().clear();
        this.conjuge.getValAntigoCarneLeao().clear();
        this.conjuge.getValAntigoImpostoRetidoFonte().clear();
    }

    private void desabilitaValores() {
        this.conjuge.getBaseCalculoImposto().setHabilitado(false);
        this.conjuge.getImpRetidoFonte().setHabilitado(false);
        this.conjuge.getCarneComImpComplementar().setReadOnly(true);
        this.conjuge.getRendIsentoNaoTributaveis().setHabilitado(false);
        this.conjuge.getRendSujeitosTribExcl().setHabilitado(false);
    }

    private void habilitaValores() {
        this.conjuge.getBaseCalculoImposto().setHabilitado(true);
        this.conjuge.getImpRetidoFonte().setHabilitado(true);
        this.conjuge.getCarneComImpComplementar().setReadOnly(false);
        this.conjuge.getRendIsentoNaoTributaveis().setHabilitado(true);
        this.conjuge.getRendSujeitosTribExcl().setHabilitado(true);
    }
}

