/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class MapeamentoTXT {
    private static MapeamentoTXT instancia = null;
    private Document mapeamentoDOM;

    protected MapeamentoTXT() {
        String string = FabricaUtilitarios.getProperties().getProperty("aplicacao.formatosexternos.mapeamento", "mapeamentoTxt");
        this.mapeamentoDOM = this.carregarDOM(Thread.currentThread().getContextClassLoader().getResourceAsStream(string));
    }

    public static MapeamentoTXT getInstance() {
        if (instancia == null) {
            instancia = new MapeamentoTXT();
        }
        return instancia;
    }

    public static MapeamentoTXT getInstancia() {
        if (instancia == null) {
            instancia = new MapeamentoTXT();
        }
        return instancia;
    }

    private Document carregarDOM(InputStream inputStream) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXParseException sAXParseException) {
            LogPPGD.erro("Erro de parsing de " + sAXParseException.getSystemId() + ". linha " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            LogPPGD.erro("Erro de parsing: " + exception.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            LogPPGD.erro("Erro de I/O: " + iOException.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        return document;
    }

    public String getColecaoRegistroMultipo(String string, String string2) {
        Element element = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && nodeList.item(n).getNodeName().equals("DeclaracaoTXT")) {
                Element element2 = (Element)nodeList.item(n);
                element2.getAttribute("TipoArquivo");
                if (element2.getAttribute("TipoArquivo").equals(string)) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Element element3;
                        if (nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals("Registro") && (element3 = (Element)nodeList2.item(n2)).getAttribute("Identificador").equals(string2)) {
                            return element3.getAttribute("Colecao").trim();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return "";
    }

    public boolean participaImportacao(String string, String string2) {
        Element element = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && nodeList.item(n).getNodeName().equals("DeclaracaoTXT")) {
                Element element2 = (Element)nodeList.item(n);
                element2.getAttribute("TipoArquivo");
                if (element2.getAttribute("TipoArquivo").equals(string)) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Element element3;
                        if (nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals("Registro") && (element3 = (Element)nodeList2.item(n2)).getAttribute("Identificador").equals(string2)) {
                            return !element3.getAttribute("ParticipaImportacao").trim().equals("false");
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public boolean participaGravacao(String string, String string2) {
        Element element = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && nodeList.item(n).getNodeName().equals("DeclaracaoTXT")) {
                Element element2 = (Element)nodeList.item(n);
                element2.getAttribute("TipoArquivo");
                if (element2.getAttribute("TipoArquivo").equals(string)) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Element element3;
                        if (nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals("Registro") && (element3 = (Element)nodeList2.item(n2)).getAttribute("Identificador").equals(string2)) {
                            return !element3.getAttribute("ParticipaGravacao").trim().equals("false");
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public NodeList getRelacaoCamposRegistro(String string, String string2) {
        Element element = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && nodeList.item(n).getNodeName().equals("DeclaracaoTXT")) {
                Element element2 = (Element)nodeList.item(n);
                element2.getAttribute("TipoArquivo");
                if (element2.getAttribute("TipoArquivo").equals(string)) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Element element3;
                        if (nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals("Registro") && (element3 = (Element)nodeList2.item(n2)).getAttribute("Identificador").equals(string2)) {
                            NodeList nodeList3 = element3.getChildNodes();
                            LogPPGD.debug(element2.getNodeName());
                            return nodeList3;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public List getTiposDeRegistrosArquivo(String string) {
        Vector<String> vector = new Vector<String>();
        Element element = this.mapeamentoDOM.getDocumentElement();
        LogPPGD.debug(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && nodeList.item(n).getNodeName().equals("DeclaracaoTXT")) {
                Element element2 = (Element)nodeList.item(n);
                element2.getAttribute("TipoArquivo");
                if (element2.getAttribute("TipoArquivo").equals(string)) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        if (nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals("Registro")) {
                            Element element3 = (Element)nodeList2.item(n2);
                            vector.add(element3.getAttribute("Identificador"));
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        LogPPGD.debug("Property javax.xml.parsers.DocumentBuilderFactory: " + System.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
        LogPPGD.debug("Implementa\u00e7\u00e3o do JAXP: " + DocumentBuilderFactory.newInstance());
        try {
            new MapeamentoTXT();
            LogPPGD.debug("cheguei no final");
        }
        catch (Exception exception) {
            LogPPGD.erro(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

