/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public abstract class SunJDK14ConditionalEventPump
implements EventPump {
    private static final boolean debug = false;
    private static Class conditionalClass;
    private static Method pumpEventsMethod;
    protected static Class sequencedEventClass;

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException, NoSuchMethodException {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    conditionalClass = classLoader.loadClass("java.awt.Conditional");
                    sequencedEventClass = classLoader.loadClass("java.awt.SequencedEvent");
                    Class<?> clazz = classLoader.loadClass("java.awt.EventDispatchThread");
                    pumpEventsMethod = clazz.getDeclaredMethod("pumpEvents", conditionalClass);
                    pumpEventsMethod.setAccessible(true);
                    String string = "sun.awt.exception.handler";
                    String string2 = System.getProperty(string);
                    if (string2 == null) {
                        string2 = ThrowableHandler.class.getName();
                        System.setProperty(string, string2);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new Error(throwable.toString());
        }
    }

    public void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        try {
            try {
                Object object = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)new Conditional(task));
                pumpEventsMethod.invoke((Object)Thread.currentThread(), object);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                System.err.println("[SunJDK14ConditionalEventPump] Exception occurred during event dispatching:");
                throwable.printStackTrace();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            catch (Throwable throwable) {
                System.err.println("[SunJDK14ConditionalEventPump] PANIC: uncaught exception in Foxtrot code");
                throwable.printStackTrace();
                this.waitForTask(task);
            }
        }
        finally {
            this.waitForTask(task);
        }
    }

    protected abstract Boolean canPumpSequencedEvent(AWTEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTask(Task task) {
        try {
            Task task2 = task;
            synchronized (task2) {
                while (!task.isCompleted()) {
                    task.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private class Conditional
    implements InvocationHandler {
        private Task task;

        private Conditional(Task task) {
            this.task = task;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (!"evaluate".equals(string)) {
                throw new Error("Unknown " + conditionalClass.getName() + " method: " + string);
            }
            AWTEvent aWTEvent = this.getEventQueue().peekEvent();
            if (sequencedEventClass.isInstance(aWTEvent)) {
                return SunJDK14ConditionalEventPump.this.canPumpSequencedEvent(aWTEvent);
            }
            return this.task.isCompleted() ? Boolean.FALSE : Boolean.TRUE;
        }

        private EventQueue getEventQueue() {
            return (EventQueue)AccessController.doPrivileged(new PrivilegedAction(this){
                final /* synthetic */ Conditional this$1;
                {
                    this.this$1 = conditional;
                }

                public Object run() {
                    return Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
            });
        }
    }

    public static class ThrowableHandler {
        public void handle(Throwable throwable) {
            System.err.println("[SunJDK14ConditionalEventPump] Exception occurred during event dispatching:");
            throwable.printStackTrace();
        }
    }
}

