/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Class mappedPropertyType;
    private Method mappedReadMethod;
    private Method mappedWriteMethod;
    private static final Class[] stringClassArray = new Class[]{String.class};
    private static Hashtable declaredMethodCache = new Hashtable();

    public MappedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string + " on class: " + clazz.getClass().getName());
        }
        this.setName(string);
        String string2 = MappedPropertyDescriptor.capitalizePropertyName(string);
        try {
            this.mappedReadMethod = MappedPropertyDescriptor.findMethod(clazz, "get" + string2, 1, stringClassArray);
            Class[] classArray = new Class[]{String.class, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, "set" + string2, 2, classArray);
        }
        catch (IntrospectionException introspectionException) {}
        if (this.mappedReadMethod == null) {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, "set" + string2, 2);
        }
        if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + string + "' not found on " + clazz.getName());
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = MappedPropertyDescriptor.findMethod(clazz, string2, 1, stringClassArray);
        if (this.mappedReadMethod != null) {
            Class[] classArray = new Class[]{String.class, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, string3, 2, classArray);
        } else {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, string3, 2);
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string, method, method2);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = method;
        this.mappedWriteMethod = method2;
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return this.mappedPropertyType;
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethod;
    }

    public void setMappedReadMethod(Method method) throws IntrospectionException {
        this.mappedReadMethod = method;
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethod;
    }

    public void setMappedWriteMethod(Method method) throws IntrospectionException {
        this.mappedWriteMethod = method;
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        this.mappedPropertyType = null;
        if (this.mappedReadMethod != null) {
            if (this.mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            this.mappedPropertyType = this.mappedReadMethod.getReturnType();
            if (this.mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
            }
        }
        if (this.mappedWriteMethod != null) {
            Class<?>[] classArray = this.mappedWriteMethod.getParameterTypes();
            if (classArray.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (this.mappedPropertyType != null && this.mappedPropertyType != classArray[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            this.mappedPropertyType = classArray[1];
        }
    }

    private static String capitalizePropertyName(String string) {
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        final Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Unable to fully structure code
             */
            public Object run() {
                try {
                    return clazz2.getDeclaredMethods();
                }
                catch (SecurityException v0) {
                    var1_1 = clazz2.getMethods();
                    var2_2 = 0;
                    var3_3 = var1_1.length;
                    ** while (var2_2 < var3_3)
                }
lbl-1000:
                // 1 sources

                {
                    var4_4 = var1_1[var2_2];
                    if (!clazz2.equals(var4_4.getDeclaringClass())) {
                        var1_1[var2_2] = null;
                    }
                    ++var2_2;
                    continue;
                }
lbl13:
                // 1 sources

                return var1_1;
            }
        });
        int n = 0;
        while (n < methodArray.length) {
            int n2;
            Method method = methodArray[n];
            if (method != null && !Modifier.isPublic(n2 = method.getModifiers())) {
                methodArray[n] = null;
            }
            ++n;
        }
        declaredMethodCache.put(clazz, methodArray);
        return methodArray;
    }

    private static Method internalFindMethod(Class classArray, String string, int n) {
        Object object = classArray;
        while (object != null) {
            Method[] methodArray = MappedPropertyDescriptor.getPublicDeclaredMethods((Class)object);
            int n2 = 0;
            while (n2 < methodArray.length) {
                int n3;
                Method method = methodArray[n2];
                if (method != null && !Modifier.isStatic(n3 = method.getModifiers()) && method.getName().equals(string) && method.getParameterTypes().length == n) {
                    return method;
                }
                ++n2;
            }
            object = object.getSuperclass();
        }
        object = classArray.getInterfaces();
        int n4 = 0;
        while (n4 < ((Class<?>[])object).length) {
            Method method = MappedPropertyDescriptor.internalFindMethod(object[n4], string, n);
            if (method != null) {
                return method;
            }
            ++n4;
        }
        return null;
    }

    private static Method internalFindMethod(Class classArray, String string, int n, Class[] classArray2) {
        Object object = classArray;
        while (object != null) {
            Method[] methodArray = MappedPropertyDescriptor.getPublicDeclaredMethods((Class)object);
            int n2 = 0;
            while (n2 < methodArray.length) {
                block9: {
                    Method method;
                    block10: {
                        int n3;
                        method = methodArray[n2];
                        if (method == null || Modifier.isStatic(n3 = method.getModifiers())) break block9;
                        Class<?>[] classArray3 = method.getParameterTypes();
                        if (!method.getName().equals(string) || classArray3.length != n) break block9;
                        boolean bl = false;
                        if (n <= 0) break block10;
                        int n4 = 0;
                        while (n4 < n) {
                            if (classArray3[n4] != classArray2[n4]) {
                                bl = true;
                            }
                            ++n4;
                        }
                        if (bl) break block9;
                    }
                    return method;
                }
                ++n2;
            }
            object = object.getSuperclass();
        }
        object = classArray.getInterfaces();
        int n5 = 0;
        while (n5 < ((Class<?>[])object).length) {
            Method method = MappedPropertyDescriptor.internalFindMethod(object[n5], string, n);
            if (method != null) {
                return method;
            }
            ++n5;
        }
        return null;
    }

    static Method findMethod(Class clazz, String string, int n) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n + " arg(s)");
    }

    static Method findMethod(Class clazz, String string, int n, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n + " arg(s) of matching types.");
    }

    static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class clazz3 = clazz;
        while (clazz3 != null) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (clazz2.isInterface()) {
                Class<?>[] classArray = clazz3.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    if (MappedPropertyDescriptor.isSubclass(classArray[n], clazz2)) {
                        return true;
                    }
                    ++n;
                }
            }
            clazz3 = clazz3.getSuperclass();
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == clazz) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

