/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIT;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Pagamento
extends ObjetoNegocio {
    public static final String PAGAMENTO_PROPRIAINSTRUCAO_BR = "01";
    public static final String PAGAMENTO_PROPRIAINSTRUCAO_EX = "02";
    public static final String PAGAMENTO_INSTRUCAODEPEND_BR = "03";
    public static final String PAGAMENTO_INSTRUCAODEPEND_EX = "04";
    public static final String PAGAMENTO_INSTRUCAOALIMENT_BR = "05";
    public static final String PAGAMENTO_INSTRUCAOALIMENT_EX = "06";
    public static final String PAGAMENTO_MEDICO_BR = "07";
    public static final String PAGAMENTO_MEDICO_EX = "08";
    public static final String PAGAMENTO_HOSPITAL_BR = "09";
    public static final String PAGAMENTO_HOSPITAL_EX = "10";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "11";
    public static final String PAGAMENTO_PENSAOALIMENTICIA = "12";
    public static final String PAGAMENTO_PREVIPRIVADA = "13";
    public static final String PAGAMENTO_FAPI = "14";
    public static final String PAGAMENTO_ESTATCRIANCA = "15";
    public static final String PAGAMENTO_CULTURA = "16";
    public static final String PAGAMENTO_AUDIOVISUAIS = "17";
    public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "18";
    public static final String PAGAMENTO_ADVOGADOS = "19";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "20";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "21";
    public static final String PAGAMENTO_PROFLIBERAL = "22";
    public static final String PAGAMENTO_ALUGUEIS = "23";
    public static final String PAGAMENTO_ARRENDRURAL = "24";
    public static final String PAGAMENTO_OUTROS = "25";
    public static final String PERC_LIMITE_DEDUCAO_CONTRIBUICAO_PREV_PRIV_FAPI = "0,12";
    public static final String PERC_LIMITE_DEDUCAO_INCENTIVO = "0,06";
    public static final String LIMITE_DESPESAS_INSTRUCAO = "2.373,84";
    public static final String NOME_CODIGO = "C\u00f3digo";
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoPagamentos());
    private Alfa dependenteOuAlimentando = new Alfa(this, "Dependente/Alimentando", 20);
    private Alfa nomeBeneficiario = new Alfa(this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI(this, "CPF ou CNPJ do Benefici\u00e1rio");
    private Valor valorPago = new Valor(this, "Valor Pago");
    private Valor parcelaNaoDedutivel = new Valor(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private Alfa nitEmpregadoDomestico = new Alfa(this, "NIT do empregado dom\u00e9stico");
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;

    public Pagamento(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.getCodigo().setColunaFiltro(1);
        this.nitEmpregadoDomestico.setHabilitado(false);
        this.getNitEmpregadoDomestico().addValidador(new ValidadorNIT(3, this.tab.msg("pagamento_NIT")){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.getNitEmpregadoDomestico().isHabilitado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("pagamento_codigo")){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNomeBeneficiario().addValidador(new ValidadorNaoNulo(3, ""){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                Pagamento.this.getNiBeneficiario().validar();
                if (Pagamento.this.getNomeBeneficiario().isVazio() && Pagamento.this.getNiBeneficiario().isValido()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(Pagamento.this.getCodigo().asString().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg("pagamento_empregado") : tab.msg("pagamento_beneficiario"), 2);
                }
                if (Pagamento.this.getNomeBeneficiario().isVazio() && !Pagamento.this.getNiBeneficiario().isValido()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(Pagamento.this.getCodigo().asString().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg("pagamento_empregado_ni_invalido") : tab.msg("pagamento_beneficiario_ni_invalido"), 3);
                }
                return null;
            }
        });
        this.getNiBeneficiario().addValidador(new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                String string = Pagamento.this.getCodigo().getConteudoAtual(0);
                String string2 = null;
                if (string.equals(Pagamento.PAGAMENTO_PROPRIAINSTRUCAO_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || string.equals(Pagamento.PAGAMENTO_MEDICO_BR) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || string.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR)) {
                    string2 = "pagamento_nibeneficiario_1";
                } else if (string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA) || string.equals(Pagamento.PAGAMENTO_PREVIPRIVADA) || string.equals(Pagamento.PAGAMENTO_FAPI) || string.equals(Pagamento.PAGAMENTO_ESTATCRIANCA) || string.equals(Pagamento.PAGAMENTO_CULTURA) || string.equals(Pagamento.PAGAMENTO_AUDIOVISUAIS) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || string.equals(Pagamento.PAGAMENTO_PROFLIBERAL) || string.equals(Pagamento.PAGAMENTO_ALUGUEIS) || string.equals(Pagamento.PAGAMENTO_ARRENDRURAL)) {
                    string2 = "pagamento_nibeneficiario_2";
                }
                RetornoValidacao retornoValidacao = Validador.validarNI(UtilitariosString.retiraMascara(this.getInformacao().getConteudoFormatado()));
                if ((Pagamento.this.getNiBeneficiario().isVazio() || retornoValidacao != null) && string2 != null) {
                    return new RetornoValidacao(tab.msg(string2), 2);
                }
                return null;
            }
        });
        this.getParcelaNaoDedutivel().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                String string = Pagamento.this.getCodigo().getConteudoAtual(0);
                if ((string.equals(Pagamento.PAGAMENTO_PROPRIAINSTRUCAO_BR) || string.equals(Pagamento.PAGAMENTO_PROPRIAINSTRUCAO_EX) || string.equals(Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAODEPEND_EX) || string.equals(Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAOALIMENT_EX) || string.equals(Pagamento.PAGAMENTO_MEDICO_BR) || string.equals(Pagamento.PAGAMENTO_MEDICO_EX) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_EX) || string.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR) || string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA) || string.equals(Pagamento.PAGAMENTO_CULTURA)) && Pagamento.this.getParcelaNaoDedutivel().comparacao(">", Pagamento.this.getValorPago())) {
                    return new RetornoValidacao(tab.msg("pagamento_valor_reembolsado"), 3);
                }
                return null;
            }
        });
        this.getValorPago().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                if (Pagamento.this.getCodigo().isVazio() && Pagamento.this.getNomeBeneficiario().isVazio() && Pagamento.this.getNiBeneficiario().isVazio() && Pagamento.this.getParcelaNaoDedutivel().isVazio()) {
                    return null;
                }
                this.setMensagemValidacao(Pagamento.this.getCodigo().asString().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg("pagamento_empregado_valor_pago") : tab.msg("pagamento_valor_pago"));
                return super.validarImplementado();
            }
        });
        this.getDependenteOuAlimentando().addValidador(new ValidadorNaoNulo(3, this.tab.msg("pagamento_dependente_alimentando")){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                String string = Pagamento.this.getCodigo().getConteudoAtual(0);
                if (!(string.equals(Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAODEPEND_EX) || string.equals(Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAOALIMENT_EX))) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNitEmpregadoDomestico().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                return null;
            }
        });
        this.getNiBeneficiario().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.getNiBeneficiario().asString().equals(Pagamento.this.identificadorDeclaracao.getCpf().asString())) {
                    return new RetornoValidacao(tab.msg("pagamento_cpf_beneficiario_igual"), 3);
                }
                return null;
            }
        });
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.dependenteOuAlimentando);
        list.add(this.nomeBeneficiario);
        list.add(this.niBeneficiario);
        list.add(this.nitEmpregadoDomestico);
        list.add(this.valorPago);
        list.add(this.parcelaNaoDedutivel);
        return list;
    }

    public void setNitEmpregadoDomestico(Alfa alfa) {
        this.nitEmpregadoDomestico = alfa;
    }

    public Alfa getNitEmpregadoDomestico() {
        return this.nitEmpregadoDomestico;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }
}

