/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class WindItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8078914101916976844L;

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        WindDataset windDataset = (WindDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = windDataset.getX(n, n2);
        Number number2 = windDataset.getWindDirection(n, n2);
        Number number3 = windDataset.getWindForce(n, n2);
        double d = number3.doubleValue();
        double d2 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
        double d5 = number.doubleValue() + d * Math.cos(d2) * 8000000.0;
        double d6 = d * Math.sin(d2);
        double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
        int n4 = number2.intValue();
        int n5 = number3.intValue();
        String string = String.valueOf(n4) + "-" + n5;
        Line2D.Double double_ = new Line2D.Double(d3, d4, d7, d8);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.blue);
        graphics2D.setFont(new Font("foo", 1, 9));
        graphics2D.drawString(string, (float)d3, (float)d4);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d9 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0 - 5.0);
        double d10 = number3.doubleValue() * Math.cos(d9) * 8000000.0 * 0.8 + number.doubleValue();
        double d11 = number3.doubleValue() * Math.sin(d9) * 0.8;
        double d12 = valueAxis.valueToJava2D(d10, rectangle2D, rectangleEdge);
        double d13 = valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
        double_ = new Line2D.Double(d12, d13, d7, d8);
        graphics2D.draw(double_);
        double d14 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0 + 5.0);
        double d15 = number3.doubleValue() * Math.cos(d14) * 8000000.0 * 0.8 + number.doubleValue();
        double d16 = number3.doubleValue() * Math.sin(d14) * 0.8;
        double d17 = valueAxis.valueToJava2D(d15, rectangle2D, rectangleEdge);
        double d18 = valueAxis2.valueToJava2D(d16, rectangle2D, rectangleEdge2);
        double_ = new Line2D.Double(d17, d18, d7, d8);
        graphics2D.draw(double_);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

