/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class SetNestedPropertiesRule
extends Rule {
    private Log log = null;
    private boolean trimData = true;
    private boolean allowUnknownChildElements = false;
    private HashMap elementNames = new HashMap();

    public SetNestedPropertiesRule() {
    }

    public SetNestedPropertiesRule(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public SetNestedPropertiesRule(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = null;
            if (n < stringArray2.length) {
                string = stringArray2[n];
            }
            this.elementNames.put(stringArray[n], string);
            ++n;
        }
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        this.log = digester.getLogger();
    }

    public void setTrimData(boolean bl) {
        this.trimData = bl;
    }

    public boolean getTrimData() {
        return this.trimData;
    }

    public void setAllowUnknownChildElements(boolean bl) {
        this.allowUnknownChildElements = bl;
    }

    public boolean getAllowUnknownChildElements() {
        return this.allowUnknownChildElements;
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Rules rules = this.digester.getRules();
        AnyChildRule anyChildRule = new AnyChildRule();
        anyChildRule.setDigester(this.digester);
        AnyChildRules anyChildRules = new AnyChildRules(anyChildRule);
        anyChildRules.init(String.valueOf(this.digester.getMatch()) + "/", rules);
        this.digester.setRules(anyChildRules);
    }

    public void body(String string) throws Exception {
        AnyChildRules anyChildRules = (AnyChildRules)this.digester.getRules();
        this.digester.setRules(anyChildRules.getOldRules());
    }

    public void addAlias(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetNestedPropertiesRule[");
        stringBuffer.append("allowUnknownChildElements=");
        stringBuffer.append(this.allowUnknownChildElements);
        stringBuffer.append(", trimData=");
        stringBuffer.append(this.trimData);
        stringBuffer.append(", elementNames=");
        stringBuffer.append(this.elementNames);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class AnyChildRules
    implements Rules {
        private String matchPrefix = null;
        private Rules decoratedRules = null;
        private ArrayList rules = new ArrayList(1);
        private AnyChildRule rule;

        public AnyChildRules(AnyChildRule anyChildRule) {
            this.rule = anyChildRule;
            this.rules.add(anyChildRule);
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }

        public String getNamespaceURI() {
            return null;
        }

        public void setNamespaceURI(String string) {
        }

        public void add(String string, Rule rule) {
        }

        public void clear() {
        }

        public List match(String string) {
            return this.match(null, string);
        }

        public List match(String string, String string2) {
            List list = this.decoratedRules.match(string, string2);
            if (string2.startsWith(this.matchPrefix) && string2.indexOf(47, this.matchPrefix.length()) == -1) {
                if (list == null || list.size() == 0) {
                    return this.rules;
                }
                LinkedList<AnyChildRule> linkedList = new LinkedList<AnyChildRule>(list);
                linkedList.addLast(this.rule);
                return linkedList;
            }
            return list;
        }

        public List rules() {
            SetNestedPropertiesRule.this.log.debug("AnyChildRules.rules invoked.");
            return this.decoratedRules.rules();
        }

        public void init(String string, Rules rules) {
            this.matchPrefix = string;
            this.decoratedRules = rules;
        }

        public Rules getOldRules() {
            return this.decoratedRules;
        }
    }

    private class AnyChildRule
    extends Rule {
        private String currChildNamespaceURI = null;
        private String currChildElementName = null;

        private AnyChildRule() {
        }

        public void begin(String string, String string2, Attributes attributes) throws Exception {
            this.currChildNamespaceURI = string;
            this.currChildElementName = string2;
        }

        public void body(String string) throws Exception {
            Object object;
            String string2 = this.currChildElementName;
            if (SetNestedPropertiesRule.this.elementNames.containsKey(this.currChildElementName) && (string2 = (String)SetNestedPropertiesRule.this.elementNames.get(this.currChildElementName)) == null) {
                return;
            }
            boolean bl = SetNestedPropertiesRule.this.log.isDebugEnabled();
            if (bl) {
                SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.digester.match + "} Setting property '" + string2 + "' to '" + string + "'");
            }
            Object object2 = this.digester.peek();
            if (bl) {
                if (object2 != null) {
                    SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.digester.match + "} Set " + object2.getClass().getName() + " properties");
                } else {
                    SetNestedPropertiesRule.this.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
                }
            }
            if (SetNestedPropertiesRule.this.trimData) {
                string = string.trim();
            }
            if (!SetNestedPropertiesRule.this.allowUnknownChildElements && (object2 instanceof DynaBean ? (object = ((DynaBean)object2).getDynaClass().getDynaProperty(string2)) == null : (object = PropertyUtils.getPropertyDescriptor(object2, string2)) == null)) {
                throw new NoSuchMethodException("Bean has no property named " + string2);
            }
            try {
                BeanUtils.setProperty(object2, string2, string);
            }
            catch (NullPointerException nullPointerException) {
                SetNestedPropertiesRule.this.log.error("NullPointerException: top=" + object2 + ",propName=" + string2 + ",value=" + string + "!");
                throw nullPointerException;
            }
        }

        public void end(String string, String string2) throws Exception {
            this.currChildElementName = null;
        }
    }
}

