/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.codec.Base64FormatException;

public class JRValueStringUtils {
    private static final Map serializers = JRValueStringUtils.getSerializers();
    private static final ValueSerializer defaultSerializer = new DefaultSerializer();

    public static String serialize(String string, Object object) {
        String string2;
        if (object == null) {
            string2 = null;
        } else {
            ValueSerializer valueSerializer = JRValueStringUtils.getSerializer(string);
            string2 = valueSerializer.serialize(object);
        }
        return string2;
    }

    public static Object deserialize(String string, String string2) {
        Object object;
        if (string2 == null) {
            object = null;
        } else {
            ValueSerializer valueSerializer = JRValueStringUtils.getSerializer(string);
            object = valueSerializer.deserialize(string2);
        }
        return object;
    }

    protected static ValueSerializer getSerializer(String string) {
        ValueSerializer valueSerializer = (ValueSerializer)serializers.get(string);
        if (valueSerializer == null) {
            valueSerializer = defaultSerializer;
        }
        return valueSerializer;
    }

    private static Map getSerializers() {
        HashMap<String, ValueSerializer> hashMap = new HashMap<String, ValueSerializer>();
        hashMap.put(String.class.getName(), new StringSerializer());
        hashMap.put(Character.class.getName(), new CharacterSerializer());
        hashMap.put(Boolean.class.getName(), new BooleanSerializer());
        hashMap.put(Byte.class.getName(), new ByteSerializer());
        hashMap.put(Short.class.getName(), new ShortSerializer());
        hashMap.put(Integer.class.getName(), new IntegerSerializer());
        hashMap.put(Long.class.getName(), new LongSerializer());
        hashMap.put(Float.class.getName(), new FloatSerializer());
        hashMap.put(Double.class.getName(), new DoubleSerializer());
        hashMap.put(BigInteger.class.getName(), new BigIntegerSerializer());
        hashMap.put(BigDecimal.class.getName(), new BigDecimalSerializer());
        hashMap.put(Date.class.getName(), new DateSerializer());
        hashMap.put(Timestamp.class.getName(), new TimestampSerializer());
        hashMap.put(Time.class.getName(), new TimeSerializer());
        return hashMap;
    }

    protected static interface ValueSerializer {
        public String serialize(Object var1);

        public Object deserialize(String var1);
    }

    protected static class StringSerializer
    implements ValueSerializer {
        protected StringSerializer() {
        }

        public Object deserialize(String string) {
            return string;
        }

        public String serialize(Object object) {
            return (String)object;
        }
    }

    protected static class CharacterSerializer
    implements ValueSerializer {
        protected CharacterSerializer() {
        }

        public Object deserialize(String string) {
            if (string.length() != 1) {
                throw new JRRuntimeException("Character data \"" + string + "\" should be exactly one character long");
            }
            return new Character(string.charAt(0));
        }

        public String serialize(Object object) {
            return String.valueOf(new char[]{((Character)object).charValue()});
        }
    }

    protected static class BooleanSerializer
    implements ValueSerializer {
        protected BooleanSerializer() {
        }

        public Object deserialize(String string) {
            if (string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("false")) {
                return Boolean.FALSE;
            }
            throw new JRRuntimeException("Unkown boolean data \"" + string + "\"");
        }

        public String serialize(Object object) {
            return (Boolean)object != false ? "true" : "false";
        }
    }

    protected static class ByteSerializer
    implements ValueSerializer {
        protected ByteSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Byte.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Byte data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Byte)object).toString();
        }
    }

    protected static class ShortSerializer
    implements ValueSerializer {
        protected ShortSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Short data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Short)object).toString();
        }
    }

    protected static class IntegerSerializer
    implements ValueSerializer {
        protected IntegerSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Integer data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Integer)object).toString();
        }
    }

    protected static class LongSerializer
    implements ValueSerializer {
        protected LongSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Long data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Long)object).toString();
        }
    }

    protected static class FloatSerializer
    implements ValueSerializer {
        protected FloatSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Float data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Float)object).toString();
        }
    }

    protected static class DoubleSerializer
    implements ValueSerializer {
        protected DoubleSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Double data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Double)object).toString();
        }
    }

    protected static class BigIntegerSerializer
    implements ValueSerializer {
        protected BigIntegerSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing BigInteger data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((BigInteger)object).toString();
        }
    }

    protected static class BigDecimalSerializer
    implements ValueSerializer {
        protected BigDecimalSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing BigDecimal data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((BigDecimal)object).toString();
        }
    }

    protected static class DateSerializer
    implements ValueSerializer {
        protected DateSerializer() {
        }

        public Object deserialize(String string) {
            try {
                long l = Long.parseLong(string);
                return new Date(l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Date data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return Long.toString(((Date)object).getTime());
        }
    }

    protected static class TimestampSerializer
    implements ValueSerializer {
        protected TimestampSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Timestamp.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JRRuntimeException("Error parsing Timestamp data \"" + string + "\"", illegalArgumentException);
            }
        }

        public String serialize(Object object) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.toString();
        }
    }

    protected static class TimeSerializer
    implements ValueSerializer {
        protected TimeSerializer() {
        }

        public Object deserialize(String string) {
            try {
                return Time.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JRRuntimeException("Error parsing Time data \"" + string + "\"", illegalArgumentException);
            }
        }

        public String serialize(Object object) {
            Time time = (Time)object;
            return time.toString();
        }
    }

    protected static class DefaultSerializer
    implements ValueSerializer {
        protected DefaultSerializer() {
        }

        public Object deserialize(String string) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64Decoder base64Decoder = new Base64Decoder(byteArrayInputStream, byteArrayOutputStream);
                base64Decoder.process();
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream2);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
            catch (Base64FormatException base64FormatException) {
                throw new JRRuntimeException(base64FormatException);
            }
        }

        public String serialize(Object object) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Base64Encoder base64Encoder = new Base64Encoder(byteArrayInputStream, byteArrayOutputStream2);
                base64Encoder.process();
                return new String(byteArrayOutputStream2.toByteArray(), "UTF-8");
            }
            catch (NotSerializableException notSerializableException) {
                throw new JRRuntimeException("Value is not serializable", notSerializableException);
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
        }
    }
}

