/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPublicKeyRecipient;
import com.lowagie.text.pdf.PdfPublicKeySecurityHandler;
import com.lowagie.text.pdf.StandardDecryption;
import com.lowagie.text.pdf.crypto.RC4Encryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption {
    public static final int RC4_40 = 2;
    public static final int RC4_128 = 3;
    public static final int AES_128 = 4;
    private static final byte[] pad;
    private static final byte[] salt;
    private static final byte[] metadataPad;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    protected PdfPublicKeySecurityHandler publicKeyHandler = null;
    int permissions;
    byte[] documentID;
    static long seq;
    private int revision;
    private RC4Encryption rc4 = new RC4Encryption();
    private int keyLength;
    private boolean encryptMetadata;
    private int cryptoMode;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        pad = byArray;
        salt = new byte[]{115, 65, 108, 84};
        metadataPad = new byte[]{-1, -1, -1, -1};
        seq = System.currentTimeMillis();
    }

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.publicKeyHandler = new PdfPublicKeySecurityHandler();
    }

    public PdfEncryption(PdfEncryption pdfEncryption) {
        this();
        this.mkey = (byte[])pdfEncryption.mkey.clone();
        this.ownerKey = (byte[])pdfEncryption.ownerKey.clone();
        this.userKey = (byte[])pdfEncryption.userKey.clone();
        this.permissions = pdfEncryption.permissions;
        if (pdfEncryption.documentID != null) {
            this.documentID = (byte[])pdfEncryption.documentID.clone();
        }
        this.revision = pdfEncryption.revision;
        this.keyLength = pdfEncryption.keyLength;
        this.encryptMetadata = pdfEncryption.encryptMetadata;
        this.publicKeyHandler = pdfEncryption.publicKeyHandler;
    }

    public void setCryptoMode(int n, int n2) {
        this.cryptoMode = n;
        this.encryptMetadata = (n & 8) == 0;
        switch (n &= 7) {
            case 0: {
                this.encryptMetadata = true;
                this.keyLength = 40;
                this.revision = 2;
                break;
            }
            case 1: {
                this.keyLength = n2 > 0 ? n2 : 128;
                this.revision = 3;
                break;
            }
            case 2: {
                this.keyLength = 128;
                this.revision = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid encryption mode");
            }
        }
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public boolean isMetadataEncrypted() {
        return this.encryptMetadata;
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.md5.digest(byArray2);
        if (this.revision == 3 || this.revision == 4) {
            byte[] byArray5 = new byte[this.keyLength / 8];
            int n = 0;
            while (n < 50) {
                System.arraycopy(this.md5.digest(byArray4), 0, byArray4, 0, byArray5.length);
                ++n;
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            n = 0;
            while (n < 20) {
                int n2 = 0;
                while (n2 < byArray5.length) {
                    byArray5[n2] = (byte)(byArray4[n2] ^ n);
                    ++n2;
                }
                this.rc4.prepareRC4Key(byArray5);
                this.rc4.encryptRC4(byArray3);
                ++n;
            }
        } else {
            this.rc4.prepareRC4Key(byArray4, 0, 5);
            this.rc4.encryptRC4(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.documentID = byArray;
        this.ownerKey = byArray3;
        this.permissions = n;
        this.mkey = new byte[this.keyLength / 8];
        this.md5.reset();
        this.md5.update(byArray2);
        this.md5.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.md5.update(byArray4, 0, 4);
        if (byArray != null) {
            this.md5.update(byArray);
        }
        if (!this.encryptMetadata) {
            this.md5.update(metadataPad);
        }
        byte[] byArray5 = new byte[this.mkey.length];
        System.arraycopy(this.md5.digest(), 0, byArray5, 0, this.mkey.length);
        if (this.revision == 3 || this.revision == 4) {
            int n2 = 0;
            while (n2 < 50) {
                System.arraycopy(this.md5.digest(byArray5), 0, byArray5, 0, this.mkey.length);
                ++n2;
            }
        }
        System.arraycopy(byArray5, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey() {
        if (this.revision == 3 || this.revision == 4) {
            this.md5.update(pad);
            byte[] byArray = this.md5.digest(this.documentID);
            System.arraycopy(byArray, 0, this.userKey, 0, 16);
            int n = 16;
            while (n < 32) {
                this.userKey[n] = 0;
                ++n;
            }
            n = 0;
            while (n < 20) {
                int n2 = 0;
                while (n2 < this.mkey.length) {
                    byArray[n2] = (byte)(this.mkey[n2] ^ n);
                    ++n2;
                }
                this.rc4.prepareRC4Key(byArray, 0, this.mkey.length);
                this.rc4.encryptRC4(this.userKey, 0, 16);
                ++n;
            }
        } else {
            this.rc4.prepareRC4Key(this.mkey);
            this.rc4.encryptRC4(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.md5.digest(PdfEncryption.createDocumentId());
        }
        n |= this.revision == 3 || this.revision == 4 ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.ownerKey = this.computeOwnerKey(byArray3, byArray4);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, byArray3, this.ownerKey, n &= 0xFFFFFFFC);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().freeMemory();
        String string = String.valueOf(l) + "+" + l2 + "+" + seq++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n);
        this.setupUserKey();
    }

    public void setupByEncryptionKey(byte[] byArray, int n) {
        this.mkey = new byte[n / 8];
        System.arraycopy(byArray, 0, this.mkey, 0, this.mkey.length);
    }

    public void setHashKey(int n, int n2) {
        this.md5.reset();
        this.extra[0] = (byte)n;
        this.extra[1] = (byte)(n >> 8);
        this.extra[2] = (byte)(n >> 16);
        this.extra[3] = (byte)n2;
        this.extra[4] = (byte)(n2 >> 8);
        this.md5.update(this.mkey);
        this.md5.update(this.extra);
        if (this.revision == 4) {
            this.md5.update(salt);
        }
        this.key = this.md5.digest();
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        int n = 0;
        while (n < 16) {
            byteBuffer.appendHex(byArray[n]);
            ++n;
        }
        byteBuffer.append('>').append('<');
        byArray = PdfEncryption.createDocumentId();
        n = 0;
        while (n < 16) {
            byteBuffer.appendHex(byArray[n]);
            ++n;
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (this.publicKeyHandler.getRecipientsSize() > 0) {
            Object object;
            Object object2;
            PdfArray pdfArray = null;
            pdfDictionary.put(PdfName.FILTER, PdfName.PUBSEC);
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            try {
                pdfArray = this.publicKeyHandler.getEncodedRecipients();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else {
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S5);
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).put(PdfName.RECIPIENTS, pdfArray);
                if (!this.encryptMetadata) {
                    ((PdfDictionary)object2).put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                if (this.revision == 4) {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.AESV2);
                } else {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.V2);
                }
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.DEFAULTCRYPTFILER, (PdfObject)object2);
                pdfDictionary.put(PdfName.CF, (PdfObject)object);
                pdfDictionary.put(PdfName.STRF, PdfName.DEFAULTCRYPTFILER);
                pdfDictionary.put(PdfName.STMF, PdfName.DEFAULTCRYPTFILER);
            }
            object2 = null;
            object = null;
            try {
                object2 = MessageDigest.getInstance("SHA-1");
                ((MessageDigest)object2).update(this.publicKeyHandler.getSeed());
                int n = 0;
                while (n < this.publicKeyHandler.getRecipientsSize()) {
                    object = this.publicKeyHandler.getEncodedRecipient(n);
                    ((MessageDigest)object2).update((byte[])object);
                    ++n;
                }
                if (!this.encryptMetadata) {
                    ((MessageDigest)object2).update(new byte[]{-1, -1, -1, -1});
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            byte[] byArray = ((MessageDigest)object2).digest();
            this.setupByEncryptionKey(byArray, this.keyLength);
        } else {
            pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
            pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
            pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
            pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
            } else {
                if (!this.encryptMetadata) {
                    pdfDictionary.put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.put(PdfName.LENGTH, new PdfNumber(16));
                pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.DOCOPEN);
                if (this.revision == 4) {
                    pdfDictionary2.put(PdfName.CFM, PdfName.AESV2);
                } else {
                    pdfDictionary2.put(PdfName.CFM, PdfName.V2);
                }
                PdfDictionary pdfDictionary3 = new PdfDictionary();
                pdfDictionary3.put(PdfName.STDCF, pdfDictionary2);
                pdfDictionary.put(PdfName.CF, pdfDictionary3);
                pdfDictionary.put(PdfName.STRF, PdfName.STDCF);
                pdfDictionary.put(PdfName.STMF, PdfName.STDCF);
            }
        }
        return pdfDictionary;
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream outputStream) {
        return new OutputStreamEncryption(outputStream, this.key, 0, this.keySize, this.revision);
    }

    public int calculateStreamSize(int n) {
        if (this.revision == 4) {
            return (n & 0x7FFFFFF0) + 32;
        }
        return n;
    }

    public byte[] encryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamEncryption outputStreamEncryption = this.getEncryptionStream(byteArrayOutputStream);
            outputStreamEncryption.write(byArray);
            outputStreamEncryption.finish();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public StandardDecryption getDecryptor() {
        return new StandardDecryption(this.key, 0, this.keySize, this.revision);
    }

    public byte[] decryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StandardDecryption standardDecryption = this.getDecryptor();
            byte[] byArray2 = standardDecryption.update(byArray, 0, byArray.length);
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            if ((byArray2 = standardDecryption.finish()) != null) {
                byteArrayOutputStream.write(byArray2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addRecipient(Certificate certificate, int n) {
        this.documentID = PdfEncryption.createDocumentId();
        this.publicKeyHandler.addRecipient(new PdfPublicKeyRecipient(certificate, n));
    }

    public byte[] computeUserPassword(byte[] byArray) {
        byte[] byArray2 = this.computeOwnerKey(this.ownerKey, this.padPassword(byArray));
        int n = 0;
        while (n < byArray2.length) {
            boolean bl = true;
            int n2 = 0;
            if (n2 < byArray2.length - n) {
                if (byArray2[n + n2] != pad[n2]) {
                    bl = false;
                }
            }
            if (bl) {
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray2, 0, byArray3, 0, n);
                return byArray3;
            }
            ++n;
        }
        return byArray2;
    }
}

