dnl Host type recognition and some other utility macros.
dnl This file is part of GNU Ad HoC.
dnl Copyright (C) 1998, 1999 Alexandre Oliva
dnl Copyright (C) 1999 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Ad HoC.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Ad HoC appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Ad HoC program.
dnl
dnl Certain portions of the Ad HoC source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Ad HoC.  We call these the "data" portions.  The rest of the Ad HoC
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Ad HoC never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Ad HoC
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Ad HoC, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.

dnl AH_SET_DIR[(DIR)]
AH_DEFUN(AH_SET_DIR, [dnl
ahdir=ifelse($#, 1, [$1], [dnl
${ahdir-`echo "[$]0" | sed -e 's%[[^/]]*$%.%' -e 's%/\\.$%%'`}])])

dnl AH_SET_HOST_NAME[(NAME)]
AH_DEFUN(AH_SET_HOST_NAME, [hostname=ifelse($#, 1, [$1], [${hostname-`uname -n`}])])

dnl AH_SET_HOST_TYPE[(SYSTEM_TYPE)]
AH_DEFUN(AH_SET_HOST_TYPE, [sysname=ifelse($#, 1, [$1], [${sysname-`${ADHOC_SHELL-/bin/sh} ${ahdir+$ahdir/}config.guess`}])])

dnl AH_GUESS_HOST_TYPE
AH_DEFUN(AH_GUESS_HOST_TYPE, [dnl
AH_SET_HOST_NAME
AH_SET_HOST_TYPE
])

dnl AH_AUTO_UPDATE[(shell-script[, adhoc-script])]
AH_DEFUN(AH_AUTO_UPDATE, [dnl
IF_NEWER([ifelse($#, 2, [$2], $#, 1, [$1].in, "[$]0.in")],
	 [ifelse($#, 2, [$1], $#, 1, [$1], "[$]0")], [dnl
adhoc -o ifelse($#, 2, [$2], $#, 1, [$1].in, "[$]0.in") dnl
ifelse($#, 2, [$1], $#, 1, [$1], "[$]0") && dnl
exec ${ADHOC_SHELL-/bin/sh} ifelse($#, 2, [$2], "[$]0")])])

dnl AH_MK_TMP_DIR[(TEMPDIR[, SUBDIR])]
AH_DEFUN(AH_MK_TMP_DIR, [dnl
ahtmpdir=ifelse($#, 2, [$1/$2], $#, 1, [$1/ah$$], ["${ahtmpdir-${TMPDIR-/tmp}/ah$$}"]) &&
(umask 077 && until mkdir "$ahtmpdir"; do rm -rf "$ahtmpdir"; done)])

dnl AH_RM_TMP_DIR
AH_DEFUN(AH_RM_TMP_DIR, [dnl
case "${ahtmpdir+set}" in set) rm -rf "$ahtmpdir";; esac])

dnl AH_TEMP_FILENAME[(FILENAME[, TEMPDIR])]
AH_DEFUN(AH_TEMP_FILENAME, [dnl
ifelse($#, 2, $2/$1, ["${ahtmpdir-/tmp}/"dnl
ifelse($#, 1, $1, adhoc.tmp)])])

dnl AH_case_list(CASE, CMD, ..., CASE, CMD[, CMD])
AH_DEFUN(AH_case_list, [dnl
ifelse($#, 0, [esac], $#, 1, [dnl
*[)] $1;;
esac], [$1[)] $2;;
AH_case_list(builtin(shift,builtin(shift,$@)))])])

dnl AH_ON_HOST(HOST|..., CMD[, HOST|..., CMD, ..., [CMD for others]])
AH_DEFUN(AH_ON_HOST, [AH_SET_HOST_NAME
[case "$hostname" in]
AH_case_list($@)])

dnl AH_ON_SYSTEM(SYSTEM|..., CMD[, SYSTEM|..., CMD, ..., [CMD for others]])
AH_DEFUN(AH_ON_SYSTEM, [AH_SET_HOST_TYPE
[case "$sysname" in]
AH_case_list($@)])
