dnl File and directory manipulation macros.
dnl This file is part of GNU Ad HoC.
dnl Copyright (C) 1998, 1999 Alexandre Oliva
dnl Copyright (C) 1999 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Ad HoC.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Ad HoC appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Ad HoC program.
dnl
dnl Certain portions of the Ad HoC source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Ad HoC.  We call these the "data" portions.  The rest of the Ad HoC
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Ad HoC never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Ad HoC
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Ad HoC, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.

dnl AH_IF_MISSING(FILE, THENCMD[, ELSECMD])
AH_DEFUN(AH_IF_MISSING, [dnl
if test ! -f $1
then $2
ifelse($#, 3, [else $3
])dnl
fi])

dnl AH_IF_MISSING_DIR(DIR, THENCMD[, ELSECMD])
AH_DEFUN(AH_IF_MISSING_DIR, [dnl
if test ! -d $1
then $2
ifelse($#, 3, [else $3
])dnl
fi])

dnl AH_IF_NEWER(FILE, LIST, THENCMD[, ELSECMD])
AH_DEFUN(AH_IF_NEWER, [dnl
if ah_newer=`ls -1dt $1 $2 2>/dev/null | sed 1q`; test "$ah_newer" = $1
then $3
ifelse($#, 4, [else $4
])dnl
fi])

dni AH_IF_DIFF(FILE, FILE, THENCMD[, ELSECMD])
AH_DEFUN(AH_IF_DIFF, [dnl
if cmp -s $1 $2; test $? != 0 
then $3
ifelse($#, 4, [else $4
])dnl
fi])

dnl AH_IF_DIFF_COPY(FROM, TO[, AFTERCMD])
AH_DEFUN(AH_IF_DIFF_COPY, [AH_IF_DIFF($1, $2, [cp $1 $2]dnl
ifelse($#, 3, [
$3],))])

dnl AH_IF_NEWER_COPY(FROM, TO[, AFTERCMD])
AH_DEFUN(AH_IF_NEWER_COPY, [AH_IF_NEWER($1, $2, [cp $1 $2]dnl
ifelse($#, 3, [
$3],))])

dnl AH_IF_NEWER_COPY_NO_CREATE(FROM, TO[, AFTERCMD])
AH_DEFUN(AH_IF_NEWER_COPY_NO_CREATE, [AH_IF_MISSING($2, :, ifelse($#, 3, AH_IF_NEWER_COPY($1, $2, $3), AH_IF_NEWER_COPY($1, $2)))])

dnl AH_IF_DIFF_COPY_FILES(FROMDIR, TODIR, FILE FILE ...)
AH_DEFUN(AH_IF_DIFF_COPY_FILES, [dnl
for f in $3
do AH_IF_DIFF_COPY($1/[$f], $2/[$f])
done])

dnl AH_IF_NEWER_COPY_FILES(FROMDIR, TODIR, FILE FILE ...)
AH_DEFUN(AH_IF_NEWER_COPY_FILES, [dnl
for f in $3
do AH_IF_NEWER_COPY($1/[$f], $2/[$f])
done])

dnl AH_IF_NEWER_COPY_FILES_NO_CREATE(FROMDIR, TODIR, FILE FILE ...)
AH_DEFUN(AH_IF_NEWER_COPY_FILES_NO_CREATE, [dnl
for f in $3
do AH_IF_NEWER_COPY_NO_CREATE($1/[$f], $2/[$f])
done])

dnl AH_IF_MISSING_SOFT_LINK(FROM, TO)
AH_DEFUN(AH_IF_MISSING_SOFT_LINK, [AH_IF_MISSING($2, ln -s $1 $2)])

dnl AH_IF_MISSING_DIR_SOFT_LINK(FROM, TO)
AH_DEFUN(AH_IF_MISSING_DIR_SOFT_LINK, [AH_IF_MISSING_DIR($2, ln -s $1 $2)])

dnl AH_IF_MISSING_HARD_LINK(FROM, TO)
AH_DEFUN(AH_IF_MISSING_HARD_LINK, [AH_IF_MISSING($2, ln $1 $2)])

dnl AH_IF_MISSING_DIR_HARD_LINK(FROM, TO)
AH_DEFUN(AH_IF_MISSING_DIR_HARD_LINK, [AH_IF_MISSING_DIR($2, ln $1 $2)])

dnl AH_IF_EGREP_FILE(REGEXP, FILE [FILE ...], THEN[, ELSE])
AH_DEFUN(AH_IF_EGREP_FILE, [dnl
if egrep -e '$1' $2 >/dev/null
then $3
ifelse($#, 4, [else $4
])[]dnl
fi])

dnl AH_IF_EGREP_CMD(REGEXP, CMD, THEN[, ELSE])
AH_DEFUN(AH_IF_EGREP_CMD, [dnl
if $2 | egrep -e '$1' >/dev/null
then $3
ifelse($#, 4, [else $4
])[]dnl
fi])

dnl AH_IF_FGREP_FILE(REGEXP, FILE [FILE ...], THEN[, ELSE])
AH_DEFUN(AH_IF_FGREP_FILE, [dnl
if fgrep -e $1 $2 >/dev/null
then $3
ifelse($#, 4, [else $4
])[]dnl
fi])

dnl AH_IF_FGREP_CMD(REGEXP, CMD, THEN[, ELSE])
AH_DEFUN(AH_IF_FGREP_CMD, [dnl
if $2 | fgrep -e $1
then $3
ifelse($#, 4, [else $4
])[]dnl
fi])
