/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public final class BitSet
implements Cloneable,
Serializable {
    private long[] bits;

    private static int bitOffset(int n) {
        return n >> 6;
    }

    private static long bitMask(int n) {
        return 1L << (n & 0x3F);
    }

    private void ensureSize(int n) {
        int n2 = BitSet.bitOffset(n + 63);
        if (n2 > this.bits.length) {
            long[] lArray = new long[n2];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[BitSet.bitOffset(n + 63)];
    }

    public synchronized void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(n + 1);
        int n2 = BitSet.bitOffset(n);
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(n);
    }

    public synchronized void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(n + 1);
        int n2 = BitSet.bitOffset(n);
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(n) ^ 0L - 1L);
    }

    public synchronized boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = BitSet.bitOffset(n);
        if (n2 < this.bits.length) {
            return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
        }
        return false;
    }

    public synchronized int length() {
        int n;
        long[] lArray = this.bits;
        for (n = lArray.length - 1; n >= 0 && lArray[n] == 0L; --n) {
        }
        if (n < 0) {
            return 0;
        }
        long l = lArray[n];
        long l2 = Long.MIN_VALUE;
        n = n + 1 << 6;
        while ((l & l2) == 0L) {
            --n;
            l2 >>= 1;
        }
        return n;
    }

    public int size() {
        return this.bits.length << 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (object == this) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (System.identityHashCode(this) < System.identityHashCode(object)) {
            object3 = this;
            object2 = object;
        } else {
            object3 = object;
            object2 = this;
        }
        Object object4 = object3;
        synchronized (object4) {
            try {
                Object object5 = object2;
                synchronized (object5) {
                    try {
                        int n;
                        long[] lArray = this.bits;
                        long[] lArray2 = ((BitSet)object).bits;
                        int n2 = n = Math.min(lArray.length, lArray2.length);
                        while (n2-- > 0) {
                            if (lArray[n2] == lArray2[n2]) continue;
                            return false;
                        }
                        if (n != lArray2.length) {
                            lArray = lArray2;
                        } else if (n == lArray.length) {
                            return true;
                        }
                        int n3 = lArray.length;
                        do {
                            if (n3-- <= n) return true;
                        } while (lArray[n3] == 0L);
                        return false;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                throw throwable;
            }
        }
    }

    public void and(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet4 = bitSet3;
        synchronized (bitSet4) {
            try {
                BitSet bitSet5 = bitSet2;
                synchronized (bitSet5) {
                    try {
                        int n;
                        long[] lArray = this.bits;
                        long[] lArray2 = bitSet.bits;
                        int n2 = n = Math.min(lArray.length, lArray2.length);
                        while (n2-- > 0) {
                            int n3 = n2;
                            lArray[n3] = lArray[n3] & lArray2[n2];
                        }
                        int n4 = lArray.length;
                        while (n4-- > n) {
                            lArray[n4] = 0L;
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        throw throwable;
                    }
                }
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                throw throwable;
            }
        }
    }

    public void andNot(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            BitSet bitSet4 = this;
            synchronized (bitSet4) {
                try {
                    long[] lArray = this.bits;
                    int n = lArray.length;
                    while (n-- > 0) {
                        lArray[n] = 0L;
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    throw throwable;
                }
            }
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet5 = bitSet3;
        synchronized (bitSet5) {
            try {
                BitSet bitSet6 = bitSet2;
                synchronized (bitSet6) {
                    try {
                        int n;
                        long[] lArray = this.bits;
                        long[] lArray2 = bitSet.bits;
                        int n2 = n = Math.min(lArray.length, lArray2.length);
                        while (n2-- > 0) {
                            int n3 = n2;
                            lArray[n3] = lArray[n3] & (lArray2[n2] ^ 0L - 1L);
                        }
                        Object var11_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_17 = null;
                        throw throwable;
                    }
                }
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                throw throwable;
            }
        }
    }

    public void or(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet4 = bitSet3;
        synchronized (bitSet4) {
            try {
                BitSet bitSet5 = bitSet2;
                synchronized (bitSet5) {
                    try {
                        int n;
                        long[] lArray = this.bits;
                        long[] lArray2 = bitSet.bits;
                        int n2 = n = Math.min(lArray.length, lArray2.length);
                        while (n2-- > 0) {
                            int n3 = n2;
                            lArray[n3] = lArray[n3] | lArray2[n2];
                        }
                        if (lArray.length < lArray2.length) {
                            this.ensureSize(bitSet.length());
                            lArray = this.bits;
                            int n4 = this.bits.length;
                            while (n4-- > n) {
                                lArray[n4] = lArray2[n4];
                            }
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        throw throwable;
                    }
                }
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                throw throwable;
            }
        }
    }

    public void xor(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            BitSet bitSet4 = this;
            synchronized (bitSet4) {
                try {
                    long[] lArray = this.bits;
                    int n = lArray.length;
                    while (n-- > 0) {
                        lArray[n] = 0L;
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    throw throwable;
                }
            }
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet5 = bitSet3;
        synchronized (bitSet5) {
            try {
                BitSet bitSet6 = bitSet2;
                synchronized (bitSet6) {
                    try {
                        int n;
                        long[] lArray = this.bits;
                        long[] lArray2 = bitSet.bits;
                        int n2 = n = Math.min(lArray.length, lArray2.length);
                        while (n2-- > 0) {
                            int n3 = n2;
                            lArray[n3] = lArray[n3] ^ lArray2[n2];
                        }
                        if (lArray.length < lArray2.length) {
                            this.ensureSize(bitSet.length());
                            lArray = this.bits;
                            int n4 = this.bits.length;
                            while (n4-- > n) {
                                lArray[n4] = lArray2[n4];
                            }
                        }
                        Object var12_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        throw throwable;
                    }
                }
                Object var14_20 = null;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                throw throwable;
            }
        }
    }

    public synchronized int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public synchronized Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, bitSet.bits.length);
        return bitSet;
    }

    public synchronized String toString() {
        int n = this.length();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(i);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

