/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import kaffe.util.NotImplemented;

public class SimpleDateFormat
extends DateFormat {
    private static final String DEFAULTPATTERNCHARS = "GyMdkHmsSEDFwWahKz";
    private DateFormatSymbols syms;
    private String pattern;

    public SimpleDateFormat() {
        this("", Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale2) {
        this.syms = new DateFormatSymbols(locale2);
        this.pattern = string;
        this.calendar = new GregorianCalendar(locale2);
        this.format = new DecimalFormat("0", locale2);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
        this.pattern = string;
        this.calendar = new GregorianCalendar();
        this.format = new DecimalFormat("0");
    }

    public void applyLocalizedPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.syms.getLocalPatternChars();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = string2.indexOf(c);
            if (n >= 0) {
                stringBuffer.append(DEFAULTPATTERNCHARS.charAt(n));
                continue;
            }
            stringBuffer.append(c);
            if (c != '\'') continue;
            do {
                c = string.charAt(++i);
                stringBuffer.append(c);
            } while (c != '\'');
        }
        this.pattern = stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        char[] cArray = this.pattern.toCharArray();
        int n = 0;
        block21: while (n < cArray.length) {
            int n2 = 0;
            char c = cArray[n];
            ++n;
            if (c != '\'') {
                ++n2;
                while (n < cArray.length && cArray[n] == c) {
                    ++n2;
                    ++n;
                }
            }
            int n3 = stringBuffer.length();
            switch (c) {
                case 'G': {
                    int n4 = this.calendar.get(0);
                    stringBuffer.append(this.syms.eras[n4]);
                    if (fieldPosition.field != 0) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'y': {
                    int n4 = this.calendar.get(1);
                    if (n2 < 4 && (n4 %= 100) < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 1) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'M': {
                    int n4 = this.calendar.get(2);
                    if (n2 < 3) {
                        if (n4 < 10 && n2 == 2) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n4);
                    } else if (n2 == 3) {
                        stringBuffer.append(this.syms.shortMonths[n4]);
                    } else {
                        stringBuffer.append(this.syms.months[n4]);
                    }
                    if (fieldPosition.field != 2) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'd': {
                    int n4 = this.calendar.get(5);
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 3) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'k': {
                    int n4 = this.calendar.get(11);
                    if (n4 == 0) {
                        n4 = 24;
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 4) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'H': {
                    int n4 = this.calendar.get(11);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 5) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'm': {
                    int n4 = this.calendar.get(12);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 6) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 's': {
                    int n4 = this.calendar.get(13);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 7) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'S': {
                    int n4 = this.calendar.get(14);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 8) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'E': {
                    int n4 = this.calendar.get(7);
                    if (n2 < 4) {
                        stringBuffer.append(this.syms.shortWeekdays[n4]);
                    } else {
                        stringBuffer.append(this.syms.weekdays[n4]);
                    }
                    if (fieldPosition.field != 9) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'D': {
                    int n4 = this.calendar.get(6);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 10) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'F': {
                    int n4 = this.calendar.get(8);
                    stringBuffer.append(n4);
                    break;
                }
                case 'w': {
                    int n4 = this.calendar.get(3);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 12) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'W': {
                    int n4 = this.calendar.get(4);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 13) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'a': {
                    int n4 = this.calendar.get(9);
                    stringBuffer.append(this.syms.amPmStrings[n4]);
                    if (fieldPosition.field != 14) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'h': {
                    int n4 = this.calendar.get(10);
                    if (n4 == 0) {
                        n4 = 12;
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 15) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'K': {
                    int n4 = this.calendar.get(10);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 16) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'z': {
                    int n5;
                    TimeZone timeZone = this.calendar.getTimeZone();
                    String string = timeZone.getID();
                    boolean bl = timeZone.inDaylightTime(date);
                    for (n5 = 0; n5 < this.syms.zoneStrings.length; ++n5) {
                        String[] stringArray = this.syms.zoneStrings[n5];
                        if (!string.equals(stringArray[0])) continue;
                        if (n2 < 4) {
                            if (bl) {
                                stringBuffer.append(stringArray[4]);
                                break;
                            }
                            stringBuffer.append(stringArray[2]);
                            break;
                        }
                        if (bl) {
                            stringBuffer.append(stringArray[3]);
                            break;
                        }
                        stringBuffer.append(stringArray[1]);
                        break;
                    }
                    if (n5 == this.syms.zoneStrings.length) {
                        stringBuffer.append("GMT");
                        int n6 = timeZone.getRawOffset() / 60000;
                        if (n6 < 0) {
                            n6 = Math.abs(n6);
                            stringBuffer.append("-");
                        } else {
                            stringBuffer.append("+");
                        }
                        stringBuffer.append(n6 / 60);
                        stringBuffer.append(":");
                        if (n6 % 60 < 10) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(n6 % 60);
                    }
                    if (fieldPosition.field != 17) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case '\'': {
                    if (cArray[n] == '\'') {
                        stringBuffer.append('\'');
                        ++n;
                        break;
                    }
                    while (cArray[n] != '\'') {
                        stringBuffer.append(cArray[n]);
                        ++n;
                    }
                    ++n;
                    break;
                }
                default: {
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer.append(c);
                    }
                    continue block21;
                }
            }
        }
        return stringBuffer;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.syms;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Date parse(String string, ParsePosition parsePosition) {
        throw new NotImplemented();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
    }

    public String toLocalizePattern() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.syms.getLocalPatternChars();
        for (int i = 0; i < this.pattern.length(); ++i) {
            int n = DEFAULTPATTERNCHARS.indexOf(this.pattern.charAt(i));
            if (n >= 0) {
                stringBuffer.append(string.charAt(n));
                continue;
            }
            stringBuffer.append(this.pattern.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }
}

