/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.Format;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class Collator
implements Cloneable,
Serializable {
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int IDENTICAL = 3;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    private int mode = 0;
    private int strength = 0;

    protected Collator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract int compare(String var1, String var2);

    public boolean equals(Object object) {
        try {
            Collator collator = (Collator)object;
            if (this.mode == collator.mode && this.strength == collator.strength) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(String string, String string2) {
        return string.equals(string2);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return Format.getAvailableLocales("collator");
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.mode;
    }

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static synchronized Collator getInstance(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("collator", locale2);
        return new RuleBasedCollator("");
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int n) {
        this.mode = n;
    }

    public synchronized void setStrength(int n) {
        this.strength = n;
    }
}

