/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import kaffe.util.Deprecated;

public class ThreadGroup {
    private ThreadGroup parent;
    private String name;
    private int maxPriority;
    private boolean destroyed = false;
    private boolean daemon = false;
    private int nthreads = 0;
    private Thread[] threads;
    private int ngroups = 0;
    private ThreadGroup[] groups = new ThreadGroup[0];

    public ThreadGroup() {
        this(Thread.currentThread().getThreadGroup(), "main");
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        threadGroup.checkAccess();
        this.name = string;
        this.parent = threadGroup;
        this.maxPriority = threadGroup.getMaxPriority();
        this.daemon = threadGroup.isDaemon();
        threadGroup.add(this);
    }

    public synchronized int activeCount() {
        int n = this.nthreads;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            n += this.groups[i].activeCount();
        }
        return n;
    }

    public synchronized int activeGroupCount() {
        int n = this.ngroups;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            n += this.groups[i].activeGroupCount();
        }
        return n;
    }

    public void add(Thread thread) {
        ++this.nthreads;
        if (this.threads == null) {
            this.threads = new Thread[1];
        }
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] != null) continue;
            this.threads[i] = thread;
            return;
        }
        Thread[] threadArray = new Thread[this.threads.length + 1];
        System.arraycopy(this.threads, 0, threadArray, 0, this.threads.length);
        this.threads = threadArray;
        this.threads[this.threads.length - 1] = thread;
    }

    public void add(ThreadGroup threadGroup) {
        ++this.ngroups;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != null) continue;
            this.groups[i] = threadGroup;
            return;
        }
        ThreadGroup[] threadGroupArray = new ThreadGroup[this.groups.length + 1];
        System.arraycopy(this.groups, 0, threadGroupArray, 0, this.groups.length);
        this.groups = threadGroupArray;
        this.groups[this.groups.length - 1] = threadGroup;
    }

    public boolean allowThreadSuspension(boolean bl) {
        return false;
    }

    public final void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    private int copyArray(Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n >= objectArray2.length) continue;
            objectArray2[n] = objectArray[i];
            ++n;
        }
        return n;
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (this.destroyed || this.activeCount() > 0) {
            throw new IllegalThreadStateException();
        }
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            this.groups[i].destroy();
            this.groups[i] = null;
        }
        this.ngroups = 0;
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.destroyed = true;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        return this.enumerate(threadGroupArray, true, 0);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        return this.enumerate(threadGroupArray, bl, 0);
    }

    private int enumerate(ThreadGroup[] threadGroupArray, boolean bl, int n) {
        n = this.copyArray(this.groups, threadGroupArray, n);
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            n = this.groups[i].enumerate(threadGroupArray, bl, n);
        }
        return n;
    }

    public int enumerate(Thread[] threadArray) {
        return this.enumerate(threadArray, true, 0);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        return this.enumerate(threadArray, bl, 0);
    }

    public int enumerate(Thread[] threadArray, boolean bl, int n) {
        n = this.copyArray(this.threads, threadArray, n);
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            n = this.groups[i].enumerate(threadArray, bl, n);
        }
        return n;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized void list() {
        this.list(0);
    }

    private void list(int n) {
        this.printLine(this.toString(), n);
        this.printThreads(n + 1);
        this.printGroups(n + 1);
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        return this.parent == threadGroup || this.parentOf(threadGroup.getParent());
    }

    private void printGroups(int n) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] == null) continue;
            this.groups[i].list(n);
        }
    }

    private void printLine(String string, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
        System.out.println(string);
    }

    private void printThreads(int n) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.printLine(this.threads[i].toString(), n);
        }
    }

    public void remove(Thread thread) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] != thread) continue;
            this.threads[i] = null;
            --this.nthreads;
            break;
        }
    }

    public void remove(ThreadGroup threadGroup) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != threadGroup) continue;
            this.groups[i] = null;
            --this.ngroups;
            break;
        }
    }

    public final synchronized void resume() {
        throw new Deprecated();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    public final synchronized void setMaxPriority(int n) {
        this.checkAccess();
        this.maxPriority = n;
    }

    public final synchronized void stop() {
        throw new Deprecated();
    }

    public final synchronized void suspend() {
        throw new Deprecated();
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("java.lang.ThreadGroup[name=").concat(String.valueOf(this.name))).concat(String.valueOf(",maxpri="))).concat(String.valueOf(this.maxPriority))).concat(String.valueOf("]"));
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        }
        throwable.printStackTrace();
    }
}

